/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlJavaInformationsReport {
    private static final String[] OS = new String[]{"linux", "windows", "mac", "solaris", "hp", "ibm"};
    private static final String[] APPLICATION_SERVERS = new String[]{"tomcat", "glassfish", "jonas", "jetty", "oracle", "bea", "ibm"};
    private static final double MIN_VALUE = 0.0;
    private static final double MAX_VALUE = 100.0;
    private static final int PARTIAL_BLOCKS = 5;
    private static final int FULL_BLOCKS = 10;
    private static final double UNIT_SIZE = 2.0;
    private static int uniqueByPageSequence;
    private final boolean noDatabase = Parameters.isNoDatabase();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final DecimalFormat decimalFormat = I18N.createPercentFormat();
    private final List<JavaInformations> javaInformationsList;
    private final Writer writer;

    HtmlJavaInformationsReport(List<JavaInformations> javaInformationsList, Writer writer) {
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (writer != null);
        this.javaInformationsList = javaInformationsList;
        this.writer = writer;
    }

    void toHtml() throws IOException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeSummary(javaInformations);
        }
        if (!this.noDatabase) {
            this.write("<br/><br/>");
        }
        String br = "<br/>";
        if (this.javaInformationsList.get(0).getSessionCount() >= 0) {
            this.write("<br/>");
        }
        if (this.javaInformationsList.get(0).getSystemLoadAverage() >= 0.0) {
            this.write("<br/>");
        }
        this.writeln("<br/><br/><br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeShowHideLink("detailsJava", "#Details#");
        this.writeln("<br/><br/>");
        this.writeln("<div id='detailsJava' style='display: none;'>");
        boolean repeatHost = this.javaInformationsList.size() > 1;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeDetails(javaInformations, repeatHost);
        }
        this.writeln("</div>");
    }

    private void writeSummary(JavaInformations javaInformations) throws IOException {
        String lineEnd = "</td> </tr>";
        String columnAndLineEnd = "</td><td></td> </tr>";
        this.writeln("<table align='left' border='0' cellspacing='0' cellpadding='2' summary='#Informations_systemes#'>");
        this.writeln("<tr><td>#Host#: </td><td><b>" + javaInformations.getHost() + "</b>" + "</td> </tr>");
        MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
        long usedMemory = memoryInformations.getUsedMemory();
        long maxMemory = memoryInformations.getMaxMemory();
        this.write("<tr><td>#memoire_utilisee#: </td><td>");
        this.writeGraph("usedMemory", this.integerFormat.format(usedMemory / 1024L / 1024L));
        this.writeln(" #Mo# / " + this.integerFormat.format(maxMemory / 1024L / 1024L) + " #Mo#&nbsp;&nbsp;&nbsp;</td><td>");
        this.writeln(HtmlJavaInformationsReport.toBar(memoryInformations.getUsedMemoryPercentage()));
        this.writeln("</td> </tr>");
        if (javaInformations.getSessionCount() >= 0) {
            this.write("<tr><td>#nb_sessions_http#: </td><td>");
            this.writeGraph("httpSessions", this.integerFormat.format(javaInformations.getSessionCount()));
            this.writeln("</td><td></td> </tr>");
        }
        this.write("<tr><td>#nb_threads_actifs#<br/>(#Requetes_http_en_cours#): </td><td>");
        this.writeGraph("activeThreads", this.integerFormat.format(javaInformations.getActiveThreadCount()));
        this.writeln("</td><td></td> </tr>");
        if (!this.noDatabase) {
            this.write("<tr><td>#nb_connexions_actives#: </td><td>");
            this.writeGraph("activeConnections", this.integerFormat.format(javaInformations.getActiveConnectionCount()));
            this.writeln("</td><td></td> </tr>");
            int usedConnectionCount = javaInformations.getUsedConnectionCount();
            int maxConnectionCount = javaInformations.getMaxConnectionCount();
            this.write("<tr><td>#nb_connexions_utilisees#<br/>(#ouvertes#): </td><td>");
            this.writeGraph("usedConnections", this.integerFormat.format(usedConnectionCount));
            if (maxConnectionCount > 0) {
                this.writeln(" / " + this.integerFormat.format(maxConnectionCount) + "&nbsp;&nbsp;&nbsp;</td><td>");
                this.writeln(HtmlJavaInformationsReport.toBar(javaInformations.getUsedConnectionPercentage()));
            }
            this.writeln("</td> </tr>");
        }
        if (javaInformations.getSystemLoadAverage() >= 0.0) {
            this.write("<tr><td>#Charge_systeme#</td><td>");
            this.writeGraph("systemLoad", this.decimalFormat.format(javaInformations.getSystemLoadAverage()));
            this.writeln("</td><td></td> </tr>");
        }
        this.writeln("</table>");
    }

    private void writeDetails(JavaInformations javaInformations, boolean repeatHost) throws IOException {
        String serverInfo;
        String columnEnd = "</td></tr>";
        this.writeln("<table align='left' border='0' cellspacing='0' cellpadding='2' summary='#Details_systeme#'>");
        if (repeatHost) {
            this.writeln("<tr><td>#Host#: </td><td><b>" + javaInformations.getHost() + "</b>" + "</td></tr>");
        }
        this.writeln("<tr><td>#OS#: </td><td>");
        String osIconName = HtmlJavaInformationsReport.getOSIconName(javaInformations.getOS());
        if (osIconName != null) {
            this.writeln("<img src='?resource=servers/" + osIconName + "' alt='#OS#'/>");
        }
        this.writeln(javaInformations.getOS() + " (" + javaInformations.getAvailableProcessors() + " #coeurs#)" + "</td></tr>");
        this.writeln("<tr><td>#Java#: </td><td>" + javaInformations.getJavaVersion() + "</td></tr>");
        this.writeln("<tr><td>#JVM#: </td><td>" + javaInformations.getJvmVersion() + "</td></tr>");
        this.writeln("<tr><td>#PID#: </td><td>" + javaInformations.getPID() + "</td></tr>");
        long unixOpenFileDescriptorCount = javaInformations.getUnixOpenFileDescriptorCount();
        if (unixOpenFileDescriptorCount >= 0L) {
            long unixMaxFileDescriptorCount = javaInformations.getUnixMaxFileDescriptorCount();
            this.write("<tr><td>#nb_fichiers#</td><td>");
            this.writeGraph("fileDescriptors", this.integerFormat.format(unixOpenFileDescriptorCount));
            this.writeln(" / " + this.integerFormat.format(unixMaxFileDescriptorCount) + "&nbsp;&nbsp;&nbsp;");
            this.writeln(HtmlJavaInformationsReport.toBar(javaInformations.getUnixOpenFileDescriptorPercentage()));
            this.writeln("</td></tr>");
        }
        if ((serverInfo = javaInformations.getServerInfo()) != null) {
            this.writeln("<tr><td>#Serveur#: </td><td>");
            String applicationServerIconName = HtmlJavaInformationsReport.getApplicationServerIconName(serverInfo);
            if (applicationServerIconName != null) {
                this.writeln("<img src='?resource=servers/" + applicationServerIconName + "' alt='#Serveur#'/>");
            }
            this.writeln(serverInfo + "</td></tr>");
            this.writeln("<tr><td>#Contexte_webapp#: </td><td>" + javaInformations.getContextPath() + "</td></tr>");
        }
        this.writeln("<tr><td>#Demarrage#: </td><td>" + I18N.createDateAndTimeFormat().format(javaInformations.getStartDate()) + "</td></tr>");
        this.writeln("<tr><td valign='top'>#Arguments_JVM#: </td><td>" + HtmlJavaInformationsReport.replaceEolWithBr(javaInformations.getJvmArguments()) + "</td></tr>");
        this.writeMemoryInformations(javaInformations.getMemoryInformations());
        if (javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.writeln("<tr><td>#Free_disk_space#: </td><td>" + this.integerFormat.format(javaInformations.getFreeDiskSpaceInTemp() / 1024L / 1024L) + " #Mo# " + "</td></tr>");
        }
        this.writeDatabaseVersionAndDataSourceDetails(javaInformations);
        if (javaInformations.isDependenciesEnabled()) {
            this.writeln("<tr><td valign='top'>#Dependencies#: </td><td>");
            this.writeDependencies(javaInformations);
            this.writeln("</td></tr>");
        }
        this.writeln("</table>");
    }

    private void writeDatabaseVersionAndDataSourceDetails(JavaInformations javaInformations) throws IOException {
        String columnEnd = "</td></tr>";
        if (!this.noDatabase && javaInformations.getDataBaseVersion() != null) {
            this.writeln("<tr><td valign='top'>#Base_de_donnees#: </td><td>" + HtmlJavaInformationsReport.replaceEolWithBr(javaInformations.getDataBaseVersion()).replaceAll("[&]", "&amp;") + "</td></tr>");
        }
        if (javaInformations.getDataSourceDetails() != null) {
            this.writeln("<tr><td valign='top'>#DataSource_jdbc#: </td><td>" + HtmlJavaInformationsReport.replaceEolWithBr(javaInformations.getDataSourceDetails()) + "<a href='http://commons.apache.org/dbcp/apidocs/org/apache/commons/dbcp/BasicDataSource.html'" + " class='noPrint' target='_blank'>DataSource reference</a>" + "</td></tr>");
        }
    }

    static String getOSIconName(String os) {
        String tmp = os.toLowerCase(Locale.getDefault());
        for (String anOS : OS) {
            if (!tmp.contains(anOS)) continue;
            return anOS + ".png";
        }
        return null;
    }

    static String getApplicationServerIconName(String appServer) {
        String tmp = appServer.toLowerCase(Locale.getDefault());
        for (String applicationServer : APPLICATION_SERVERS) {
            if (!tmp.contains(applicationServer)) continue;
            return applicationServer + ".png";
        }
        return null;
    }

    private void writeMemoryInformations(MemoryInformations memoryInformations) throws IOException {
        String columnEnd = "</td></tr>";
        this.writeln("<tr><td valign='top'>#Gestion_memoire#: </td><td>" + HtmlJavaInformationsReport.replaceEolWithBr(memoryInformations.getMemoryDetails()).replace(" Mo", " #Mo#") + "</td></tr>");
        long usedPermGen = memoryInformations.getUsedPermGen();
        if (usedPermGen > 0L) {
            long maxPermGen = memoryInformations.getMaxPermGen();
            this.writeln("<tr><td>#Memoire_Perm_Gen#: </td><td>" + this.integerFormat.format(usedPermGen / 1024L / 1024L) + " #Mo#");
            if (maxPermGen > 0L) {
                this.writeln(" / " + this.integerFormat.format(maxPermGen / 1024L / 1024L) + " #Mo#&nbsp;&nbsp;&nbsp;");
                this.writeln(HtmlJavaInformationsReport.toBar(memoryInformations.getUsedPermGenPercentage()));
            }
            this.writeln("</td></tr>");
        }
    }

    private void writeDependencies(JavaInformations javaInformations) throws IOException {
        int nbDependencies = javaInformations.getDependenciesList().size();
        this.writeln(I18N.getFormattedString("nb_dependencies", nbDependencies));
        if (nbDependencies > 0) {
            this.writeln(" ; &nbsp;&nbsp;&nbsp;");
            this.writeShowHideLink("detailsDependencies" + ++uniqueByPageSequence, "#Details#");
            if (javaInformations.doesPomXmlExists() && Parameters.isSystemActionsEnabled()) {
                this.writeln("&nbsp;&nbsp;&nbsp;<a href='?part=pom.xml' class='noPrint'>");
                this.writeln("<img src='?resource=xml.png' width='14' height='14' alt=\"#pom.xml#\"/> #pom.xml#</a>");
            }
            this.writeln("<br/>");
            this.writeln("<div id='detailsDependencies" + uniqueByPageSequence + "' style='display: none;'>");
            this.writeln(HtmlJavaInformationsReport.replaceEolWithBr(javaInformations.getDependencies()));
            this.writeln("</div>");
        }
    }

    private void writeGraph(String graph, String value) throws IOException {
        if (this.javaInformationsList.size() > 1) {
            this.write(value);
            return;
        }
        this.write("<a class='tooltip' href='?part=graph&amp;graph=");
        this.write(graph);
        this.write("'");
        this.write(" onmouseover=\"document.getElementById('");
        String id = "id" + graph;
        this.write(id);
        this.write("').src='?graph=");
        this.write(graph);
        this.write("&amp;width=100&amp;height=50'; this.onmouseover=null;\" >");
        this.write("<em><img src='?resource=systeminfo.png' id='");
        this.write(id);
        this.write("' alt='graph'/></em>");
        this.writer.write(value);
        this.write("</a>");
    }

    static String toBar(double percentValue) {
        int emptyBlocks;
        double myPercent = Math.max(Math.min(percentValue, 100.0), 0.0);
        StringBuilder sb = new StringBuilder();
        String body = "<img src=''?resource=bar/rb_{0}.gif'' alt=''+'' title=''" + I18N.createPercentFormat().format(myPercent) + "%'' />";
        int fullBlockCount = (int)Math.floor(myPercent / 10.0);
        int partialBlockIndex = (int)Math.floor((myPercent - (double)fullBlockCount * 2.0 * 5.0) / 2.0);
        sb.append(MessageFormat.format(body, fullBlockCount > 0 || partialBlockIndex > 0 ? "a" : "a0"));
        String fullBody = MessageFormat.format(body, 5);
        for (int i = 0; i < fullBlockCount; ++i) {
            sb.append(fullBody);
        }
        if (partialBlockIndex > 0) {
            String partialBody = MessageFormat.format(body, partialBlockIndex);
            sb.append(partialBody);
        }
        if ((emptyBlocks = 10 - fullBlockCount - (partialBlockIndex > 0 ? 1 : 0)) > 0) {
            String emptyBody = MessageFormat.format(body, 0);
            for (int i = 0; i < emptyBlocks; ++i) {
                sb.append(emptyBody);
            }
        }
        sb.append(MessageFormat.format(body, fullBlockCount == 10 ? "b" : "b0"));
        return sb.toString();
    }

    private static String replaceEolWithBr(String string) {
        return string.replaceAll("[\n]", "<br/>");
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

