/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorServlet
extends HttpServlet {
    private static final String BACK_LINK = "<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String COOKIE_NAME = "javamelody.application";
    private static final long serialVersionUID = -2070469677921953224L;
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private Pattern allowedAddrPattern;
    private final transient HttpCookieManager httpCookieManager = new HttpCookieManager();
    private transient CollectorServer collectorServer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Parameters.initialize(config.getServletContext());
        if (!Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG))) {
            LOGGER.setLevel(Level.WARN);
        }
        LOGGER.info((Object)"initialisation de la servlet de collecte du monitoring");
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        try {
            this.collectorServer = new CollectorServer();
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String application;
        long start;
        block7: {
            block6: {
                block5: {
                    start = System.currentTimeMillis();
                    if (this.isAddressAllowed(req)) {
                        resp.sendError(403, "Forbidden access");
                        return;
                    }
                    application = this.getApplication(req, resp);
                    I18N.bindLocale(req.getLocale());
                    try {
                        if (application == null) {
                            CollectorServlet.writeOnlyAddApplication(resp);
                            Object var7_5 = null;
                            break block5;
                        }
                        if (!this.collectorServer.isApplicationDataAvailable(application)) {
                            resp.sendError(500, "Data unavailable for the application " + application);
                            break block6;
                        }
                        this.doMonitoring(req, resp, application);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        I18N.unbindLocale();
                        if (!LOGGER.isDebugEnabled()) throw throwable;
                        LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
                        throw throwable;
                    }
                }
                I18N.unbindLocale();
                if (!LOGGER.isDebugEnabled()) return;
                LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
                return;
            }
            Object var7_6 = null;
            I18N.unbindLocale();
            if (!LOGGER.isDebugEnabled()) return;
            LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
            return;
        }
        Object var7_7 = null;
        I18N.unbindLocale();
        if (!LOGGER.isDebugEnabled()) return;
        LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block12: {
            block11: {
                block10: {
                    if (this.isAddressAllowed(req)) {
                        resp.sendError(403, "Forbidden access");
                        return;
                    }
                    String appName = req.getParameter("appName");
                    String appUrls = req.getParameter("appUrls");
                    I18N.bindLocale(req.getLocale());
                    try {
                        try {
                            if (appName == null || appUrls == null) {
                                this.writeMessage(req, resp, this.getApplication(req, resp), I18N.getString("donnees_manquantes"));
                                Object var8_5 = null;
                                break block10;
                            }
                            if (!appUrls.startsWith("http://") && !appUrls.startsWith("https://")) {
                                this.writeMessage(req, resp, this.getApplication(req, resp), I18N.getString("urls_format"));
                                break block11;
                            }
                            List<URL> urls = Parameters.parseUrl(appUrls);
                            this.collectorServer.addCollectorApplication(appName, urls);
                            LOGGER.info((Object)("ajout application monitor\u00e9e : " + appName));
                            LOGGER.info((Object)("urls de l'application monitor\u00e9e : " + urls));
                            CollectorServlet.showAlertAndRedirectTo(resp, I18N.getFormattedString("application_ajoutee", appName), "?application=" + appName);
                            break block12;
                        }
                        catch (FileNotFoundException e) {
                            String message = I18N.getString("monitoring_configure");
                            LOGGER.warn((Object)message, (Throwable)e);
                            this.writeMessage(req, resp, this.getApplication(req, resp), message + '\n' + e.toString());
                            Object var8_8 = null;
                            I18N.unbindLocale();
                            return;
                        }
                        catch (StreamCorruptedException e) {
                            String message = I18N.getFormattedString("reponse_non_comprise", appUrls);
                            LOGGER.warn((Object)message, (Throwable)e);
                            this.writeMessage(req, resp, this.getApplication(req, resp), message + '\n' + e.toString());
                            Object var8_9 = null;
                            I18N.unbindLocale();
                            return;
                        }
                        catch (Exception e) {
                            LOGGER.warn((Object)e.toString(), (Throwable)e);
                            this.writeMessage(req, resp, this.getApplication(req, resp), e.toString());
                            Object var8_10 = null;
                            I18N.unbindLocale();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_11 = null;
                        I18N.unbindLocale();
                        throw throwable;
                    }
                }
                I18N.unbindLocale();
                return;
            }
            Object var8_6 = null;
            I18N.unbindLocale();
            return;
        }
        Object var8_7 = null;
        I18N.unbindLocale();
    }

    private void doMonitoring(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        try {
            Collector collector = this.getCollectorByApplication(application);
            MonitoringController monitoringController = new MonitoringController(collector, this.collectorServer);
            String actionParameter = req.getParameter("action");
            if (actionParameter != null) {
                if ("remove_application".equalsIgnoreCase(actionParameter)) {
                    this.collectorServer.removeCollectorApplication(application);
                    String messageForReport = I18N.getFormattedString("application_enlevee", application);
                    CollectorServlet.showAlertAndRedirectTo(resp, messageForReport, "?");
                } else if (Action.valueOfIgnoreCase(actionParameter) != Action.CLEAR_COUNTER) {
                    String messageForReport = this.forwardActionAndUpdateData(req, application);
                    this.writeMessage(req, resp, application, messageForReport);
                } else {
                    String messageForReport = monitoringController.executeActionIfNeeded(req);
                    this.writeMessage(req, resp, application, messageForReport);
                }
                return;
            }
            String partParameter = req.getParameter("part");
            if (partParameter == null) {
                List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
                monitoringController.doReport(req, resp, javaInformationsList);
            } else {
                this.doPart(req, resp, application, monitoringController, partParameter);
            }
        }
        catch (RuntimeException e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
        catch (Exception e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController, String partParameter) throws IOException {
        if ("web.xml".equalsIgnoreCase(partParameter)) {
            MonitoringController.noCache(resp);
            this.doProxy(req, resp, application, "part=web.xml");
        } else if ("pom.xml".equalsIgnoreCase(partParameter)) {
            MonitoringController.noCache(resp);
            this.doProxy(req, resp, application, "part=pom.xml");
        } else if ("currentRequests".equalsIgnoreCase(partParameter)) {
            this.doCurrentRequests(req, resp, application);
        } else if ("processes".equalsIgnoreCase(partParameter)) {
            this.doProcesses(req, resp, application);
        } else if ("database".equalsIgnoreCase(partParameter)) {
            this.doDatabase(req, resp, application);
        } else if ("connections".equalsIgnoreCase(partParameter)) {
            this.doConnections(req, resp, application);
        } else {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        }
    }

    private void doProxy(HttpServletRequest req, HttpServletResponse resp, String application, String urlParameter) throws IOException {
        URL url = CollectorServlet.getUrlsByApplication(application).get(0);
        URL webXmlUrl = new URL(url.toString() + '&' + urlParameter);
        new LabradorRetriever(webXmlUrl).copyTo(req, resp);
    }

    private void doCurrentRequests(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        htmlReport.writeHtmlHeader(false);
        writer.write("<div class='noPrint'>");
        I18N.writelnTo(BACK_LINK, writer);
        writer.write("<a href='?part=");
        writer.write("currentRequests");
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        String title = I18N.getString("Requetes_en_cours");
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=hourglass.png' alt='" + title + "'/>" + title + " (" + CollectorServlet.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL currentRequestsUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "html").replace(TransportFormat.XML.getCode(), "html") + '&' + "part" + '=' + "currentRequests");
            new LabradorRetriever(currentRequestsUrl).copyTo(req, resp);
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doProcesses(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        htmlReport.writeHtmlHeader(false);
        writer.write("<div class='noPrint'>");
        I18N.writelnTo(BACK_LINK, writer);
        writer.write("<a href='?part=");
        writer.write("processes");
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        String title = I18N.getString("Processus");
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=threads.png' alt='" + title + "'/>&nbsp;" + title + " (" + CollectorServlet.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL processesUrl = new URL(url.toString() + '&' + "part" + '=' + "processes");
            List processes = (List)new LabradorRetriever(processesUrl).call();
            new HtmlProcessInformationsReport(processes, writer).writeTable();
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doDatabase(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        int requestIndex = req.getParameter("request") != null ? Integer.parseInt(req.getParameter("request")) : 0;
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        URL url = CollectorServlet.getUrlsByApplication(application).get(0);
        URL processesUrl = new URL(url.toString() + '&' + "part" + '=' + "database" + '&' + "request" + '=' + requestIndex);
        DatabaseInformations databaseInformations = (DatabaseInformations)new LabradorRetriever(processesUrl).call();
        htmlReport.writeDatabase(databaseInformations);
        writer.close();
    }

    private void doConnections(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, resp, writer, application);
        htmlReport.writeHtmlHeader(false);
        writer.write("<div class='noPrint'>");
        I18N.writelnTo(BACK_LINK, writer);
        writer.write("<a href='?part=");
        writer.write("connections");
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div><br/>");
        writer.write(I18N.getString("connexions_intro"));
        String title = I18N.getString("Connexions_jdbc_ouvertes");
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=db.png' alt='" + title + "'/>&nbsp;" + title + " (" + CollectorServlet.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL connectionsUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "htmlbody").replace(TransportFormat.XML.getCode(), "htmlbody") + '&' + "part" + '=' + "connections");
            new LabradorRetriever(connectionsUrl).copyTo(req, resp);
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, HttpServletResponse resp, PrintWriter writer, String application) {
        Range range = this.httpCookieManager.getRange(req, resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return new HtmlReport(collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
    }

    private static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    private void writeMessage(HttpServletRequest req, HttpServletResponse resp, String application, String message) throws IOException {
        MonitoringController.noCache(resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        if (application == null) {
            CollectorServlet.showAlertAndRedirectTo(resp, message, "?");
        } else {
            PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
            String partParameter = req.getParameter("part");
            new HtmlReport(collector, this.collectorServer, javaInformationsList, Period.TOUT, (Writer)writer).writeMessageIfNotNull(message, partParameter);
            writer.close();
        }
    }

    private Collector getCollectorByApplication(String application) {
        return this.collectorServer.getCollectorByApplication(application);
    }

    private List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.collectorServer.getJavaInformationsByApplication(application);
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        MonitoringController.noCache(httpResponse);
        httpResponse.setContentType("text/html; charset=UTF-8");
        return new PrintWriter(MonitoringController.getWriter(httpResponse));
    }

    private static void writeOnlyAddApplication(HttpServletResponse resp) throws IOException {
        MonitoringController.noCache(resp);
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        writer.write("<html><head><title>Monitoring</title></head><body>");
        HtmlReport.writeAddAndRemoveApplicationLinks(null, writer);
        writer.write("</body></html>");
        writer.close();
    }

    private static void showAlertAndRedirectTo(HttpServletResponse resp, String message, String redirectTo) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        writer.write("<script type='text/javascript'>alert('");
        writer.write(I18N.javascriptEncode(message));
        writer.write("');location.href='");
        writer.write(redirectTo);
        writer.write("';</script>");
        writer.close();
    }

    private boolean isAddressAllowed(HttpServletRequest req) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(req.getRemoteAddr()).matches();
    }

    private String forwardActionAndUpdateData(HttpServletRequest req, String application) throws IOException {
        String actionParameter = req.getParameter("action");
        String sessionIdParameter = req.getParameter("sessionId");
        String threadIdParameter = req.getParameter("threadId");
        String jobIdParameter = req.getParameter("jobId");
        List<URL> urls = CollectorServlet.getUrlsByApplication(application);
        ArrayList<URL> actionUrls = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            StringBuilder actionUrl = new StringBuilder(url.toString());
            actionUrl.append("&action=").append(actionParameter);
            if (sessionIdParameter != null) {
                actionUrl.append("&sessionId=").append(sessionIdParameter);
            }
            if (threadIdParameter != null) {
                actionUrl.append("&threadId=").append(threadIdParameter);
            }
            if (jobIdParameter != null) {
                actionUrl.append("&jobId=").append(jobIdParameter);
            }
            actionUrls.add(new URL(actionUrl.toString()));
        }
        return this.collectorServer.collectForApplication(application, actionUrls);
    }

    private String getApplication(HttpServletRequest req, HttpServletResponse resp) {
        String application = req.getParameter("application");
        if (application == null) {
            Cookie cookie = this.httpCookieManager.getCookieByName(req, COOKIE_NAME);
            if (cookie != null && !this.collectorServer.isApplicationDataAvailable(application = cookie.getValue())) {
                cookie.setMaxAge(-1);
                resp.addCookie(cookie);
                application = null;
            }
            if (application == null) {
                application = this.collectorServer.getFirstApplication();
            }
        } else if (this.collectorServer.isApplicationDataAvailable(application)) {
            this.httpCookieManager.addCookie(req, resp, COOKIE_NAME, String.valueOf(application));
        }
        return application;
    }

    private static List<URL> getUrlsByApplication(String application) throws IOException {
        return CollectorServer.getUrlsByApplication(application);
    }

    public void destroy() {
        LOGGER.info((Object)"servlet de collecte en phase d'arr\u00eat");
        if (this.collectorServer != null) {
            this.collectorServer.stop();
        }
        Collector.stopJRobin();
        LOGGER.info((Object)"servlet de collecte arr\u00eat\u00e9e");
        super.destroy();
    }
}

