/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonitoringProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1882880665014391301L;
    private static final String BEANS_ICON_NAME = "beans.png";
    private static final Counter SERVICES_COUNTER = new Counter("services", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter EJB_COUNTER = new Counter("ejb", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter SPRING_COUNTER = new Counter("spring", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter GUICE_COUNTER = new Counter("guice", "beans.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final Counter STRUTS_COUNTER = new Counter("struts", "struts.png", JdbcWrapper.SINGLETON.getSqlCounter());
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(SERVICES_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    private final Object facade;

    private MonitoringProxy(Object facade) {
        this.facade = facade;
        SERVICES_COUNTER.setDisplayed(!COUNTER_HIDDEN);
    }

    public static <T> T createProxy(T facade) {
        return JdbcWrapper.createProxy(facade, new MonitoringProxy(facade));
    }

    static Counter getServicesCounter() {
        return SERVICES_COUNTER;
    }

    static Counter getEjbCounter() {
        return EJB_COUNTER;
    }

    static Counter getSpringCounter() {
        return SPRING_COUNTER;
    }

    static Counter getGuiceCounter() {
        return GUICE_COUNTER;
    }

    static Counter getStrutsCounter() {
        return STRUTS_COUNTER;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (DISABLED || !SERVICES_COUNTER.isDisplayed()) {
            return method.invoke(this.facade, args);
        }
        String requestName = method.getDeclaringClass().getSimpleName() + '.' + method.getName();
        boolean systemError = false;
        try {
            SERVICES_COUNTER.bindContextIncludingCpu(requestName);
            Object object = method.invoke(this.facade, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Error) {
                systemError = true;
            }
            throw e;
        }
        finally {
            SERVICES_COUNTER.addRequestForCurrentContext(systemError);
        }
    }
}

