/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bull.javamelody.Action;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.HtmlCacheInformationsReport;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlCounterRequestContextReport;
import net.bull.javamelody.HtmlJavaInformationsReport;
import net.bull.javamelody.HtmlJobInformationsReport;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlCoreReport {
    private static final String END_DIV = "</div>";
    private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
    private static final String SCRIPT_END = "</script>";
    private static final boolean PDF_ENABLED = HtmlCoreReport.isPdfEnabled();
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Range range;
    private final Writer writer;
    private final CollectorServer collectorServer;
    private final long start = System.currentTimeMillis();

    HtmlCoreReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Range range, Writer writer) {
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        assert (writer != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.range = range;
        this.writer = writer;
    }

    void toHtml(String message) throws IOException {
        if (this.collectorServer != null) {
            this.writeln("<div align='center'>");
            this.writeApplicationsLinks();
            HtmlCoreReport.writeAddAndRemoveApplicationLinks(this.collector.getApplication(), this.writer);
            this.writeln(END_DIV);
        }
        this.writeln("<h3><img width='24' height='24' src='?resource=systemmonitor.png' alt='#Stats#'/>");
        this.writeSummary();
        this.writeln("</h3>");
        this.writeln("<div align='center'>");
        this.writeRefreshAndPeriodLinks(null, null);
        this.writeGraphs();
        this.writeln(END_DIV);
        Map<String, HtmlCounterReport> counterReportsByCounterName = this.writeCounters();
        if (this.range.getPeriod() == Period.TOUT) {
            this.writeln("<div align='right'>");
            this.writeln("<a href='?action=clear_counter&amp;counter=all' title='#Vider_toutes_stats#'");
            this.writeln("class='noPrint' onclick=\"javascript:return confirm('" + I18N.javascriptEncode(I18N.getString("confirm_vider_toutes_stats")) + "');\">#Reinitialiser_toutes_stats#</a>");
            this.writeln(END_DIV);
        }
        if (this.collectorServer == null) {
            this.writeln("<h3><img width='24' height='24' src='?resource=hourglass.png' alt='#Requetes_en_cours#'/>#Requetes_en_cours#</h3>");
            this.writeCurrentRequests(this.javaInformationsList.get(0), counterReportsByCounterName);
        }
        this.writeln("<h3><img width='24' height='24' src='?resource=systeminfo.png' alt='#Informations_systemes#'/>");
        this.writeln("#Informations_systemes#</h3>");
        if (this.collectorServer != null) {
            this.writeln("<div align='center' class='noPrint'><a href='?part=currentRequests'>");
            this.writeln("<img src='?resource=hourglass.png' width='20' height='20' alt=\"#Voir_requetes_en_cours#\" /> #Voir_requetes_en_cours#</a>");
            this.writeln(END_DIV);
            this.writeln("<br/>");
        }
        if (Parameters.isSystemActionsEnabled()) {
            this.writeSystemActionsLinks();
        }
        new HtmlJavaInformationsReport(this.javaInformationsList, this.writer).toHtml();
        this.writeln("<h3 style='clear:both;'><img width='24' height='24' src='?resource=threads.png' alt='#Threads#'/>");
        this.writeln("#Threads#</h3>");
        this.writeThreads();
        if (this.isJobEnabled()) {
            this.writeln("<h3><img width='24' height='24' src='?resource=jobs.png' alt='#Jobs#'/>");
            this.writeln("#Jobs#</h3>");
            Counter rangeJobCounter = this.collector.getRangeCounter(this.range, "job");
            this.writeJobs(rangeJobCounter);
            this.writeCounter(rangeJobCounter);
        }
        if (this.isCacheEnabled()) {
            this.writeln("<h3><img width='24' height='24' src='?resource=caches.png' alt='#Caches#'/>");
            this.writeln("#Caches#</h3>");
            this.writeCaches();
        }
        this.writeMessageIfNotNull(message, null);
        this.writePoweredBy();
        this.writeDurationAndOverhead();
    }

    private void writeSummary() throws IOException {
        String javaMelodyUrl = "<a href='http://javamelody.googlecode.com' target='_blank'>JavaMelody</a>";
        String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
        this.writer.write(I18N.getFormattedString("Statistiques", "<a href='http://javamelody.googlecode.com' target='_blank'>JavaMelody</a>", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication()));
        if (this.javaInformationsList.get(0).getContextDisplayName() != null) {
            this.writer.write(" (" + this.javaInformationsList.get(0).getContextDisplayName() + ')');
        }
        this.writeln("");
    }

    private Map<String, HtmlCounterReport> writeCounters() throws IOException {
        HashMap<String, HtmlCounterReport> counterReportsByCounterName = new HashMap<String, HtmlCounterReport>();
        for (Counter counter : this.collector.getRangeCountersToBeDisplayed(this.range)) {
            HtmlCounterReport htmlCounterReport = this.writeCounter(counter);
            counterReportsByCounterName.put(counter.getName(), htmlCounterReport);
        }
        return counterReportsByCounterName;
    }

    private HtmlCounterReport writeCounter(Counter counter) throws IOException {
        this.write("<h3><img width='24' height='24' src='?resource=" + counter.getIconName() + "' alt='" + counter.getName() + "'/>");
        String counterLabel = I18N.getString(counter.getName() + "Label");
        this.write(I18N.getFormattedString("Statistiques_compteur", counterLabel));
        this.writeln(" - " + this.range.getLabel() + "</h3>");
        HtmlCounterReport htmlCounterReport = new HtmlCounterReport(counter, this.range, this.writer);
        htmlCounterReport.toHtml();
        return htmlCounterReport;
    }

    static void writeAddAndRemoveApplicationLinks(String currentApplication, Writer writer) throws IOException {
        new HtmlForms(writer).writeAddAndRemoveApplicationLinks(currentApplication);
    }

    void writeMessageIfNotNull(String message, String partToRedirectTo) throws IOException {
        if (message != null) {
            this.writeln(SCRIPT_BEGIN);
            this.writer.write("alert(\"" + I18N.javascriptEncode(message) + "\");");
            this.writeln("");
            if (partToRedirectTo == null) {
                this.writeln("location.href = '?'");
            } else {
                this.writeln("location.href = '?part=" + partToRedirectTo + '\'');
            }
            this.writeln(SCRIPT_END);
        }
    }

    private void writeGraphs() throws IOException {
        this.writeGraphs(this.collector.getCounterJRobins());
        this.writeln("<div align='right'>");
        this.writeShowHideLink("detailsGraphs", "#Autres_courbes#");
        this.writeln(END_DIV);
        this.writeln("<div id='detailsGraphs' style='display: none;'>");
        this.writeGraphs(this.collector.getOtherJRobins());
        this.writeln(END_DIV);
    }

    private void writeGraphs(Collection<JRobin> jrobins) throws IOException {
        int i = 0;
        for (JRobin jrobin : jrobins) {
            String jrobinName = jrobin.getName();
            if (this.isJRobinDisplayed(jrobinName)) {
                this.writeln("<a href='?part=graph&amp;graph=" + jrobinName + "'><img class='synthese' src='?width=200&amp;height=" + 50 + "&amp;graph=" + jrobinName + "' alt=\"" + jrobin.getLabel() + "\" title=\"" + jrobin.getLabel() + "\"/></a>");
            }
            if (++i % 3 != 0) continue;
            this.writeln("<br/>");
        }
    }

    private void writeCurrentRequests(JavaInformations javaInformations, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        List<ThreadInformations> threadInformationsList = javaInformations.getThreadInformationsList();
        boolean stackTraceEnabled = javaInformations.isStackTraceEnabled();
        this.writeCurrentRequests(threadInformationsList, stackTraceEnabled, counterReportsByCounterName);
    }

    void writeCurrentRequests(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, Map<String, HtmlCounterReport> counterReportsByCounterName) throws IOException {
        List<CounterRequestContext> rootCurrentContexts = this.collector.getRootCurrentContexts();
        if (rootCurrentContexts.isEmpty()) {
            this.writeln("#Aucune_requete_en_cours#");
        } else {
            new HtmlCounterRequestContextReport(rootCurrentContexts, counterReportsByCounterName, threadInformationsList, stackTraceEnabled, this.writer).toHtml();
        }
    }

    private void writeThreads() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.writeln("<b>#Threads_sur# " + javaInformations.getHost() + ": </b>");
            this.writeln(I18N.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()));
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            String id = "threads_" + i;
            this.writeShowHideLink(id, "#Details#");
            HtmlThreadInformationsReport htmlThreadInformationsReport = new HtmlThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.writer);
            htmlThreadInformationsReport.writeDeadlocks();
            this.writeln("<br/><br/><div id='" + id + "' style='display: none;'>");
            htmlThreadInformationsReport.toHtml();
            this.writeln("</div><br/>");
            ++i;
        }
    }

    private static boolean isPdfEnabled() {
        try {
            Class.forName("com.lowagie.text.Document");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean isGcEnabled() {
        return Action.GC_ENABLED || this.collectorServer != null;
    }

    private boolean isHeapDumpEnabled() {
        return Action.HEAP_DUMP_ENABLED || this.collectorServer != null;
    }

    private boolean isHeapHistoEnabled() {
        return this.collectorServer != null || VirtualMachine.isEnabled();
    }

    private boolean isDatabaseEnabled() {
        return !Parameters.isNoDatabase() && this.javaInformationsList.get(0).getDataBaseVersion() != null && !this.javaInformationsList.get(0).getDataBaseVersion().contains("Exception");
    }

    private boolean doesWebXmlExists() {
        return this.javaInformationsList.get(0).doesWebXmlExists();
    }

    private boolean isSessionsEnabled() {
        return this.javaInformationsList.get(0).getSessionCount() >= 0;
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isJobEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            return true;
        }
        return false;
    }

    private boolean isJRobinDisplayed(String jrobinName) {
        for (Counter counter : this.collector.getCounters()) {
            if (!jrobinName.startsWith(counter.getName())) continue;
            return counter.isDisplayed();
        }
        return true;
    }

    private void writeCaches() throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            this.writeln("<b>");
            this.writeln(I18N.getFormattedString("caches_sur", cacheInformationsList.size(), javaInformations.getHost()));
            this.writeln("</b>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            String id = "caches_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/><div id='" + id + "' style='display: none;'>");
            new HtmlCacheInformationsReport(javaInformations.getCacheInformationsList(), this.writer).toHtml();
            this.writeln("</div><br/>");
            ++i;
        }
    }

    private void writeJobs(Counter rangeJobCounter) throws IOException {
        int i = 0;
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            List<JobInformations> jobInformationsList = javaInformations.getJobInformationsList();
            this.writeln("<b>");
            this.writeln(I18N.getFormattedString("jobs_sur", jobInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount()));
            this.writeln("</b>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            String id = "job_" + i;
            this.writeShowHideLink(id, "#Details#");
            this.writeln("<br/><br/><div id='" + id + "' style='display: none;'>");
            new HtmlJobInformationsReport(javaInformations.getJobInformationsList(), rangeJobCounter, this.writer).toHtml();
            this.writeln("</div><br/>");
            ++i;
        }
    }

    private void writeSystemActionsLinks() throws IOException {
        this.writeln("<div align='center' class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;";
        String endOfOnClickConfirm = "');\">";
        if (this.isGcEnabled()) {
            this.write("<a href='?action=gc' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_ramasse_miette") + "');\">");
            this.write("<img src='?resource=broom.png' width='20' height='20' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        } else {
            this.write("<a href='' onclick=\"javascript:alert('" + I18N.getStringForJavascript("ramasse_miette_desactive") + "');return false;\">");
            this.write("<img src='?resource=broom.png' width='20' height='20' alt='#ramasse_miette#' /> #ramasse_miette#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (this.isHeapDumpEnabled()) {
            this.write("<a href='?action=heap_dump' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_heap_dump") + "');\">");
            this.write("<img src='?resource=heapdump.png' width='20' height='20' alt=\"#heap_dump#\" /> #heap_dump#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (this.isHeapHistoEnabled()) {
            this.write("<a href='?part=heaphisto'>");
            this.write("<img src='?resource=memory.png' width='20' height='20' alt=\"#heaphisto#\" /> #heaphisto#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        if (this.isSessionsEnabled()) {
            this.write("<a href='?action=invalidate_sessions' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_invalidate_sessions") + "');\">");
            this.write("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#invalidate_sessions#\" /> #invalidate_sessions#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=sessions'>");
            this.writeln("<img src='?resource=system-users.png' width='20' height='20' alt=\"#sessions#\" /> #sessions#</a>");
        }
        this.writeln("<br />");
        if (this.doesWebXmlExists()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=web.xml'>");
            this.write("<img src='?resource=xml.png' width='20' height='20' alt=\"#web.xml#\" /> #web.xml#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?part=processes'>");
        this.write("<img src='?resource=processes.png' width='20' height='20' alt=\"#processes#\" /> #processes#</a>");
        String serverInfo = this.javaInformationsList.get(0).getServerInfo();
        if (serverInfo != null && !serverInfo.contains("Winstone")) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=jndi'>");
            this.write("<img src='?resource=jndi.png' width='20' height='20' alt=\"#Arbre_JNDI#\" /> #Arbre_JNDI#</a>");
        }
        if (this.isDatabaseEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=connections'>");
            this.write("<img src='?resource=db.png' width='20' height='20' alt=\"#Connexions_jdbc_ouvertes#\" /> #Connexions_jdbc_ouvertes#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=database'>");
            this.writeln("<img src='?resource=db.png' width='20' height='20' alt=\"#database#\" /> #database#</a>");
        }
        this.writeln("<br/></div>");
    }

    private void writeApplicationsLinks() throws IOException {
        assert (this.collectorServer != null);
        Set<String> applications = Parameters.getCollectorUrlsByApplications().keySet();
        Map<String, Throwable> lastCollectExceptionsByApplication = this.collectorServer.getLastCollectExceptionsByApplication();
        if (applications.size() > 1) {
            this.writeln("&nbsp;&nbsp;&nbsp;#Choix_application# :&nbsp;&nbsp;&nbsp;");
            for (String application : applications) {
                this.writeln("<a href='?application=" + application + "' class='tooltip'>");
                Throwable lastCollectException = lastCollectExceptionsByApplication.get(application);
                if (lastCollectException == null) {
                    this.writeln("<img src='?resource=bullets/green.png' alt='#Application_disponible#'/>");
                    this.writeln("<em style='text-align: left; font-size: 10pt;'>");
                    this.writeln("#Application_disponible#");
                    this.writeln("</em>");
                } else {
                    this.writeln("<img src='?resource=bullets/red.png' alt='#Application_indisponible#'/>");
                    this.writeln("<em style='text-align: left; font-size: 10pt;'>");
                    this.writeln("#Application_indisponible#:<br/>");
                    for (StackTraceElement stackTraceElement : lastCollectException.getStackTrace()) {
                        this.writeln(I18N.htmlEncode(stackTraceElement.toString(), true));
                        this.writeln("<br/>");
                    }
                    this.writeln("</em>");
                }
                this.writeln(application + "</a>&nbsp;&nbsp;&nbsp;");
            }
        }
    }

    void writeRefreshAndPeriodLinks(String graphName, String part) throws IOException {
        this.writeln("<div class='noPrint'>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;";
        if (graphName == null) {
            this.write("<a href='?' title='#Rafraichir#'>");
        } else {
            this.write("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=" + part + "&amp;graph=" + graphName + "' title='#Rafraichir#'>");
        }
        this.write("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (graphName == null && PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.write("<a href='?resource=#help_url#' target='_blank'");
        this.write(" title=\"#Afficher_aide_en_ligne#\"><img src='?resource=action_help.png' alt='#Aide_en_ligne#'/> #Aide_en_ligne#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("#Choix_periode# :&nbsp;");
        for (Period myPeriod : Period.values()) {
            if (graphName == null) {
                this.write("<a href='?period=" + myPeriod.getCode() + "' ");
            } else {
                this.write("<a href='?part=" + part + "&amp;graph=" + graphName + "&amp;period=" + myPeriod.getCode() + "' ");
            }
            this.write("title='" + I18N.getFormattedString("Choisir_periode", myPeriod.getLinkLabel()) + "'>");
            this.write("<img src='?resource=" + myPeriod.getIconName() + "' alt='" + myPeriod.getLinkLabel() + "' /> ");
            this.writeln(myPeriod.getLinkLabel() + "</a>&nbsp;");
        }
        new HtmlForms(this.writer).writeCustomPeriodLink(this.range, graphName, part);
        this.writeln(END_DIV);
    }

    private void writeDurationAndOverhead() throws IOException {
        long displayDuration = System.currentTimeMillis() - this.start;
        this.writeln("<br/><div style='font-size:10pt;'>");
        this.writeln("#temps_derniere_collecte#: " + this.collector.getLastCollectDuration() + " #ms#<br/>");
        this.writeln("#temps_affichage#: " + displayDuration + " #ms#<br/>");
        this.writeln("#Estimation_overhead_memoire#: < " + (this.collector.getEstimatedMemorySize() / 1024L / 1024L + 1L) + " #Mo#");
        if (Parameters.JAVAMELODY_VERSION != null) {
            this.writeln("<br/><br/>JavaMelody " + Parameters.JAVAMELODY_VERSION);
        }
        this.writeln(END_DIV);
    }

    private void writePoweredBy() throws IOException {
        this.writeln("");
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    private static class HtmlForms {
        private final Writer writer;

        HtmlForms(Writer writer) {
            this.writer = writer;
        }

        void writeCustomPeriodLink(Range range, String graphName, String part) throws IOException {
            String dateFormatPattern;
            this.writeln("<a href=\"javascript:showHide('customPeriod');document.customPeriodForm.startDate.focus();\" ");
            String linkLabel = I18N.getString("personnalisee");
            this.writeln("title='" + I18N.getFormattedString("Choisir_periode", linkLabel) + "'>");
            this.writeln("<img src='?resource=calendar.png' alt='#personnalisee#' /> #personnalisee#</a>");
            this.writeln("<div id='customPeriod' style='display: none;'>");
            this.writeln(HtmlCoreReport.SCRIPT_BEGIN);
            this.writeln("function validateCustomPeriodForm() {");
            this.writeln("   periodForm = document.customPeriodForm;");
            this.writelnCheckMandatory("periodForm.startDate", "dates_mandatory");
            this.writelnCheckMandatory("periodForm.endDate", "dates_mandatory");
            this.writeln("   periodForm.period.value=periodForm.startDate.value + '-' + periodForm.endDate.value;");
            this.writeln("   return true;");
            this.writeln("}");
            this.writeln(HtmlCoreReport.SCRIPT_END);
            this.writeln("<br/><br/>");
            DateFormat dateFormat = I18N.createDateFormat();
            if (I18N.getString("dateFormatPattern").length() == 0) {
                String pattern = ((SimpleDateFormat)dateFormat).toPattern();
                dateFormatPattern = pattern.toLowerCase(I18N.getCurrentLocale());
            } else {
                dateFormatPattern = I18N.getString("dateFormatPattern");
            }
            this.writeln("<form name='customPeriodForm' method='get' action='' onsubmit='return validateCustomPeriodForm();'>");
            this.writeln("<br/><b>#startDate#</b>&nbsp;&nbsp;<input type='text' size='10' name='startDate' ");
            if (range.getStartDate() != null) {
                this.writeln("value='" + dateFormat.format(range.getStartDate()) + '\'');
            }
            this.writeln("/>&nbsp;&nbsp;<b>#endDate#</b>&nbsp;&nbsp;<input type='text' size='10' name='endDate' ");
            if (range.getEndDate() != null) {
                this.writeln("value='" + dateFormat.format(range.getEndDate()) + '\'');
            }
            this.writeln("/>&nbsp;&nbsp;");
            this.writer.write('(' + dateFormatPattern + ')');
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='submit' value='#ok#'/><br/><br/>");
            this.writeln("<input type='hidden' name='period' value=''/>");
            if (graphName != null) {
                this.writeln("<input type='hidden' name='part' value='" + part + "'/>");
                this.writeln("<input type='hidden' name='graph' value='" + graphName + "'/>");
            }
            this.writeln("</form><br/>");
            this.writeln(HtmlCoreReport.END_DIV);
        }

        void writeAddAndRemoveApplicationLinks(String currentApplication) throws IOException {
            if (currentApplication == null) {
                this.writeln("<div align='center'><h3>#add_application#</h3>");
            } else {
                String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href=\"javascript:showHide('addApplication');document.appForm.appName.focus();\"");
                this.writeln(" class='noPrint'><img src='?resource=action_add.png' alt='#add_application#'/> #add_application#</a>");
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href='?action=remove_application&amp;application=" + currentApplication + "' class='noPrint' ");
                String messageConfirmation = I18N.getFormattedString("confirm_remove_application", currentApplication);
                this.writeln("onclick=\"javascript:return confirm('" + I18N.javascriptEncode(messageConfirmation) + "');\">");
                String removeApplicationLabel = I18N.getFormattedString("remove_application", currentApplication);
                this.writeln("<img src='?resource=action_delete.png' alt=\"" + removeApplicationLabel + "\"/> " + removeApplicationLabel + "</a>");
                this.writeln("<div id='addApplication' style='display: none;'>");
            }
            this.writeln(HtmlCoreReport.SCRIPT_BEGIN);
            this.writeln("function validateAppForm() {");
            this.writelnCheckMandatory("document.appForm.appName", "app_name_mandatory");
            this.writelnCheckMandatory("document.appForm.appUrls", "app_urls_mandatory");
            this.writeln("   return true;");
            this.writeln("}");
            this.writeln(HtmlCoreReport.SCRIPT_END);
            this.writeln("<br/> <br/>");
            this.writeln("<form name='appForm' method='post' action='' onsubmit='return validateAppForm();'>");
            this.writeln("<br/><b>#app_name_to_monitor# :</b>&nbsp;&nbsp;<input type='text' size='15' name='appName'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<b>#app_urls# :</b>&nbsp;&nbsp;<input type='text' size='50' name='appUrls'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<input type='submit' value='#add#'/><br/>");
            this.writeln("#urls_sample# : <i>http://myhost/myapp/</i> #or# <i>http://host1/myapp/,http://host2/myapp/</i>");
            this.writeln("<br/> <br/>");
            this.writeln("</form>");
            this.writeln("</div>\n");
        }

        private void writelnCheckMandatory(String fieldFullName, String msgKey) throws IOException {
            this.writeln("   if (" + fieldFullName + ".value.length == 0) {");
            this.writeln("      alert('" + I18N.getStringForJavascript(msgKey) + "');");
            this.writeln("      " + fieldFullName + ".focus();");
            this.writeln("      return false;");
            this.writeln("   }");
        }

        private void writeln(String html) throws IOException {
            I18N.writelnTo(html, this.writer);
        }
    }
}

