/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LOG;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectorServer {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private final Map<String, Collector> collectorsByApplication = new LinkedHashMap<String, Collector>();
    private final Map<String, List<JavaInformations>> javaInformationsByApplication = new LinkedHashMap<String, List<JavaInformations>>();
    private final Map<String, Throwable> lastCollectExceptionsByApplication = new LinkedHashMap<String, Throwable>();
    private final Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CollectorServer() throws IOException {
        boolean initOk = false;
        this.timer = new Timer("collector", true);
        try {
            Map<String, List<URL>> urlsByApplication = Parameters.getCollectorUrlsByApplications();
            LOGGER.info((Object)("applications monitor\u00e9es : " + urlsByApplication.keySet()));
            LOGGER.info((Object)("urls des applications monitor\u00e9es : " + urlsByApplication));
            int periodMillis = Parameters.getResolutionSeconds() * 1000;
            LOGGER.info((Object)("r\u00e9solution du monitoring en secondes : " + Parameters.getResolutionSeconds()));
            TimerTask collectTask = new TimerTask(){

                public void run() {
                    CollectorServer.this.collectWithoutErrors();
                }
            };
            this.timer.schedule(collectTask, 100L, (long)periodMillis);
            JRobin.setJRobinThreadName("jrobin");
            initOk = true;
        }
        finally {
            if (!initOk) {
                this.timer.cancel();
            }
        }
    }

    void collectWithoutErrors() {
        LinkedHashMap<String, List<URL>> clone;
        try {
            clone = new LinkedHashMap<String, List<URL>>(Parameters.getCollectorUrlsByApplications());
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        for (Map.Entry entry : clone.entrySet()) {
            String application = (String)entry.getKey();
            List urls = (List)entry.getValue();
            try {
                this.collectForApplication(application, urls);
                assert (this.collectorsByApplication.size() == this.javaInformationsByApplication.size());
                this.lastCollectExceptionsByApplication.remove(application);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)e.getMessage(), e);
                this.lastCollectExceptionsByApplication.put(application, e);
            }
        }
    }

    String collectForApplication(String application, List<URL> urls) throws IOException {
        LOGGER.info((Object)("collecte pour l'application " + application + " sur " + urls));
        assert (application != null);
        assert (urls != null);
        long start = System.currentTimeMillis();
        String messageForReport = this.collectDataForApplication(application, urls);
        List<JavaInformations> javaInformationsList = this.javaInformationsByApplication.get(application);
        Collector collector = this.collectorsByApplication.get(application);
        if (collector == null) {
            this.javaInformationsByApplication.remove(application);
            return null;
        }
        collector.collectWithoutErrors(javaInformationsList);
        LOGGER.info((Object)("collecte pour l'application " + application + " effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("counters " + application + " : " + collector.getCounters()));
            LOGGER.debug((Object)("javaInformations " + application + " : " + javaInformationsList));
            if (messageForReport != null) {
                LOGGER.debug((Object)("message " + application + " : " + messageForReport.replace("\n", ", ")));
            }
        }
        return messageForReport;
    }

    private String collectDataForApplication(String application, List<URL> urls) throws IOException {
        ArrayList<JavaInformations> javaInformationsList = new ArrayList<JavaInformations>();
        StringBuilder sb = new StringBuilder();
        Collector collector = this.collectorsByApplication.get(application);
        for (URL url : urls) {
            List serialized = (List)new LabradorRetriever(url).call();
            ArrayList<Counter> counters = new ArrayList<Counter>();
            for (Serializable serializable : serialized) {
                if (serializable instanceof Counter) {
                    Counter counter = (Counter)serializable;
                    counter.setApplication(application);
                    counters.add(counter);
                    continue;
                }
                if (serializable instanceof JavaInformations) {
                    JavaInformations newJavaInformations = (JavaInformations)serializable;
                    javaInformationsList.add(newJavaInformations);
                    continue;
                }
                if (!(serializable instanceof String)) continue;
                sb.append(serializable).append('\n');
            }
            if (collector == null) {
                collector = this.createCollector(application, counters);
                this.collectorsByApplication.put(application, collector);
                continue;
            }
            this.addRequestsAndErrors(collector, counters);
        }
        this.javaInformationsByApplication.put(application, javaInformationsList);
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    List<SessionInformations> collectSessionInformations(String application, String sessionId) throws IOException {
        assert (application != null);
        if (sessionId == null) {
            ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>();
            for (URL url : CollectorServer.getUrlsByApplication(application)) {
                URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions");
                LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
                List sessions = (List)labradorRetriever.call();
                sessionsInformations.addAll(sessions);
            }
            SessionListener.sortSessions(sessionsInformations);
            return sessionsInformations;
        }
        SessionInformations found = null;
        for (URL url : CollectorServer.getUrlsByApplication(application)) {
            URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions" + '&' + "sessionId" + '=' + sessionId);
            LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
            SessionInformations session = (SessionInformations)labradorRetriever.call();
            if (session == null) continue;
            found = session;
            break;
        }
        return Collections.singletonList(found);
    }

    HeapHistogram collectHeapHistogram(String application) throws IOException {
        assert (application != null);
        HeapHistogram heapHistoTotal = null;
        for (URL url : CollectorServer.getUrlsByApplication(application)) {
            URL heapHistoUrl = new URL(url.toString() + '&' + "part" + '=' + "heaphisto");
            LabradorRetriever labradorRetriever = new LabradorRetriever(heapHistoUrl);
            HeapHistogram heapHisto = (HeapHistogram)labradorRetriever.call();
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            heapHistoTotal.add(heapHisto);
        }
        return heapHistoTotal;
    }

    private void addRequestsAndErrors(Collector collector, List<Counter> counters) {
        for (Counter newCounter : counters) {
            Counter counter = collector.getCounterByName(newCounter.getName());
            counter.setDisplayed(newCounter.isDisplayed());
            counter.addRequestsAndErrors(newCounter);
        }
    }

    private Collector createCollector(String application, List<Counter> counters) {
        Collector collector = new Collector(application, counters, this.timer);
        if (Parameters.getParameter(Parameter.MAIL_SESSION) != null && Parameters.getParameter(Parameter.ADMIN_EMAILS) != null) {
            this.scheduleReportMailForCollectorServer(application);
            LOGGER.info((Object)("Rapport hebdomadaire programm\u00e9 pour l'application " + application + " \u00e0 destination de " + Parameters.getParameter(Parameter.ADMIN_EMAILS)));
        }
        return collector;
    }

    void addCollectorApplication(String application, List<URL> urls) throws IOException {
        this.collectForApplication(application, urls);
        Parameters.addCollectorApplication(application, urls);
    }

    void removeCollectorApplication(String application) throws IOException {
        Parameters.removeCollectorApplication(application);
        this.collectorsByApplication.remove(application);
        this.javaInformationsByApplication.remove(application);
    }

    Collector getCollectorByApplication(String application) {
        return this.collectorsByApplication.get(application);
    }

    List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.javaInformationsByApplication.get(application);
    }

    Map<String, Throwable> getLastCollectExceptionsByApplication() {
        return Collections.unmodifiableMap(this.lastCollectExceptionsByApplication);
    }

    String getFirstApplication() {
        if (this.collectorsByApplication.isEmpty()) {
            return null;
        }
        return this.collectorsByApplication.keySet().iterator().next();
    }

    boolean isApplicationDataAvailable(String application) {
        assert (application != null);
        return this.collectorsByApplication.containsKey(application) && this.javaInformationsByApplication.containsKey(application);
    }

    void scheduleReportMailForCollectorServer(String application) {
        assert (application != null);
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForCollectorServer(application, period);
        }
    }

    void scheduleReportMailForCollectorServer(final String application, final Period period) {
        assert (application != null);
        assert (period != null);
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    Collector collector = CollectorServer.this.getCollectorByApplication(application);
                    List<JavaInformations> javaInformationsList = CollectorServer.this.getJavaInformationsByApplication(application);
                    new MailReport().sendReportMail(collector, true, javaInformationsList, period);
                }
                catch (Throwable t) {
                    LOG.warn("sending mail report failed", t);
                }
                CollectorServer.this.scheduleReportMailForCollectorServer(application, period);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate(period));
    }

    void stop() {
        for (Collector collector : this.collectorsByApplication.values()) {
            collector.stop();
        }
        this.timer.cancel();
        this.collectorsByApplication.clear();
        this.javaInformationsByApplication.clear();
    }

    static List<URL> getUrlsByApplication(String application) throws IOException {
        assert (application != null);
        return Parameters.getCollectorUrlsByApplications().get(application);
    }
}

