/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Period;

final class Range
implements Serializable {
    private static final long serialVersionUID = 4658258882827669495L;
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private final Period period;
    private final Date startDate;
    private final Date endDate;

    private Range(Period period, Date startDate, Date endDate) {
        assert (period != null && startDate == null && endDate == null || period == null && startDate != null && endDate != null && startDate.getTime() <= endDate.getTime());
        this.period = period;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    static Range createPeriodRange(Period period) {
        return new Range(period, null, null);
    }

    static Range createCustomRange(Date startDate, Date endDate) {
        return new Range(null, startDate, endDate);
    }

    static Range parse(String value) {
        Date endDate;
        Date startDate;
        int index = value.indexOf(45);
        if (index == -1) {
            return Period.valueOfIgnoreCase(value).getRange();
        }
        DateFormat dateFormat = I18N.createDateFormat();
        try {
            startDate = dateFormat.parse(value.substring(0, index));
        }
        catch (ParseException e) {
            startDate = new Date();
        }
        Calendar minimum = Calendar.getInstance();
        minimum.add(1, -2);
        if (startDate.getTime() < minimum.getTimeInMillis()) {
            startDate = minimum.getTime();
        }
        if (startDate.getTime() > System.currentTimeMillis()) {
            startDate = new Date();
        }
        if (index < value.length() - 1) {
            try {
                endDate = dateFormat.parse(value.substring(index + 1));
            }
            catch (ParseException e) {
                endDate = new Date();
            }
            if (endDate.getTime() > System.currentTimeMillis()) {
                endDate = new Date();
            }
        } else {
            endDate = new Date();
        }
        if (startDate.after(endDate)) {
            endDate = startDate;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date includedEndDate = calendar.getTime();
        return Range.createCustomRange(startDate, includedEndDate);
    }

    Period getPeriod() {
        return this.period;
    }

    Date getStartDate() {
        return this.startDate;
    }

    Date getEndDate() {
        return this.endDate;
    }

    String getValue() {
        if (this.period == null) {
            DateFormat dateFormat = I18N.createDateFormat();
            return dateFormat.format(this.startDate) + '-' + dateFormat.format(this.endDate);
        }
        return this.period.getCode();
    }

    String getLabel() {
        if (this.period == null) {
            DateFormat dateFormat = I18N.createDateFormat();
            return dateFormat.format(this.startDate) + " - " + dateFormat.format(this.endDate);
        }
        return this.period.getLabel();
    }

    int getDurationDays() {
        if (this.period == null) {
            return (int)((this.endDate.getTime() + 1000L - this.startDate.getTime()) / 86400000L);
        }
        return this.period.getDurationDays();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[period=" + (Object)((Object)this.getPeriod()) + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ']';
    }
}

