/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import net.bull.javamelody.LOG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TomcatInformations
implements Serializable {
    static final boolean TOMCAT_USED = System.getProperty("catalina.home") != null;
    private static final long serialVersionUID = -6145865427461051370L;
    private static final List<ObjectName> THREAD_POOLS = new ArrayList<ObjectName>();
    private static final List<ObjectName> GLOBAL_REQUEST_PROCESSORS = new ArrayList<ObjectName>();
    private final String name;
    private final int maxThreads;
    private final int currentThreadCount;
    private final int currentThreadsBusy;
    private final long bytesReceived;
    private final long bytesSent;
    private final int requestCount;
    private final int errorCount;
    private final long processingTime;
    private final long maxTime;

    TomcatInformations(MBeanServer mBeanServer, ObjectName threadPool) throws JMException {
        this.name = threadPool.getKeyProperty("name");
        this.maxThreads = (Integer)mBeanServer.getAttribute(threadPool, "maxThreads");
        this.currentThreadCount = (Integer)mBeanServer.getAttribute(threadPool, "currentThreadCount");
        this.currentThreadsBusy = (Integer)mBeanServer.getAttribute(threadPool, "currentThreadsBusy");
        ObjectName grp = null;
        for (ObjectName globalRequestProcessor : GLOBAL_REQUEST_PROCESSORS) {
            if (!this.name.equals(globalRequestProcessor.getKeyProperty("name"))) continue;
            grp = globalRequestProcessor;
        }
        if (grp != null) {
            this.bytesReceived = (Long)mBeanServer.getAttribute(grp, "bytesReceived");
            this.bytesSent = (Long)mBeanServer.getAttribute(grp, "bytesSent");
            this.requestCount = (Integer)mBeanServer.getAttribute(grp, "requestCount");
            this.errorCount = (Integer)mBeanServer.getAttribute(grp, "errorCount");
            this.processingTime = (Long)mBeanServer.getAttribute(grp, "processingTime");
            this.maxTime = (Long)mBeanServer.getAttribute(grp, "maxTime");
        } else {
            this.bytesReceived = 0L;
            this.bytesSent = 0L;
            this.requestCount = 0;
            this.errorCount = 0;
            this.processingTime = 0L;
            this.maxTime = 0L;
        }
    }

    static List<TomcatInformations> buildTomcatInformationsList() {
        if (!TOMCAT_USED) {
            return Collections.emptyList();
        }
        try {
            if (THREAD_POOLS.isEmpty() || GLOBAL_REQUEST_PROCESSORS.isEmpty()) {
                TomcatInformations.initMBeans();
            }
            MBeanServer mBeanServer = TomcatInformations.getMBeanServer();
            ArrayList<TomcatInformations> tomcatInformationsList = new ArrayList<TomcatInformations>(THREAD_POOLS.size());
            for (ObjectName threadPool : THREAD_POOLS) {
                tomcatInformationsList.add(new TomcatInformations(mBeanServer, threadPool));
            }
            return tomcatInformationsList;
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void initMBeans() throws MalformedObjectNameException {
        MBeanServer mBeanServer = TomcatInformations.getMBeanServer();
        Set<ObjectInstance> threadPoolInstances = mBeanServer.queryMBeans(new ObjectName("*:type=ThreadPool,*"), null);
        ArrayList<ObjectName> threadPools = new ArrayList<ObjectName>(threadPoolInstances.size());
        for (ObjectInstance oi : threadPoolInstances) {
            threadPools.add(oi.getObjectName());
        }
        Set<ObjectInstance> globalRequestProcessorInstances = mBeanServer.queryMBeans(new ObjectName("*:type=GlobalRequestProcessor,*"), null);
        ArrayList<ObjectName> globalRequestProcessors = new ArrayList<ObjectName>(globalRequestProcessorInstances.size());
        for (ObjectInstance oi : globalRequestProcessorInstances) {
            globalRequestProcessors.add(oi.getObjectName());
        }
        THREAD_POOLS.clear();
        GLOBAL_REQUEST_PROCESSORS.clear();
        THREAD_POOLS.addAll(threadPools);
        GLOBAL_REQUEST_PROCESSORS.addAll(globalRequestProcessors);
    }

    private static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        if (!mBeanServers.isEmpty()) {
            return (MBeanServer)mBeanServers.get(0);
        }
        MBeanServer server = MBeanServerFactory.createMBeanServer();
        LOG.debug("javax.management.MBeanServer created");
        return server;
    }

    String getName() {
        return this.name;
    }

    int getMaxThreads() {
        return this.maxThreads;
    }

    int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    int getCurrentThreadsBusy() {
        return this.currentThreadsBusy;
    }

    long getBytesReceived() {
        return this.bytesReceived;
    }

    long getBytesSent() {
        return this.bytesSent;
    }

    int getRequestCount() {
        return this.requestCount;
    }

    int getErrorCount() {
        return this.errorCount;
    }

    long getProcessingTime() {
        return this.processingTime;
    }

    long getMaxTime() {
        return this.maxTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", maxThreads=" + this.getMaxThreads() + ", currentThreadCount=" + this.getCurrentThreadCount() + ", currentThreadsBusy=" + this.getCurrentThreadsBusy() + ", bytesReceived=" + this.getBytesReceived() + ", bytesSent=" + this.getBytesSent() + ", requestCount=" + this.getRequestCount() + ", errorCount=" + this.getErrorCount() + ", processingTime=" + this.getProcessingTime() + ", maxTime=" + this.getMaxTime() + ']';
    }
}

