/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LabradorRetriever {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 60000;
    private final URL url;

    LabradorRetriever(URL url) {
        assert (url != null);
        this.url = url;
    }

    <T> T call() throws IOException {
        Serializable serializable;
        if (LabradorRetriever.shouldMock()) {
            return this.createMockResultOfCall();
        }
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.setRequestProperty("Accept-Language", I18N.getCurrentLocale().toString());
            connection.connect();
            Serializable result = LabradorRetriever.read(connection);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("lu sur " + this.url + " : " + result));
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Exception) {
                throw LabradorRetriever.createIOException((Exception)result);
            }
            serializable = result;
            Object var7_6 = null;
        }
        catch (ClassNotFoundException e) {
            try {
                throw LabradorRetriever.createIOException(e);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                LOGGER.info((Object)("http call done in " + (System.currentTimeMillis() - start) + " ms for " + this.url));
                throw throwable;
            }
        }
        LOGGER.info((Object)("http call done in " + (System.currentTimeMillis() - start) + " ms for " + this.url));
        return (T)serializable;
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (LabradorRetriever.shouldMock()) {
            return;
        }
        assert (httpRequest != null);
        assert (httpResponse != null);
        long start = System.currentTimeMillis();
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url);
            connection.setRequestProperty("Accept-Language", httpRequest.getHeader("Accept-Language"));
            connection.connect();
            try {
                InputStream input = connection.getInputStream();
                if ("gzip".equals(connection.getContentEncoding())) {
                    input = new GZIPInputStream(input);
                }
                httpResponse.setContentType(connection.getContentType());
                TransportFormat.pump(input, (OutputStream)httpResponse.getOutputStream());
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                LabradorRetriever.close(connection);
                throw throwable;
            }
            LabradorRetriever.close(connection);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            LOGGER.info((Object)("r\u00e9cup\u00e9ration donn\u00e9es effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms pour " + this.url));
            throw throwable;
        }
        LOGGER.info((Object)("r\u00e9cup\u00e9ration donn\u00e9es effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms pour " + this.url));
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Serializable read(URLConnection connection) throws IOException, ClassNotFoundException {
        Serializable serializable;
        InputStream input = connection.getInputStream();
        try {
            String contentType;
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            TransportFormat transportFormat = (contentType = connection.getContentType()) != null && contentType.startsWith("text/xml") ? TransportFormat.XML : TransportFormat.SERIALIZED;
            serializable = transportFormat.readSerializableFrom(input);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            LabradorRetriever.close(connection);
            throw throwable;
        }
        LabradorRetriever.close(connection);
        return serializable;
    }

    private static void close(URLConnection connection) throws IOException {
        InputStream error;
        connection.getInputStream().close();
        if (connection instanceof HttpURLConnection && (error = ((HttpURLConnection)connection).getErrorStream()) != null) {
            error.close();
        }
    }

    private static boolean shouldMock() {
        return Boolean.parseBoolean(System.getProperty("javamelody.mockLabradorRetriever"));
    }

    private <T> T createMockResultOfCall() throws IOException {
        List<Serializable> result;
        String request = this.url.toString();
        if (!request.contains("part=")) {
            String message = request.contains("/test2") ? null : "ceci est message pour le rapport";
            result = Arrays.asList(new Counter("http", null), new Counter("error", null), new JavaInformations(null, true), message);
        } else {
            result = this.createMockResultOfPartCall(request);
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createMockResultOfPartCall(String request) throws IOException {
        Object result;
        block10: {
            if (request.contains("sessions") && request.contains("sessionId")) {
                result = null;
            } else if (request.contains("sessions") || request.contains("processes")) {
                result = Collections.emptyList();
            } else {
                if (request.contains("database")) {
                    try {
                        result = new DatabaseInformations(0);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
                if (request.contains("heaphisto")) {
                    InputStream input = this.getClass().getResourceAsStream("/heaphisto.txt");
                    try {
                        result = new HeapHistogram(input, false);
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                    {
                        break block10;
                    }
                }
                result = null;
            }
        }
        return result;
    }
}

