/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.LOG;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.config.CacheConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CacheInformations
implements Serializable {
    private static final long serialVersionUID = -3025833425994923286L;
    private static final boolean EHCACHE_AVAILABLE = CacheInformations.isEhcacheAvailable();
    private static final boolean EHCACHE_1_6 = CacheInformations.isEhcache16();
    private static final boolean EHCACHE_1_2 = CacheInformations.isEhcache12();
    private static final boolean EHCACHE_1_2_X = CacheInformations.isEhcache12x();
    private final String name;
    private final long inMemoryObjectCount;
    private final int inMemoryPercentUsed;
    private final long onDiskObjectCount;
    private final long inMemoryHits;
    private final long cacheHits;
    private final long cacheMisses;
    private final String configuration;

    CacheInformations(Ehcache cache) {
        String tmpConfiguration;
        int tmpInMemoryPercentUsed;
        long tmpCacheMisses;
        long tmpCacheHits;
        long tmpInMemoryHits;
        long tmpOnDiskObjectCount;
        long tmpInMemoryObjectCount;
        assert (cache != null);
        Statistics statistics = cache.getStatistics();
        assert (statistics != null);
        this.name = cache.getName();
        if (EHCACHE_1_6) {
            tmpInMemoryObjectCount = statistics.getMemoryStoreObjectCount();
            tmpOnDiskObjectCount = statistics.getDiskStoreObjectCount();
            assert (statistics.getStatisticsAccuracy() == 1);
        } else {
            tmpInMemoryObjectCount = cache.getMemoryStoreSize();
            tmpOnDiskObjectCount = cache.getDiskStoreSize();
        }
        this.inMemoryObjectCount = tmpInMemoryObjectCount;
        this.onDiskObjectCount = tmpOnDiskObjectCount;
        if (EHCACHE_1_2_X) {
            tmpInMemoryHits = CacheInformations.invokeStatisticsMethod(statistics, "getInMemoryHits");
            tmpCacheHits = CacheInformations.invokeStatisticsMethod(statistics, "getCacheHits");
            tmpCacheMisses = CacheInformations.invokeStatisticsMethod(statistics, "getCacheMisses");
            tmpInMemoryPercentUsed = -1;
            tmpConfiguration = null;
        } else if (EHCACHE_1_2) {
            tmpInMemoryHits = -1L;
            tmpCacheHits = -1L;
            tmpCacheMisses = -1L;
            tmpInMemoryPercentUsed = -1;
            tmpConfiguration = null;
        } else {
            tmpInMemoryHits = statistics.getInMemoryHits();
            tmpCacheHits = statistics.getCacheHits();
            tmpCacheMisses = statistics.getCacheMisses();
            tmpInMemoryPercentUsed = (int)(100L * this.inMemoryObjectCount / (long)cache.getCacheConfiguration().getMaxElementsInMemory());
            tmpConfiguration = CacheInformations.buildConfiguration(cache);
        }
        this.inMemoryHits = tmpInMemoryHits;
        this.cacheHits = tmpCacheHits;
        this.cacheMisses = tmpCacheMisses;
        this.inMemoryPercentUsed = tmpInMemoryPercentUsed;
        this.configuration = tmpConfiguration;
    }

    private static long invokeStatisticsMethod(Statistics statistics, String methodName) {
        try {
            Number result = (Number)Statistics.class.getMethod(methodName, null).invoke((Object)statistics, (Object[])null);
            return result.longValue();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean isEhcacheAvailable() {
        try {
            Class.forName("net.sf.ehcache.Cache");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static List<CacheInformations> buildCacheInformationsList() {
        ArrayList allCacheManagers;
        if (!EHCACHE_AVAILABLE) {
            return Collections.emptyList();
        }
        try {
            allCacheManagers = new ArrayList(CacheManager.ALL_CACHE_MANAGERS);
        }
        catch (NoSuchFieldError e) {
            return Collections.emptyList();
        }
        ArrayList<CacheInformations> result = new ArrayList<CacheInformations>();
        for (CacheManager cacheManager : allCacheManagers) {
            String[] cacheNames;
            for (String cacheName : cacheNames = cacheManager.getCacheNames()) {
                try {
                    result.add(new CacheInformations(cacheManager.getEhcache(cacheName)));
                }
                catch (Exception e) {
                    LOG.debug(e.toString(), e);
                }
            }
        }
        return result;
    }

    private static boolean isEhcache16() {
        try {
            Class.forName("net.sf.ehcache.Statistics");
            Statistics.class.getMethod("getMemoryStoreObjectCount", new Class[0]);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private static boolean isEhcache12() {
        try {
            Class.forName("net.sf.ehcache.Ehcache");
            Ehcache.class.getMethod("getCacheConfiguration", new Class[0]);
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
    }

    private static boolean isEhcache12x() {
        try {
            Class.forName("net.sf.ehcache.Statistics");
            return CacheInformations.isEhcache12();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static String buildConfiguration(Ehcache cache) {
        StringBuilder sb = new StringBuilder();
        CacheConfiguration configuration = cache.getCacheConfiguration();
        sb.append("ehcache [maxElementsInMemory = ").append(configuration.getMaxElementsInMemory());
        boolean overflowToDisk = configuration.isOverflowToDisk();
        sb.append(", overflowToDisk = ").append(overflowToDisk);
        if (overflowToDisk) {
            sb.append(", maxElementsOnDisk = ").append(configuration.getMaxElementsOnDisk());
        }
        boolean eternal = configuration.isEternal();
        sb.append(", eternal = ").append(eternal);
        if (!eternal) {
            sb.append(", timeToLiveSeconds = ").append(configuration.getTimeToLiveSeconds());
            sb.append(", timeToIdleSeconds = ").append(configuration.getTimeToIdleSeconds());
            sb.append(", memoryStoreEvictionPolicy = ").append(configuration.getMemoryStoreEvictionPolicy());
        }
        sb.append(", diskPersistent = ").append(configuration.isDiskPersistent());
        sb.append(']');
        return sb.toString();
    }

    String getName() {
        return this.name;
    }

    long getInMemoryObjectCount() {
        return this.inMemoryObjectCount;
    }

    long getInMemoryPercentUsed() {
        return this.inMemoryPercentUsed;
    }

    long getOnDiskObjectCount() {
        return this.onDiskObjectCount;
    }

    int getInMemoryHitsRatio() {
        if (this.cacheHits == 0L) {
            return -1;
        }
        return (int)(100L * this.inMemoryHits / this.cacheHits);
    }

    int getHitsRatio() {
        long accessCount = this.cacheHits + this.cacheMisses;
        if (accessCount == 0L) {
            return -1;
        }
        return (int)(100L * this.cacheHits / accessCount);
    }

    String getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", inMemoryObjectCount=" + this.getInMemoryObjectCount() + ", inMemoryPercentUsed=" + this.getInMemoryPercentUsed() + ", onDiskObjectCount=" + this.getOnDiskObjectCount() + ", inMemoryHitsRatio=" + this.getInMemoryHitsRatio() + ", hitsRatio=" + this.getHitsRatio() + ']';
    }
}

