/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.TransportFormat;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonitoringController {
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private String messageForReport;
    private String anchorNameForRedirect;

    MonitoringController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return httpRequest.getParameter("resource") == null && httpRequest.getParameter("graph") == null && (httpRequest.getParameter("part") == null || "currentRequests".equalsIgnoreCase(httpRequest.getParameter("part")) || "threads".equalsIgnoreCase(httpRequest.getParameter("part")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeActionIfNeeded(HttpServletRequest httpRequest) throws IOException {
        assert (httpRequest != null);
        String actionParameter = httpRequest.getParameter("action");
        if (actionParameter != null) {
            String string;
            try {
                I18N.bindLocale(httpRequest.getLocale());
                Action action = Action.valueOfIgnoreCase(actionParameter);
                if (action != Action.CLEAR_COUNTER) {
                    Action.checkSystemActionsEnabled();
                }
                String counterName = httpRequest.getParameter("counter");
                String sessionId = httpRequest.getParameter("sessionId");
                String threadId = httpRequest.getParameter("threadId");
                String jobId = httpRequest.getParameter("jobId");
                this.messageForReport = action.execute(this.collector, counterName, sessionId, threadId, jobId);
                this.anchorNameForRedirect = action.getContextName(counterName);
                string = this.messageForReport;
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                I18N.unbindLocale();
                throw throwable;
            }
            I18N.unbindLocale();
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        assert (httpRequest != null);
        assert (httpResponse != null);
        assert (javaInformationsList != null);
        String resource = httpRequest.getParameter("resource");
        if (resource != null) {
            this.doResource(httpResponse, resource);
            return;
        }
        MonitoringController.noCache(httpResponse);
        try {
            I18N.bindLocale(httpRequest.getLocale());
            String part = httpRequest.getParameter("part");
            String graph = httpRequest.getParameter("graph");
            if (part == null && graph != null) {
                Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                this.doGraph(httpRequest, httpResponse, range, graph);
            } else if ("lastValue".equalsIgnoreCase(part)) {
                this.doLastValue(httpResponse, graph);
            } else if ("web.xml".equalsIgnoreCase(part)) {
                this.doWebXml(httpResponse);
            } else if ("pom.xml".equalsIgnoreCase(part)) {
                this.doPomXml(httpResponse);
            } else {
                this.doReportCore(httpRequest, httpResponse, javaInformationsList);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            I18N.unbindLocale();
            throw throwable;
        }
        I18N.unbindLocale();
    }

    private void doReportCore(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String format = httpRequest.getParameter("format");
        if (format == null || "html".equalsIgnoreCase(format) || "htmlbody".equalsIgnoreCase(format)) {
            this.doCompressedHtml(httpRequest, httpResponse, javaInformationsList);
        } else if ("pdf".equalsIgnoreCase(format)) {
            this.doPdf(httpRequest, httpResponse, javaInformationsList);
        } else {
            this.doCompressedSerializable(httpRequest, httpResponse, javaInformationsList);
        }
    }

    static void noCache(HttpServletResponse httpResponse) {
        httpResponse.addHeader("Cache-Control", "no-cache");
        httpResponse.addHeader("Pragma", "no-cache");
        httpResponse.addHeader("Expires", "-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        block3: {
            if (MonitoringController.isCompressionSupported(httpRequest)) {
                CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
                try {
                    this.doHtml(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    wrappedResponse.finishResponse();
                    throw throwable;
                }
                wrappedResponse.finishResponse();
                {
                    break block3;
                }
            }
            this.doHtml(httpRequest, httpResponse, javaInformationsList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        block3: {
            if (MonitoringController.isCompressionSupported(httpRequest)) {
                CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 51200);
                try {
                    this.doSerializable(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList);
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    wrappedResponse.finishResponse();
                    throw throwable;
                }
                wrappedResponse.finishResponse();
                {
                    break block3;
                }
            }
            this.doSerializable(httpRequest, httpResponse, javaInformationsList);
        }
    }

    private void doSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        Serializable serializable;
        String format = httpRequest.getParameter("format");
        TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
        try {
            serializable = this.createSerializable(httpRequest, javaInformationsList);
        }
        catch (Exception e) {
            serializable = e;
        }
        httpResponse.setContentType(transportFormat.getMimeType());
        String fileName = "JavaMelody_" + this.collector.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
        httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
        transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
        if ("stop".equalsIgnoreCase(httpRequest.getParameter("collector"))) {
            this.collector.stop();
        }
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList) throws Exception {
        String part = httpRequest.getParameter("part");
        if ("heaphisto".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return VirtualMachine.createHeapHistogram();
        }
        if ("sessions".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String sessionId = httpRequest.getParameter("sessionId");
            if (sessionId == null) {
                List<SessionInformations> sessionsInformations = SessionListener.getAllSessionsInformations();
                return new ArrayList<SessionInformations>(sessionsInformations);
            }
            return SessionListener.getSessionInformationsBySessionId(sessionId);
        }
        if ("processes".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ProcessInformations>(ProcessInformations.buildProcessInformations());
        }
        if ("database".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            int requestIndex = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            return new DatabaseInformations(requestIndex);
        }
        if ("connections".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ConnectionInformations>(JdbcWrapper.getConnectionInformationsList());
        }
        if ("threads".equalsIgnoreCase(part)) {
            return new ArrayList<ThreadInformations>(JavaInformations.buildThreadInformationsList());
        }
        return this.createDefaultSerializable(javaInformationsList);
    }

    private Serializable createDefaultSerializable(List<JavaInformations> javaInformationsList) {
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Object> serialized = new ArrayList<Object>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        serialized.addAll(javaInformationsList);
        if (this.messageForReport != null) {
            serialized.add(this.messageForReport);
        }
        return serialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String part = httpRequest.getParameter("part");
        if (!this.isFromCollectorServer() && (part == null || "currentRequests".equalsIgnoreCase(part) || "graph".equalsIgnoreCase(part))) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("text/html; charset=UTF-8");
        BufferedWriter writer = MonitoringController.getWriter(httpResponse);
        try {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, javaInformationsList, range, (Writer)writer);
            if (part == null) {
                htmlReport.toHtml(this.messageForReport, this.anchorNameForRedirect);
            } else {
                this.doHtmlPart(httpRequest, part, htmlReport);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    static BufferedWriter getWriter(HttpServletResponse httpResponse) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)httpResponse.getOutputStream(), "UTF-8"));
    }

    private void doHtmlPart(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("graph".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestAndGraphDetail(graphName);
        } else if ("usages".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestUsages(graphName);
        } else if ("currentRequests".equalsIgnoreCase(part)) {
            boolean withoutHeaders = "htmlbody".equalsIgnoreCase(httpRequest.getParameter("format"));
            this.doCurrentRequests(htmlReport, withoutHeaders);
        } else if ("threads".equalsIgnoreCase(part)) {
            htmlReport.writeAllThreadsAsPart();
        } else if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String counterName = httpRequest.getParameter("counter");
            String requestId = httpRequest.getParameter("graph");
            htmlReport.writeCounterSummaryPerClass(counterName, requestId);
        } else {
            this.doHtmlPartForSystemActions(httpRequest, part, htmlReport);
        }
    }

    private void doHtmlPartForSystemActions(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("sessions".equalsIgnoreCase(part)) {
            this.doSessions(htmlReport, httpRequest.getParameter("sessionId"));
        } else if ("heaphisto".equalsIgnoreCase(part)) {
            this.doHeapHisto(htmlReport);
        } else if ("processes".equalsIgnoreCase(part)) {
            this.doProcesses(htmlReport);
        } else if ("database".equalsIgnoreCase(part)) {
            this.doDatabase(htmlReport, httpRequest.getParameter("request"));
        } else if ("connections".equalsIgnoreCase(part)) {
            boolean withoutHeaders = "htmlbody".equalsIgnoreCase(httpRequest.getParameter("format"));
            this.doConnections(htmlReport, withoutHeaders);
        } else if ("jndi".equalsIgnoreCase(part)) {
            this.doJndi(htmlReport, httpRequest.getParameter("path"));
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private void doSessions(HtmlReport htmlReport, String sessionId) throws IOException {
        Action.checkSystemActionsEnabled();
        List<SessionInformations> sessionsInformations = !this.isFromCollectorServer() ? (sessionId == null ? SessionListener.getAllSessionsInformations() : Collections.singletonList(SessionListener.getSessionInformationsBySessionId(sessionId))) : this.collectorServer.collectSessionInformations(this.collector.getApplication(), sessionId);
        if (sessionId == null || sessionsInformations.isEmpty()) {
            htmlReport.writeSessions(sessionsInformations, this.messageForReport, "sessions");
        } else {
            SessionInformations sessionInformation = sessionsInformations.get(0);
            htmlReport.writeSessionDetail(sessionId, sessionInformation);
        }
    }

    private void doCurrentRequests(HtmlReport htmlReport, boolean withoutHeaders) throws IOException {
        if (this.isFromCollectorServer()) {
            throw new IllegalStateException();
        }
        htmlReport.writeAllCurrentRequestsAsPart(withoutHeaders);
    }

    private void doHeapHisto(HtmlReport htmlReport) throws IOException {
        HeapHistogram heapHistogram;
        Action.checkSystemActionsEnabled();
        try {
            heapHistogram = !this.isFromCollectorServer() ? VirtualMachine.createHeapHistogram() : this.collectorServer.collectHeapHistogram(this.collector.getApplication());
        }
        catch (Exception e) {
            LOG.warn("heaphisto report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
            return;
        }
        htmlReport.writeHeapHistogram(heapHistogram, this.messageForReport, "heaphisto");
    }

    private void doProcesses(HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeProcesses(ProcessInformations.buildProcessInformations());
        }
        catch (Exception e) {
            LOG.warn("processes report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doDatabase(HtmlReport htmlReport, String requestIndex) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            int index = DatabaseInformations.parseRequestIndex(requestIndex);
            htmlReport.writeDatabase(new DatabaseInformations(index));
        }
        catch (Exception e) {
            LOG.warn("database report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doConnections(HtmlReport htmlReport, boolean withoutHeaders) throws IOException {
        Action.checkSystemActionsEnabled();
        htmlReport.writeConnections(JdbcWrapper.getConnectionInformationsList(), withoutHeaders);
    }

    private void doJndi(HtmlReport htmlReport, String path) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeJndi(path);
        }
        catch (Exception e) {
            LOG.warn("jndi report failed", e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHtmlToLastShutdownFile() {
        try {
            File dir = Parameters.getStorageDirectory(this.collector.getApplication());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + dir.getPath());
            }
            File lastShutdownFile = new File(dir, "last_shutdown.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(lastShutdownFile));
            try {
                JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
                HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, Collections.singletonList(javaInformations), Period.JOUR, (Writer)writer);
                htmlReport.writeLastShutdown();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
            {
            }
        }
        catch (IOException e) {
            LOG.warn("exception while writing the last shutdown report", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        if (!this.isFromCollectorServer()) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("application/pdf");
        httpResponse.addHeader("Content-Disposition", MonitoringController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.collector.getApplication())));
        try {
            Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
            PdfReport pdfReport = new PdfReport(this.collector, this.isFromCollectorServer(), javaInformationsList, range, (OutputStream)httpResponse.getOutputStream());
            pdfReport.toPdf();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            httpResponse.getOutputStream().flush();
            throw throwable;
        }
        httpResponse.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResource(HttpServletResponse httpResponse, String resource) throws IOException {
        httpResponse.addHeader("Cache-Control", "max-age=3600");
        ServletOutputStream out = httpResponse.getOutputStream();
        String localResource = Parameters.getResourcePath(resource.replace("..", ""));
        httpResponse.setContentType(Parameters.getServletContext().getMimeType(localResource));
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(localResource));
        try {
            TransportFormat.pump(in, (OutputStream)out);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    private void doGraph(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Range range, String graphName) throws IOException {
        int width = Math.min(Integer.parseInt(httpRequest.getParameter("width")), 1600);
        int height = Math.min(Integer.parseInt(httpRequest.getParameter("height")), 1600);
        JRobin jrobin = this.collector.getJRobin(graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(range, width, height);
            httpResponse.setContentType("image/png");
            httpResponse.setContentLength(img.length);
            String fileName = graphName + ".png";
            httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
            httpResponse.getOutputStream().write(img);
            httpResponse.flushBuffer();
        }
    }

    private void doLastValue(HttpServletResponse httpResponse, String graphName) throws IOException {
        httpResponse.setContentType("text/plain");
        boolean first = true;
        for (String graph : graphName.split(",")) {
            JRobin jrobin = this.collector.getJRobin(graph);
            double lastValue = jrobin == null ? -1.0 : jrobin.getLastValue();
            if (first) {
                first = false;
            } else {
                httpResponse.getWriter().write(",");
            }
            httpResponse.getWriter().write(String.valueOf(lastValue));
        }
        httpResponse.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWebXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=web.xml");
        InputStream in = MonitoringController.getWebXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPomXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=pom.xml");
        InputStream in = MonitoringController.getPomXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            {
            }
        }
    }

    private boolean isFromCollectorServer() {
        return this.collectorServer != null;
    }

    private static InputStream getWebXmlAsStream() {
        InputStream webXml = Parameters.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        if (webXml == null) {
            return null;
        }
        return new BufferedInputStream(webXml);
    }

    private static InputStream getPomXmlAsStream() {
        Set mavenDir = Parameters.getServletContext().getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = Parameters.getServletContext().getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = Parameters.getServletContext().getResourceAsStream(groupDir.iterator().next() + "pom.xml");
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return MonitoringController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename*=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isCompressionSupported(HttpServletRequest httpRequest) {
        boolean supportCompression = false;
        ArrayList<String> acceptEncodings = Collections.list(httpRequest.getHeaders("Accept-Encoding"));
        for (String name : acceptEncodings) {
            if (!name.contains("gzip")) continue;
            supportCompression = true;
            break;
        }
        return supportCompression;
    }

    static {
        boolean webXmlExists = false;
        boolean pomXmlExists = false;
        try {
            InputStream pomXmlAsStream;
            InputStream webXmlAsStream = MonitoringController.getWebXmlAsStream();
            if (webXmlAsStream != null) {
                webXmlAsStream.close();
                webXmlExists = true;
            }
            if ((pomXmlAsStream = MonitoringController.getPomXmlAsStream()) != null) {
                pomXmlAsStream.close();
                pomXmlExists = true;
            }
        }
        catch (IOException e) {
            LOG.warn(e.toString(), e);
        }
        JavaInformations.setWebXmlExistsAndPomXmlExists(webXmlExists, pomXmlExists);
    }
}

