/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.HtmlController;
import net.bull.javamelody.HttpCookieManager;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JnlpPage;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfController;
import net.bull.javamelody.Range;
import net.bull.javamelody.SerializableController;
import net.bull.javamelody.TransportFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonitoringController {
    private static final boolean GZIP_COMPRESSION_DISABLED;
    private final HttpCookieManager httpCookieManager = new HttpCookieManager();
    private final Collector collector;
    private final CollectorServer collectorServer;
    private String messageForReport;
    private String anchorNameForRedirect;

    MonitoringController(Collector collector, CollectorServer collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String executeActionIfNeeded(HttpServletRequest httpRequest) throws IOException {
        assert (httpRequest != null);
        String actionParameter = httpRequest.getParameter("action");
        if (actionParameter != null) {
            try {
                I18N.bindLocale(httpRequest.getLocale());
                Action action = Action.valueOfIgnoreCase(actionParameter);
                if (action != Action.CLEAR_COUNTER && action != Action.MAIL_TEST) {
                    Action.checkSystemActionsEnabled();
                }
                String counterName = httpRequest.getParameter("counter");
                String sessionId = httpRequest.getParameter("sessionId");
                String threadId = httpRequest.getParameter("threadId");
                String jobId = httpRequest.getParameter("jobId");
                String cacheId = httpRequest.getParameter("cacheId");
                this.messageForReport = action.execute(this.collector, this.collectorServer, counterName, sessionId, threadId, jobId, cacheId);
                this.anchorNameForRedirect = action.getContextName(counterName);
                String string = this.messageForReport;
                return string;
            }
            finally {
                I18N.unbindLocale();
            }
        }
        return null;
    }

    void doActionIfNeededAndReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, ServletContext servletContext) throws IOException {
        this.executeActionIfNeeded(httpRequest);
        JavaInformations javaInformations = MonitoringController.isJavaInformationsNeeded(httpRequest) ? new JavaInformations(servletContext, true) : null;
        this.doReport(httpRequest, httpResponse, Collections.singletonList(javaInformations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        assert (httpRequest != null);
        assert (httpResponse != null);
        assert (javaInformationsList != null);
        String resource = httpRequest.getParameter("resource");
        if (resource != null) {
            this.doResource(httpResponse, resource);
            return;
        }
        MonitoringController.noCache(httpResponse);
        try {
            I18N.bindLocale(httpRequest.getLocale());
            String part = httpRequest.getParameter("part");
            String graph = httpRequest.getParameter("graph");
            if (part == null && graph != null) {
                Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                this.doGraph(httpRequest, httpResponse, range, graph);
            } else if ("lastValue".equalsIgnoreCase(part)) {
                this.doLastValue(httpResponse, graph);
            } else if ("web.xml".equalsIgnoreCase(part)) {
                this.doWebXml(httpResponse);
            } else if ("pom.xml".equalsIgnoreCase(part)) {
                this.doPomXml(httpResponse);
            } else if ("jnlp".equalsIgnoreCase(part)) {
                Range range = this.httpCookieManager.getRange(httpRequest, httpResponse);
                this.doJnlp(httpRequest, httpResponse, range);
            } else if (httpRequest.getParameter("jmxValue") != null) {
                Action.checkSystemActionsEnabled();
                this.doJmxValue(httpResponse, httpRequest.getParameter("jmxValue"));
            } else {
                this.doReportCore(httpRequest, httpResponse, javaInformationsList);
            }
        }
        finally {
            I18N.unbindLocale();
        }
    }

    private void doReportCore(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        String format = httpRequest.getParameter("format");
        if (format == null || "html".equalsIgnoreCase(format) || "htmlbody".equalsIgnoreCase(format)) {
            this.doCompressedHtml(httpRequest, httpResponse, javaInformationsList);
        } else if ("pdf".equalsIgnoreCase(format)) {
            PdfController pdfController = new PdfController(this.collector, this.collectorServer);
            pdfController.doPdf(httpRequest, httpResponse, javaInformationsList);
        } else {
            this.doCompressedSerializable(httpRequest, httpResponse, javaInformationsList);
        }
    }

    static void noCache(HttpServletResponse httpResponse) {
        httpResponse.addHeader("Cache-Control", "no-cache");
        httpResponse.addHeader("Pragma", "no-cache");
        httpResponse.addHeader("Expires", "-1");
    }

    void addPdfContentTypeAndDisposition(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        new PdfController(this.collector, this.collectorServer).addPdfContentTypeAndDisposition(httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        HtmlController htmlController = new HtmlController(this.collector, this.collectorServer, this.messageForReport, this.anchorNameForRedirect);
        if (MonitoringController.isCompressionSupported(httpRequest) && !(httpResponse instanceof CompressionServletResponseWrapper) && !GZIP_COMPRESSION_DISABLED) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
            try {
                htmlController.doHtml(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            htmlController.doHtml(httpRequest, httpResponse, javaInformationsList);
        }
    }

    void writeHtmlToLastShutdownFile() {
        new HtmlController(this.collector, this.collectorServer, this.messageForReport, this.anchorNameForRedirect).writeHtmlToLastShutdownFile();
    }

    static BufferedWriter getWriter(HttpServletResponse httpResponse) throws IOException {
        return HtmlController.getWriter(httpResponse);
    }

    private void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        Serializable serializable;
        String part = httpRequest.getParameter("part");
        if (HtmlController.isLocalCollectNeeded(part) && httpRequest.getParameter("period") != null) {
            this.collector.collectLocalContextWithoutErrors();
        }
        try {
            SerializableController serializableController = new SerializableController(this.collector);
            serializable = serializableController.createSerializable(httpRequest, javaInformationsList, this.messageForReport);
        }
        catch (Exception e) {
            serializable = e;
        }
        this.doCompressedSerializable(httpRequest, httpResponse, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doCompressedSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Serializable serializable) throws IOException {
        SerializableController serializableController = new SerializableController(this.collector);
        if (MonitoringController.isCompressionSupported(httpRequest) && !(httpResponse instanceof CompressionServletResponseWrapper) && !GZIP_COMPRESSION_DISABLED) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 51200);
            try {
                serializableController.doSerializable(httpRequest, (HttpServletResponse)wrappedResponse, serializable);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            serializableController.doSerializable(httpRequest, httpResponse, serializable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResource(HttpServletResponse httpResponse, String resource) throws IOException {
        String localResource = Parameters.getResourcePath(resource.replace("..", ""));
        MonitoringController.addHeadersForResource(httpResponse, localResource);
        ServletOutputStream out = httpResponse.getOutputStream();
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(localResource));
        try {
            TransportFormat.pump(in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    static void addHeadersForResource(HttpServletResponse httpResponse, String resource) {
        httpResponse.addHeader("Cache-Control", "max-age=3600");
        if (resource.endsWith(".css")) {
            httpResponse.setContentType("text/css");
        } else {
            String mimeType = Parameters.getServletContext().getMimeType(resource);
            if (mimeType != null) {
                httpResponse.setContentType(mimeType);
            }
        }
    }

    private void doGraph(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Range range, String graphName) throws IOException {
        int width = Math.min(Integer.parseInt(httpRequest.getParameter("width")), 1600);
        int height = Math.min(Integer.parseInt(httpRequest.getParameter("height")), 1600);
        JRobin jrobin = this.collector.getJRobin(graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(range, width, height);
            httpResponse.setContentType("image/png");
            httpResponse.setContentLength(img.length);
            String fileName = graphName + ".png";
            httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
            httpResponse.getOutputStream().write(img);
            httpResponse.flushBuffer();
        }
    }

    private void doLastValue(HttpServletResponse httpResponse, String graphName) throws IOException {
        httpResponse.setContentType("text/plain");
        boolean first = true;
        for (String graph : graphName.split(",")) {
            JRobin jrobin = this.collector.getJRobin(graph);
            double lastValue = jrobin == null ? -1.0 : jrobin.getLastValue();
            if (first) {
                first = false;
            } else {
                httpResponse.getWriter().write(",");
            }
            httpResponse.getWriter().write(String.valueOf(lastValue));
        }
        httpResponse.flushBuffer();
    }

    private void doJmxValue(HttpServletResponse httpResponse, String jmxValueParameter) throws IOException {
        httpResponse.setContentType("text/plain");
        httpResponse.getWriter().write(MBeans.getConvertedAttributes(jmxValueParameter));
        httpResponse.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWebXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType("application/xml");
        httpResponse.addHeader("Content-Disposition", "inline;filename=web.xml");
        InputStream in = MonitoringController.getWebXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPomXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType("application/xml");
        httpResponse.addHeader("Content-Disposition", "inline;filename=pom.xml");
        InputStream in = MonitoringController.getPomXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    private static InputStream getWebXmlAsStream() {
        InputStream webXml = Parameters.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        if (webXml == null) {
            return null;
        }
        return new BufferedInputStream(webXml);
    }

    private static InputStream getPomXmlAsStream() {
        Set mavenDir = Parameters.getServletContext().getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = Parameters.getServletContext().getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = Parameters.getServletContext().getResourceAsStream(groupDir.iterator().next() + "pom.xml");
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    private void doJnlp(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Range range) throws IOException {
        httpResponse.setContentType("application/x-java-jnlp-file");
        String codebase = httpRequest.getRequestURL().toString();
        String cookies = this.httpCookieManager.getCookiesAsString(httpRequest);
        new JnlpPage(this.collector, this.collectorServer, codebase, cookies, range, httpResponse.getWriter()).toJnlp();
    }

    static boolean isCompressionSupported(HttpServletRequest httpRequest) {
        boolean supportCompression = false;
        ArrayList<String> acceptEncodings = Collections.list(httpRequest.getHeaders("Accept-Encoding"));
        for (String name : acceptEncodings) {
            if (!name.contains("gzip")) continue;
            supportCompression = true;
            break;
        }
        return supportCompression;
    }

    static boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return httpRequest.getParameter("resource") == null && httpRequest.getParameter("graph") == null && (httpRequest.getParameter("part") == null || "currentRequests".equalsIgnoreCase(httpRequest.getParameter("part")) || "defaultWithCurrentRequests".equalsIgnoreCase(httpRequest.getParameter("part")) || "threads".equalsIgnoreCase(httpRequest.getParameter("part")) || "threadsDump".equalsIgnoreCase(httpRequest.getParameter("part")));
    }

    static {
        boolean webXmlExists = false;
        boolean pomXmlExists = false;
        try {
            InputStream pomXmlAsStream;
            InputStream webXmlAsStream = MonitoringController.getWebXmlAsStream();
            if (webXmlAsStream != null) {
                webXmlAsStream.close();
                webXmlExists = true;
            }
            if ((pomXmlAsStream = MonitoringController.getPomXmlAsStream()) != null) {
                pomXmlAsStream.close();
                pomXmlExists = true;
            }
        }
        catch (IOException e) {
            LOG.warn(e.toString(), e);
        }
        JavaInformations.setWebXmlExistsAndPomXmlExists(webXmlExists, pomXmlExists);
        GZIP_COMPRESSION_DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.GZIP_COMPRESSION_DISABLED));
    }
}

