/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.ThreadInformations;
import net.bull.javamelody.TransportFormat;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SerializableController {
    private final Collector collector;

    SerializableController(Collector collector) {
        assert (collector != null);
        this.collector = collector;
    }

    void doSerializable(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Serializable serializable) throws IOException {
        String format = httpRequest.getParameter("format");
        TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
        transportFormat.checkDependencies();
        httpResponse.setContentType(transportFormat.getMimeType());
        String fileName = "JavaMelody_" + this.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
        String contentDisposition = "inline;filename=" + fileName;
        httpResponse.addHeader("Content-Disposition", contentDisposition.replace('\n', '_').replace('\r', '_'));
        transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
    }

    Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList, String messageForReport) throws Exception {
        String part = httpRequest.getParameter("part");
        if ("sessions".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String sessionId = httpRequest.getParameter("sessionId");
            if (sessionId == null) {
                return new ArrayList<SessionInformations>(SessionListener.getAllSessionsInformations());
            }
            return SessionListener.getSessionInformationsBySessionId(sessionId);
        }
        if ("heaphisto".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return VirtualMachine.createHeapHistogram();
        }
        if ("processes".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ProcessInformations>(ProcessInformations.buildProcessInformations());
        }
        if ("jndi".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            String path = httpRequest.getParameter("path");
            return new ArrayList<JndiBinding>(JndiBinding.listBindings(path));
        }
        if ("mbeans".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<MBeanNode>(MBeans.getAllMBeanNodes());
        }
        if ("database".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            int requestIndex = DatabaseInformations.parseRequestIndex(httpRequest.getParameter("request"));
            return new DatabaseInformations(requestIndex);
        }
        if ("connections".equalsIgnoreCase(part)) {
            Action.checkSystemActionsEnabled();
            return new ArrayList<ConnectionInformations>(JdbcWrapper.getConnectionInformationsList());
        }
        return this.createOtherSerializable(httpRequest, javaInformationsList, messageForReport);
    }

    private Serializable createOtherSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList, String messageForReport) throws IOException {
        Range range = this.getRangeForSerializable(httpRequest);
        String part = httpRequest.getParameter("part");
        if ("jrobins".equalsIgnoreCase(part)) {
            int width = Integer.parseInt(httpRequest.getParameter("width"));
            int height = Integer.parseInt(httpRequest.getParameter("height"));
            String graphName = httpRequest.getParameter("graph");
            return this.getJRobinsImages(range, width, height, graphName);
        }
        if ("otherJRobins".equalsIgnoreCase(part)) {
            int width = Integer.parseInt(httpRequest.getParameter("width"));
            int height = Integer.parseInt(httpRequest.getParameter("height"));
            Collection<JRobin> jrobins = this.collector.getOtherJRobins();
            return (Serializable)((Object)this.convertJRobinsToImages(jrobins, range, width, height));
        }
        if ("threads".equalsIgnoreCase(part)) {
            return new ArrayList<ThreadInformations>(javaInformationsList.get(0).getThreadInformationsList());
        }
        if ("counterSummaryPerClass".equalsIgnoreCase(part)) {
            String counterName = httpRequest.getParameter("counter");
            String requestId = httpRequest.getParameter("graph");
            Counter counter = this.collector.getRangeCounter(range, counterName).clone();
            List<CounterRequest> requestList = new CounterRequestAggregation(counter).getRequestsAggregatedOrFilteredByClassName(requestId);
            return new ArrayList<CounterRequest>(requestList);
        }
        if ("graph".equalsIgnoreCase(part)) {
            String requestId = httpRequest.getParameter("graph");
            return this.getCounterRequestById(requestId, range);
        }
        if ("currentRequests".equalsIgnoreCase(part)) {
            HashMap<JavaInformations, List<CounterRequestContext>> result = new HashMap<JavaInformations, List<CounterRequestContext>>();
            result.put(javaInformationsList.get(0), this.getCurrentRequests());
            return result;
        }
        if ("defaultWithCurrentRequests".equalsIgnoreCase(part)) {
            ArrayList<CounterRequestContext> result = new ArrayList<CounterRequestContext>();
            result.addAll((List)((Object)this.createDefaultSerializable(javaInformationsList, range, messageForReport)));
            result.addAll(this.getCurrentRequests());
            return result;
        }
        if ("explainPlan".equalsIgnoreCase(part)) {
            String sqlRequest = httpRequest.getHeader("request");
            return this.explainPlanFor(sqlRequest);
        }
        return this.createDefaultSerializable(javaInformationsList, range, messageForReport);
    }

    private Serializable getCounterRequestById(String requestId, Range range) throws IOException {
        for (Counter counter : this.collector.getCounters()) {
            if (!counter.isRequestIdFromThisCounter(requestId)) continue;
            Counter rangeCounter = this.collector.getRangeCounter(range, counter.getName()).clone();
            for (CounterRequest request : rangeCounter.getRequests()) {
                if (!requestId.equals(request.getId())) continue;
                return request;
            }
        }
        return null;
    }

    private Serializable getJRobinsImages(Range range, int width, int height, String graphName) throws IOException {
        if (graphName != null) {
            JRobin jrobin = this.collector.getJRobin(graphName);
            if (jrobin != null) {
                return jrobin.graph(range, width, height);
            }
            return null;
        }
        Collection<JRobin> jrobins = this.collector.getCounterJRobins();
        return (Serializable)((Object)this.convertJRobinsToImages(jrobins, range, width, height));
    }

    private Serializable explainPlanFor(String sqlRequest) {
        assert (sqlRequest != null);
        try {
            return DatabaseInformations.explainPlanFor(sqlRequest);
        }
        catch (Exception ex) {
            return ex.toString();
        }
    }

    private List<CounterRequestContext> getCurrentRequests() {
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Counter> newCounters = new ArrayList<Counter>();
        for (Counter counter : counters) {
            Counter cloneLight = new Counter(counter.getName(), counter.getStorageName(), counter.getIconName(), counter.getChildCounterName());
            newCounters.add(cloneLight);
        }
        return this.collector.getRootCurrentContexts(newCounters);
    }

    private Map<String, byte[]> convertJRobinsToImages(Collection<JRobin> jrobins, Range range, int width, int height) throws IOException {
        LinkedHashMap<String, byte[]> images = new LinkedHashMap<String, byte[]>(jrobins.size());
        for (JRobin jrobin : jrobins) {
            if (!this.collector.isJRobinDisplayed(jrobin)) continue;
            byte[] image = jrobin.graph(range, width, height);
            images.put(jrobin.getName(), image);
        }
        return images;
    }

    Serializable createDefaultSerializable(List<JavaInformations> javaInformationsList, Range range, String messageForReport) throws IOException {
        List<Counter> counters = this.collector.getRangeCounters(range);
        ArrayList<Object> serialized = new ArrayList<Object>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        serialized.addAll(javaInformationsList);
        if (messageForReport != null) {
            serialized.add(messageForReport);
        }
        return serialized;
    }

    Range getRangeForSerializable(HttpServletRequest httpRequest) {
        Range range = httpRequest.getParameter("period") == null ? Period.TOUT.getRange() : Range.parse(httpRequest.getParameter("period"));
        return range;
    }

    private String getApplication() {
        return this.collector.getApplication();
    }
}

