/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.bull.javamelody.LOG;

public class PayloadNameRequestWrapper
extends HttpServletRequestWrapper {
    private static final Pattern GWT_RPC_SEPARATOR_CHAR_PATTERN = Pattern.compile(Pattern.quote("|"));
    private String name;
    private String requestType;
    private BufferedInputStream bufferedInputStream;
    private ServletInputStream inputStream;
    private BufferedReader reader;

    public PayloadNameRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initialize() throws IOException {
        this.name = null;
        this.requestType = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        String contentType = request.getContentType();
        if (contentType == null) {
            return;
        }
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            return;
        }
        try {
            try {
                if (contentType.startsWith("text/x-gwt-rpc")) {
                    this.name = PayloadNameRequestWrapper.parseGwtRpcMethodName(this.getBufferedInputStream(), this.getCharacterEncoding());
                    this.requestType = "GWT-RPC";
                }
                if (contentType.startsWith("application/soap+xml") || contentType.startsWith("text/xml") && request.getHeader("SOAPAction") != null) {
                    this.name = PayloadNameRequestWrapper.parseSoapMethodName(this.getBufferedInputStream(), this.getCharacterEncoding());
                    this.requestType = "SOAP";
                }
                this.name = null;
                this.requestType = null;
            }
            catch (Exception e) {
                LOG.debug("Error trying to parse payload content for request name", e);
                this.name = null;
                this.requestType = null;
                Object var5_4 = null;
                this.resetBufferedInputStream();
                return;
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetBufferedInputStream();
            throw throwable;
        }
        this.resetBufferedInputStream();
    }

    protected BufferedInputStream getBufferedInputStream() throws IOException {
        if (this.bufferedInputStream == null) {
            ServletRequest request = this.getRequest();
            request.getParameterMap();
            this.bufferedInputStream = new BufferedInputStream((InputStream)request.getInputStream());
            this.bufferedInputStream.mark(Integer.MAX_VALUE);
        }
        return this.bufferedInputStream;
    }

    protected void resetBufferedInputStream() throws IOException {
        if (this.bufferedInputStream != null) {
            this.bufferedInputStream.reset();
        }
    }

    private static String parseGwtRpcMethodName(InputStream stream, String charEncoding) {
        try {
            Scanner scanner = charEncoding == null ? new Scanner(stream) : new Scanner(stream, charEncoding);
            scanner.useDelimiter(GWT_RPC_SEPARATOR_CHAR_PATTERN);
            scanner.next();
            scanner.next();
            scanner.next();
            scanner.next();
            scanner.next();
            scanner.next();
            return "." + scanner.next();
        }
        catch (NoSuchElementException e) {
            LOG.debug("Unable to parse GWT-RPC request", e);
            return null;
        }
    }

    static boolean scanForChildTag(XMLStreamReader reader, String tagName) throws XMLStreamException {
        assert (reader.isStartElement());
        int level = -1;
        while (reader.hasNext()) {
            if (reader.isStartElement()) {
                ++level;
            } else if (reader.isEndElement()) {
                --level;
            }
            if (level < 0) break;
            reader.next();
            if (level != 0 || !reader.isStartElement() || !reader.getLocalName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private static String parseSoapMethodName(InputStream stream, String charEncoding) {
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            XMLStreamReader xmlReader = charEncoding != null ? factory.createXMLStreamReader(stream, charEncoding) : factory.createXMLStreamReader(stream);
            xmlReader.nextTag();
            if (!"Envelope".equals(xmlReader.getLocalName())) {
                LOG.debug("Unexpected first tag of SOAP request: '" + xmlReader.getLocalName() + "' (expected 'Envelope')");
                return null;
            }
            if (!PayloadNameRequestWrapper.scanForChildTag(xmlReader, "Body")) {
                LOG.debug("Unable to find SOAP 'Body' tag");
                return null;
            }
            xmlReader.nextTag();
            return "." + xmlReader.getLocalName();
        }
        catch (XMLStreamException e) {
            LOG.debug("Unable to parse SOAP request", e);
            return null;
        }
    }

    public BufferedReader getReader() throws IOException {
        if (this.bufferedInputStream == null) {
            return super.getReader();
        }
        if (this.reader == null) {
            String characterEncoding = this.getCharacterEncoding();
            this.reader = characterEncoding == null ? new BufferedReader(new InputStreamReader((InputStream)this.getInputStream())) : new BufferedReader(new InputStreamReader((InputStream)this.getInputStream(), characterEncoding));
        }
        return this.reader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.bufferedInputStream == null) {
            return super.getInputStream();
        }
        if (this.inputStream == null) {
            final BufferedInputStream myBufferedInputStream = this.bufferedInputStream;
            this.inputStream = new ServletInputStream(){

                public int read() throws IOException {
                    return myBufferedInputStream.read();
                }
            };
        }
        return this.inputStream;
    }

    public String getPayloadRequestName() {
        return this.name;
    }

    public String getPayloadRequestType() {
        return this.requestType;
    }
}

