/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.InputStream;
import java.io.Serializable;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;

class HeapHistogram
implements Serializable {
    private static final long serialVersionUID = 2163916067335213382L;
    private static final String BOOLEAN_TEXT = "boolean";
    private static final String CHAR_TEXT = "char";
    private static final String BYTE_TEXT = "byte";
    private static final String SHORT_TEXT = "short";
    private static final String INT_TEXT = "int";
    private static final String LONG_TEXT = "long";
    private static final String FLOAT_TEXT = "float";
    private static final String DOUBLE_TEXT = "double";
    private static final char BOOLEAN_CODE = 'Z';
    private static final char CHAR_CODE = 'C';
    private static final char BYTE_CODE = 'B';
    private static final char SHORT_CODE = 'S';
    private static final char INT_CODE = 'I';
    private static final char LONG_CODE = 'J';
    private static final char FLOAT_CODE = 'F';
    private static final char DOUBLE_CODE = 'D';
    private static final char OBJECT_CODE = 'L';
    private final List<ClassInfo> classes;
    private final List<ClassInfo> permGenClasses;
    private final Date time;
    private long totalHeapBytes;
    private long totalHeapInstances;
    private long totalPermGenBytes;
    private long totalPermgenInstances;
    private boolean sourceDisplayed;
    private boolean deltaDisplayed;

    HeapHistogram(InputStream in, boolean jrockit) {
        HashMap<String, ClassInfo> classesMap = new HashMap<String, ClassInfo>(1024);
        HashMap<String, ClassInfo> permGenMap = new HashMap<String, ClassInfo>(1024);
        this.time = new Date();
        Scanner sc = new Scanner(in, "UTF-8");
        sc.useRadix(10);
        this.skipHeader(sc, jrockit);
        String nextLine = jrockit ? "[0-9.]+%" : "[0-9]+:";
        while (sc.hasNext(nextLine)) {
            ClassInfo newClInfo = new ClassInfo(sc, jrockit);
            if (newClInfo.isPermGen()) {
                this.storeClassInfo(newClInfo, permGenMap);
                this.totalPermGenBytes += newClInfo.getBytes();
                this.totalPermgenInstances += newClInfo.getInstancesCount();
            } else {
                this.storeClassInfo(newClInfo, classesMap);
                this.totalHeapBytes += newClInfo.getBytes();
                this.totalHeapInstances += newClInfo.getInstancesCount();
            }
            if (!this.sourceDisplayed && newClInfo.getSource() != null) {
                this.sourceDisplayed = true;
            }
            if (this.deltaDisplayed || newClInfo.getBytesDelta() == 0L) continue;
            this.deltaDisplayed = true;
        }
        if (!jrockit) {
            sc.next("Total");
            long totalInstances = sc.nextLong();
            long totalBytes = sc.nextLong();
            assert (totalInstances == this.totalPermgenInstances + this.totalHeapInstances);
            assert (totalBytes == this.totalPermGenBytes + this.totalHeapBytes);
        }
        this.classes = new ArrayList(classesMap.values());
        this.permGenClasses = new ArrayList(permGenMap.values());
        this.sort();
    }

    private void skipHeader(Scanner sc, boolean jrockit) {
        sc.nextLine();
        sc.nextLine();
        if (!jrockit) {
            sc.skip("-+");
            sc.nextLine();
        }
    }

    void add(HeapHistogram second) {
        HashMap<String, ClassInfo> classesMap = new HashMap<String, ClassInfo>(1024);
        HashMap<String, ClassInfo> permGenMap = new HashMap<String, ClassInfo>(1024);
        for (ClassInfo classInfo : this.classes) {
            this.storeClassInfo(classInfo, classesMap);
        }
        for (ClassInfo classInfo : this.permGenClasses) {
            this.storeClassInfo(classInfo, permGenMap);
        }
        for (ClassInfo classInfo : second.getHeapHistogram()) {
            this.storeClassInfo(classInfo, classesMap);
        }
        for (ClassInfo classInfo : second.getPermGenHistogram()) {
            this.storeClassInfo(classInfo, permGenMap);
        }
        this.totalHeapBytes += second.getTotalHeapBytes();
        this.totalHeapInstances += second.getTotalHeapInstances();
        this.totalPermGenBytes += second.getTotalPermGenBytes();
        this.totalPermgenInstances += second.getTotalPermGenInstances();
        this.classes.clear();
        this.classes.addAll(new ArrayList(classesMap.values()));
        this.permGenClasses.clear();
        this.permGenClasses.addAll(new ArrayList(permGenMap.values()));
        this.sort();
        this.sourceDisplayed = this.sourceDisplayed || second.isSourceDisplayed();
        this.deltaDisplayed = this.deltaDisplayed || second.isDeltaDisplayed();
    }

    private void sort() {
        Comparator<ClassInfo> classInfoReversedComparator = Collections.reverseOrder(new ClassInfoComparator());
        Collections.sort(this.permGenClasses, classInfoReversedComparator);
        Collections.sort(this.classes, classInfoReversedComparator);
    }

    private void storeClassInfo(ClassInfo newClInfo, Map<String, ClassInfo> map) {
        ClassInfo oldClInfo = map.get(newClInfo.getName());
        if (oldClInfo == null) {
            map.put(newClInfo.getName(), newClInfo);
        } else {
            oldClInfo.setBytes(oldClInfo.getBytes() + newClInfo.getBytes());
            oldClInfo.setBytesDelta(oldClInfo.getBytesDelta() + newClInfo.getBytesDelta());
            oldClInfo.setInstancesCount(oldClInfo.getInstancesCount() + newClInfo.getInstancesCount());
        }
    }

    Date getTime() {
        return this.time;
    }

    List<ClassInfo> getHeapHistogram() {
        return Collections.unmodifiableList(this.classes);
    }

    long getTotalHeapInstances() {
        return this.totalHeapInstances;
    }

    long getTotalHeapBytes() {
        return this.totalHeapBytes;
    }

    List<ClassInfo> getPermGenHistogram() {
        return Collections.unmodifiableList(this.permGenClasses);
    }

    long getTotalPermGenInstances() {
        return this.totalPermgenInstances;
    }

    long getTotalPermGenBytes() {
        return this.totalPermGenBytes;
    }

    boolean isSourceDisplayed() {
        return this.sourceDisplayed;
    }

    boolean isDeltaDisplayed() {
        return this.deltaDisplayed;
    }

    static class ClassInfo
    implements Serializable {
        private static final long serialVersionUID = 6283636454450216347L;
        private long instances;
        private long bytes;
        private long bytesDelta;
        private final String jvmName;
        private final String name;
        private final boolean permGen;
        private final String source;

        ClassInfo(Scanner sc, boolean jrockit) {
            sc.next();
            if (jrockit) {
                this.bytes = ClassInfo.parseLongWithK(sc.next());
                this.instances = sc.nextLong();
                this.bytesDelta = ClassInfo.parseLongWithK(sc.next());
            } else {
                this.instances = sc.nextLong();
                this.bytes = sc.nextLong();
            }
            this.jvmName = sc.next();
            this.permGen = this.jvmName.charAt(0) == '<';
            this.name = this.convertJVMName();
            this.source = this.findSource();
        }

        String getName() {
            return this.name;
        }

        long getInstancesCount() {
            return this.instances;
        }

        void setInstancesCount(long instancesCount) {
            this.instances = instancesCount;
        }

        long getBytes() {
            return this.bytes;
        }

        void setBytes(long bytes) {
            this.bytes = bytes;
        }

        long getBytesDelta() {
            return this.bytesDelta;
        }

        void setBytesDelta(long bytesDelta) {
            this.bytesDelta = bytesDelta;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ClassInfo) {
                return this.getName().equals(((ClassInfo)obj).getName());
            }
            return false;
        }

        boolean isPermGen() {
            return this.permGen;
        }

        String getSource() {
            return this.source;
        }

        private String findSource() {
            if (this.jvmName.endsWith("Klass>") || this.jvmName.startsWith("sun.reflect.")) {
                return null;
            }
            try {
                Class<?> clazz = Class.forName(this.jvmName);
                return ClassInfo.findSource(clazz);
            }
            catch (LinkageError e) {
                return null;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static String findSource(Class<?> clazz) {
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null && codeSource.getLocation() != null) {
                String src = codeSource.getLocation().toString();
                if (src.startsWith("file:/")) {
                    src = src.substring("file:/".length());
                } else if (src.startsWith("vfs:/")) {
                    src = src.substring("vfs:/".length());
                } else if (src.startsWith("reference:file:/")) {
                    src = src.substring("reference:file:/".length());
                }
                if (src.endsWith(".jar") || src.endsWith(".war")) {
                    src = src.intern();
                }
                return src;
            }
            return null;
        }

        private String convertJVMName() {
            String result;
            int index = this.jvmName.lastIndexOf(91);
            if (index != -1) {
                switch (this.jvmName.charAt(index + 1)) {
                    case 'Z': {
                        result = HeapHistogram.BOOLEAN_TEXT;
                        break;
                    }
                    case 'C': {
                        result = HeapHistogram.CHAR_TEXT;
                        break;
                    }
                    case 'B': {
                        result = HeapHistogram.BYTE_TEXT;
                        break;
                    }
                    case 'S': {
                        result = HeapHistogram.SHORT_TEXT;
                        break;
                    }
                    case 'I': {
                        result = HeapHistogram.INT_TEXT;
                        break;
                    }
                    case 'J': {
                        result = HeapHistogram.LONG_TEXT;
                        break;
                    }
                    case 'F': {
                        result = HeapHistogram.FLOAT_TEXT;
                        break;
                    }
                    case 'D': {
                        result = HeapHistogram.DOUBLE_TEXT;
                        break;
                    }
                    case 'L': {
                        result = this.jvmName.substring(index + 2, this.jvmName.length() - 1);
                        break;
                    }
                    default: {
                        result = this.jvmName;
                    }
                }
                StringBuilder sb = new StringBuilder(result);
                for (int i = 0; i <= index; ++i) {
                    sb.append("[]");
                }
                result = sb.toString();
            } else {
                result = this.jvmName;
            }
            return result.intern();
        }

        static long parseLongWithK(String text) {
            assert (text.length() > 0);
            if (text.charAt(text.length() - 1) == 'k') {
                String t = text.substring(0, text.length() - 1);
                if (t.charAt(0) == '+') {
                    t = t.substring(1);
                }
                return 1024L * Long.parseLong(t);
            }
            return Long.parseLong(text);
        }
    }

    static final class ClassInfoComparator
    implements Comparator<ClassInfo>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ClassInfoComparator() {
        }

        @Override
        public int compare(ClassInfo classInfo1, ClassInfo classInfo2) {
            if (classInfo1.getBytes() > classInfo2.getBytes()) {
                return 1;
            }
            if (classInfo1.getBytes() < classInfo2.getBytes()) {
                return -1;
            }
            return 0;
        }
    }
}

