/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.bull.javamelody.MBeans;

final class TomcatInformations
implements Serializable {
    private static final boolean TOMCAT_USED = System.getProperty("catalina.home") != null;
    private static final long serialVersionUID = -6145865427461051370L;
    private static final List<ObjectName> THREAD_POOLS = new ArrayList<ObjectName>();
    private static final List<ObjectName> GLOBAL_REQUEST_PROCESSORS = new ArrayList<ObjectName>();
    private static boolean mbeansInitialized;
    private final String name;
    private final int maxThreads;
    private final int currentThreadCount;
    private final int currentThreadsBusy;
    private final long bytesReceived;
    private final long bytesSent;
    private final int requestCount;
    private final int errorCount;
    private final long processingTime;
    private final long maxTime;

    private TomcatInformations(MBeans mBeans, ObjectName threadPool) throws JMException {
        this.name = threadPool.getKeyProperty("name");
        this.maxThreads = (Integer)mBeans.getAttribute(threadPool, "maxThreads");
        this.currentThreadCount = (Integer)mBeans.getAttribute(threadPool, "currentThreadCount");
        this.currentThreadsBusy = (Integer)mBeans.getAttribute(threadPool, "currentThreadsBusy");
        ObjectName grp = null;
        for (ObjectName globalRequestProcessor : GLOBAL_REQUEST_PROCESSORS) {
            if (!this.name.equals(globalRequestProcessor.getKeyProperty("name"))) continue;
            grp = globalRequestProcessor;
            break;
        }
        if (grp != null) {
            this.bytesReceived = (Long)mBeans.getAttribute(grp, "bytesReceived");
            this.bytesSent = (Long)mBeans.getAttribute(grp, "bytesSent");
            this.requestCount = (Integer)mBeans.getAttribute(grp, "requestCount");
            this.errorCount = (Integer)mBeans.getAttribute(grp, "errorCount");
            this.processingTime = (Long)mBeans.getAttribute(grp, "processingTime");
            this.maxTime = (Long)mBeans.getAttribute(grp, "maxTime");
        } else {
            this.bytesReceived = 0L;
            this.bytesSent = 0L;
            this.requestCount = 0;
            this.errorCount = 0;
            this.processingTime = 0L;
            this.maxTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<TomcatInformations> buildTomcatInformationsList() {
        if (!TOMCAT_USED) {
            return Collections.emptyList();
        }
        try {
            List<ObjectName> list = THREAD_POOLS;
            synchronized (list) {
                if (!mbeansInitialized) {
                    TomcatInformations.initMBeans();
                    mbeansInitialized = true;
                }
            }
            MBeans mBeans = new MBeans();
            ArrayList<TomcatInformations> tomcatInformationsList = new ArrayList<TomcatInformations>(THREAD_POOLS.size());
            for (ObjectName threadPool : THREAD_POOLS) {
                tomcatInformationsList.add(new TomcatInformations(mBeans, threadPool));
            }
            return tomcatInformationsList;
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptyList();
        }
        catch (AttributeNotFoundException e) {
            return Collections.emptyList();
        }
        catch (JMException e) {
            throw new IllegalStateException(e);
        }
    }

    static void initMBeans() throws MalformedObjectNameException {
        MBeans mBeans = new MBeans();
        THREAD_POOLS.clear();
        GLOBAL_REQUEST_PROCESSORS.clear();
        THREAD_POOLS.addAll(mBeans.getTomcatThreadPools());
        GLOBAL_REQUEST_PROCESSORS.addAll(mBeans.getTomcatGlobalRequestProcessors());
    }

    String getName() {
        return this.name;
    }

    int getMaxThreads() {
        return this.maxThreads;
    }

    int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    int getCurrentThreadsBusy() {
        return this.currentThreadsBusy;
    }

    long getBytesReceived() {
        return this.bytesReceived;
    }

    long getBytesSent() {
        return this.bytesSent;
    }

    int getRequestCount() {
        return this.requestCount;
    }

    int getErrorCount() {
        return this.errorCount;
    }

    long getProcessingTime() {
        return this.processingTime;
    }

    long getMaxTime() {
        return this.maxTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", maxThreads=" + this.getMaxThreads() + ", currentThreadCount=" + this.getCurrentThreadCount() + ", currentThreadsBusy=" + this.getCurrentThreadsBusy() + ", bytesReceived=" + this.getBytesReceived() + ", bytesSent=" + this.getBytesSent() + ", requestCount=" + this.getRequestCount() + ", errorCount=" + this.getErrorCount() + ", processingTime=" + this.getProcessingTime() + ", maxTime=" + this.getMaxTime() + ']';
    }
}

