/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.bull.javamelody.JavaLogger;
import net.bull.javamelody.JavaMelodyLogger;
import net.bull.javamelody.Log4JLogger;
import net.bull.javamelody.LogbackLogger;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

final class LOG {
    static final boolean LOG4J_ENABLED = LOG.isLog4jEnabled();
    static final boolean LOGBACK_ENABLED = LOG.isLogbackEnabled();
    static final int MAX_DEBUGGING_LOGS_COUNT = 50;
    private static final JavaMelodyLogger JAVA_MELODY_LOGGER = LOG.getJavaMelodyLogger();
    private static final LinkedList<String> DEBUGGING_LOGS = new LinkedList();

    private LOG() {
    }

    static void logHttpRequest(HttpServletRequest httpRequest, String requestName, long duration, boolean systemError, int responseSize, String filterName) {
        JAVA_MELODY_LOGGER.logHttpRequest(httpRequest, requestName, duration, systemError, responseSize, filterName);
    }

    public static String buildLogMessage(HttpServletRequest httpRequest, long duration, boolean systemError, int responseSize) {
        StringBuilder msg = new StringBuilder();
        msg.append("remoteAddr = ").append(httpRequest.getRemoteAddr());
        String forwardedFor = httpRequest.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            msg.append(", forwardedFor = ").append(forwardedFor);
        }
        msg.append(", request = ").append(httpRequest.getRequestURI().substring(httpRequest.getContextPath().length()));
        if (httpRequest.getQueryString() != null) {
            msg.append('?').append(httpRequest.getQueryString());
        }
        msg.append(' ').append(httpRequest.getMethod());
        msg.append(": ").append(duration).append(" ms");
        if (systemError) {
            msg.append(", erreur");
        }
        msg.append(", ").append(responseSize / 1024).append(" Ko");
        return msg.toString();
    }

    static void debug(String msg) {
        JAVA_MELODY_LOGGER.debug(msg);
        LOG.addDebuggingLog("DEBUG", msg);
    }

    static void debug(String msg, Throwable throwable) {
        JAVA_MELODY_LOGGER.debug(msg, throwable);
        LOG.addDebuggingLog("DEBUG", msg);
    }

    static void info(String msg, Throwable throwable) {
        JAVA_MELODY_LOGGER.info(msg, throwable);
        LOG.addDebuggingLog("INFO", msg);
    }

    static void info(String msg) {
        JAVA_MELODY_LOGGER.info(msg);
        LOG.addDebuggingLog("INFO", msg);
    }

    static void warn(String msg, Throwable throwable) {
        try {
            JAVA_MELODY_LOGGER.warn(msg, throwable);
            LOG.addDebuggingLog("WARN", msg);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> getDebuggingLogs() {
        LinkedList<String> linkedList = DEBUGGING_LOGS;
        synchronized (linkedList) {
            return new ArrayList<String>(DEBUGGING_LOGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addDebuggingLog(String level, String msg) {
        LinkedList<String> linkedList = DEBUGGING_LOGS;
        synchronized (linkedList) {
            DEBUGGING_LOGS.addLast(new Date().toString() + '\t' + level + '\t' + msg);
            while (DEBUGGING_LOGS.size() > 50) {
                DEBUGGING_LOGS.removeFirst();
            }
        }
    }

    private static boolean isLog4jEnabled() {
        try {
            Class.forName("org.apache.log4j.Logger");
            Class.forName("org.apache.log4j.AppenderSkeleton");
            Class.forName("org.apache.log4j.spi.LocationInfo");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isLogbackEnabled() {
        try {
            Class.forName("ch.qos.logback.classic.Logger");
            Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
            Method method = loggerFactoryClass.getMethod("getILoggerFactory", new Class[0]);
            Object obj = method.invoke(null, new Object[0]);
            return Class.forName("ch.qos.logback.classic.LoggerContext").isAssignableFrom(obj.getClass());
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static JavaMelodyLogger getJavaMelodyLogger() {
        String loggerClass = Parameters.getParameter(Parameter.LOGGER_CLASS);
        if (loggerClass != null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                return (JavaMelodyLogger)JavaMelodyLogger.class.cast(tccl.loadClass(loggerClass).newInstance());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        if (LOGBACK_ENABLED) {
            return new LogbackLogger();
        }
        if (LOG4J_ENABLED) {
            return new Log4JLogger();
        }
        return new JavaLogger();
    }
}

