/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class SamplingProfiler {
    private static final String[] DEFAULT_EXCLUDED_PACKAGES = new String[]{"java.", "sun.", "com.sun.", "javax.", "org.apache.", "org.hibernate.", "oracle.", "org.postgresql.", "org.eclipse."};
    private static final int MAX_DATA_SIZE = 10000;
    private final String[] excludedPackages;
    private final String[] includedPackages;
    private final Map<SampledMethod, SampledMethod> data = new HashMap<SampledMethod, SampledMethod>();

    SamplingProfiler() {
        this.excludedPackages = DEFAULT_EXCLUDED_PACKAGES;
        this.includedPackages = null;
    }

    SamplingProfiler(List<String> excludedPackages, List<String> includedPackages) {
        assert (excludedPackages != null || includedPackages != null);
        this.excludedPackages = this.verifyPackageNames(excludedPackages);
        this.includedPackages = this.verifyPackageNames(includedPackages);
    }

    SamplingProfiler(String excludedPackages, String includedPackages) {
        this(SamplingProfiler.splitPackageNames(excludedPackages), SamplingProfiler.splitPackageNames(includedPackages));
    }

    private static List<String> splitPackageNames(String packageNames) {
        if (packageNames == null) {
            return null;
        }
        return Arrays.asList(packageNames.split(","));
    }

    private String[] verifyPackageNames(List<String> packageNames) {
        if (packageNames == null) {
            return null;
        }
        String[] packages = packageNames.toArray(new String[packageNames.size()]);
        for (int i = 0; i < packages.length; ++i) {
            packages[i] = packages[i].trim();
            if (packages[i].length() == 0) {
                throw new IllegalArgumentException("A package can not be empty, item " + i + " in " + packageNames);
            }
            if (packages[i].endsWith(".")) continue;
            packages[i] = packages[i] + '.';
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void update() {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        try {
            Thread currentThread = Thread.currentThread();
            block3: for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
                Thread thread = entry.getKey();
                StackTraceElement[] stackTrace = entry.getValue();
                if (stackTrace.length <= 0 || thread.getState() != Thread.State.RUNNABLE || thread == currentThread) continue;
                for (StackTraceElement element : stackTrace) {
                    if (this.isPackageExcluded(element)) continue;
                    this.addSample(element);
                    continue block3;
                }
            }
        }
        finally {
            this.limitDataSize();
        }
    }

    private void addSample(StackTraceElement element) {
        SampledMethod key = new SampledMethod(element.getClassName(), element.getMethodName());
        SampledMethod method = this.data.get(key);
        if (method == null) {
            method = key;
            this.data.put(key, method);
        }
        method.incrementCount();
    }

    private void limitDataSize() {
        long minCount = 1L;
        int size = this.data.size();
        while (size > 10000) {
            Iterator<SampledMethod> iterator = this.data.keySet().iterator();
            while (iterator.hasNext() && size > 10000) {
                SampledMethod method = iterator.next();
                if (method.getCount() > minCount) continue;
                iterator.remove();
                --size;
            }
            ++minCount;
        }
    }

    private boolean isPackageExcluded(StackTraceElement element) {
        return this.excludedPackages != null && this.isPackageMatching(element, this.excludedPackages) || this.includedPackages != null && !this.isPackageMatching(element, this.includedPackages);
    }

    private boolean isPackageMatching(StackTraceElement element, String[] packageNames) {
        String className = element.getClassName();
        for (String packageName : packageNames) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    synchronized List<SampledMethod> getHotspots(int rows) {
        ArrayList<SampledMethod> methods = new ArrayList<SampledMethod>(this.data.values());
        Collections.sort(methods);
        return methods.subList(0, Math.min(rows, methods.size()));
    }

    synchronized void clear() {
        this.data.clear();
    }

    static class SampledMethod
    implements Comparable<SampledMethod>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private long count;
        private final String className;
        private final String methodName;
        private transient int hash;

        SampledMethod(String className, String methodName) {
            assert (className != null);
            assert (methodName != null);
            this.className = className;
            this.methodName = methodName;
            this.hash = className.hashCode() * 31 + methodName.hashCode();
        }

        private Object readResolve() {
            this.hash = this.className.hashCode() * 31 + this.methodName.hashCode();
            return this;
        }

        void incrementCount() {
            ++this.count;
        }

        long getCount() {
            return this.count;
        }

        void setCount(long count) {
            this.count = count;
        }

        String getClassName() {
            return this.className;
        }

        String getMethodName() {
            return this.methodName;
        }

        @Override
        public int compareTo(SampledMethod method) {
            return this.count < method.count ? 1 : (this.count == method.count ? 0 : -1);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SampledMethod other = (SampledMethod)obj;
            return this.methodName.equals(other.methodName) && this.className.equals(other.className);
        }

        public String toString() {
            return this.className + '.' + this.methodName;
        }
    }
}

