/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.HtmlCounterErrorReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;

class HtmlCounterReport
extends HtmlAbstractReport {
    private static final int MAX_REQUEST_NAME_LENGTH = 5000;
    private static final Pattern SQL_KEYWORDS_PATTERN = Pattern.compile("\\b(select|from|where|order by|group by|update|delete|insert into|values)\\b", 2);
    private final Counter counter;
    private final Range range;
    private final CounterRequestAggregation counterRequestAggregation;
    private final HtmlCounterRequestGraphReport htmlCounterRequestGraphReport;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlCounterReport(Counter counter, Range range, Writer writer) {
        super(writer);
        assert (counter != null);
        assert (range != null);
        this.counter = counter;
        this.range = range;
        this.counterRequestAggregation = new CounterRequestAggregation(counter);
        this.htmlCounterRequestGraphReport = new HtmlCounterRequestGraphReport(range, writer);
    }

    @Override
    void toHtml() throws IOException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        if (requests.isEmpty()) {
            this.writeNoRequests();
            return;
        }
        String counterName = this.counter.getName();
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.isErrorAndNotJobCounter()) {
            assert (!requests.isEmpty());
            List<CounterRequest> summaryRequest = Collections.singletonList(requests.get(0));
            this.writeRequests(counterName, this.counter.getChildCounterName(), summaryRequest, false, true, false);
        } else {
            List<CounterRequest> summaryRequests = Arrays.asList(globalRequest, this.counterRequestAggregation.getWarningRequest(), this.counterRequestAggregation.getSevereRequest());
            this.writeRequests(globalRequest.getName(), this.counter.getChildCounterName(), summaryRequests, false, false, false);
        }
        this.writeSizeAndLinks(requests, globalRequest);
        this.writeln("<div id='details" + counterName + "' style='display: none;'>");
        this.writeRequests(counterName, this.counter.getChildCounterName(), requests, HtmlCounterReport.isRequestGraphDisplayed(this.counter), true, false);
        this.writeln("</div>");
        if (this.isErrorCounter()) {
            this.writeln("<div id='logs" + counterName + "' style='display: none;'><div>");
            new HtmlCounterErrorReport(this.counter, this.getWriter()).toHtml();
            this.writeln("</div></div>");
        }
    }

    private void writeSizeAndLinks(List<CounterRequest> requests, CounterRequest globalRequest) throws IOException {
        long end = this.range.getEndDate() != null ? Math.min(this.range.getEndDate().getTime(), System.currentTimeMillis()) : System.currentTimeMillis();
        long deltaMillis = Math.max(end - this.counter.getStartDate().getTime(), 1L);
        long hitsParMinute = 60000L * globalRequest.getHits() / deltaMillis;
        this.writeln("<div align='right'>");
        String nbKey = this.isJobCounter() ? "nb_jobs" : (this.isErrorCounter() ? "nb_erreurs" : "nb_requetes");
        this.writeln(HtmlCounterReport.getFormattedString(nbKey, this.integerFormat.format(hitsParMinute), this.integerFormat.format(requests.size())));
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        if (this.counter.isBusinessFacadeCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?part=counterSummaryPerClass&amp;counter=" + this.counter.getName() + "' class='noPrint'>#Resume_par_classe#</a>");
            if (HtmlCounterReport.isPdfEnabled()) {
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<a href='?part=runtimeDependencies&amp;format=pdf&amp;counter=" + this.counter.getName() + "' class='noPrint'>#Dependances#</a>");
            }
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeShowHideLink("details" + this.counter.getName(), "#Details#");
        if (this.isErrorCounter()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeShowHideLink("logs" + this.counter.getName(), "#Dernieres_erreurs#");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        if (this.range.getPeriod() == Period.TOUT) {
            this.writeln("<a href='?action=clear_counter&amp;counter=" + this.counter.getName() + HtmlCounterReport.getCsrfTokenUrlPart() + "' title='" + HtmlCounterReport.getFormattedString("Vider_stats", this.counter.getName()) + '\'');
            this.writeln("class='noPrint' onclick=\"javascript:return confirm('" + HtmlCounterReport.javascriptEncode(HtmlCounterReport.getFormattedString("confirm_vider_stats", this.counter.getName())) + "');\">#Reinitialiser#</a>");
        }
        this.writeln("</div>");
    }

    private void writeNoRequests() throws IOException {
        if (this.isJobCounter()) {
            this.writeln("#Aucun_job#");
        } else if (this.isErrorCounter()) {
            this.writeln("#Aucune_erreur#");
        } else {
            this.writeln("#Aucune_requete#");
        }
    }

    private boolean isErrorCounter() {
        return this.counter.isErrorCounter();
    }

    private boolean isJobCounter() {
        return this.counter.isJobCounter();
    }

    private boolean isErrorAndNotJobCounter() {
        return this.isErrorCounter() && !this.isJobCounter();
    }

    static boolean isRequestGraphDisplayed(Counter parentCounter) {
        return (!parentCounter.isErrorCounter() || parentCounter.isJobCounter()) && !parentCounter.isJspOrStrutsCounter();
    }

    void writeRequestsAggregatedOrFilteredByClassName(String requestId) throws IOException {
        List<CounterRequest> requestList = this.counterRequestAggregation.getRequestsAggregatedOrFilteredByClassName(requestId);
        boolean includeSummaryPerClassLink = requestId == null;
        boolean includeDetailLink = !includeSummaryPerClassLink;
        this.writeRequests(this.counter.getName(), this.counter.getChildCounterName(), requestList, includeDetailLink, includeDetailLink, includeSummaryPerClassLink);
    }

    private void writeRequests(String tableName, String childCounterName, List<CounterRequest> requestList, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        assert (requestList != null);
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(tableName);
        this.writeTableHead(childCounterName);
        for (CounterRequest request : requestList) {
            table.nextRow();
            this.writeRequest(request, includeGraph, includeDetailLink, includeSummaryPerClassLink);
        }
        table.endTable();
    }

    private void writeTableHead(String childCounterName) throws IOException {
        if (this.isJobCounter()) {
            this.write("<th>#Job#</th>");
        } else if (this.isErrorCounter()) {
            this.write("<th>#Erreur#</th>");
        } else {
            this.write("<th>#Requete#</th>");
        }
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_moyen#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_max#</th>");
            this.write("<th class='sorttable_numeric'>#Ecart_type#</th>");
        } else {
            this.write("<th class='sorttable_numeric'>#Hits#</th>");
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("<th class='sorttable_numeric'>#temps_cpu_cumule#</th>");
            this.write("<th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("<th class='sorttable_numeric'>#erreur_systeme#</th>");
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("<th class='sorttable_numeric'>#Taille_moyenne#</th>");
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("<th class='sorttable_numeric'>" + HtmlCounterReport.getFormattedString("hits_fils_moyens", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + HtmlCounterReport.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
    }

    private void writeRequest(CounterRequest request, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        String nextColumn = "</td> <td align='right'>";
        this.write("<td class='wrappedText'>");
        this.writeRequestName(request.getId(), request.getName(), includeGraph, includeDetailLink, includeSummaryPerClassLink);
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getDurationsSum(), globalRequest.getDurationsSum());
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
            this.write("</td> <td align='right'>");
            int mean = request.getMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(mean));
            this.write("'>");
            this.write(this.integerFormat.format(mean));
            this.write("</span>");
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getMaximum()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getStandardDeviation()));
        } else {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getHits()));
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.write("</td> <td align='right'>");
            this.writePercentage(request.getCpuTimeSum(), globalRequest.getCpuTimeSum());
            this.write("</td> <td align='right'>");
            int cpuTimeMean = request.getCpuTimeMean();
            this.write("<span class='");
            this.write(this.getSlaHtmlClass(cpuTimeMean));
            this.write("'>");
            this.write(this.integerFormat.format(cpuTimeMean));
            this.write("</span>");
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.write("</td> <td align='right'>");
            this.write(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getResponseSizeMean() / 1024));
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildHitsMean()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(request.getChildDurationsMean()));
        }
        this.write("</td>");
    }

    void writeRequestName(String requestId, String requestName, boolean includeGraph, boolean includeDetailLink, boolean includeSummaryPerClassLink) throws IOException {
        if (includeGraph) {
            assert (includeDetailLink);
            assert (!includeSummaryPerClassLink);
            this.htmlCounterRequestGraphReport.writeRequestGraph(requestId, requestName);
        } else if (includeDetailLink) {
            assert (!includeSummaryPerClassLink);
            this.write("<a href='?part=graph&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
            this.write("</a>");
        } else if (includeSummaryPerClassLink) {
            this.write("<a href='?part=counterSummaryPerClass&amp;counter=");
            this.write(this.counter.getName());
            this.write("&amp;graph=");
            this.write(requestId);
            this.write("'>");
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
            this.write("</a> ");
        } else {
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
        }
    }

    String getSlaHtmlClass(int mean) {
        String color = mean < this.counterRequestAggregation.getWarningThreshold() || mean == 0 ? "info" : (mean < this.counterRequestAggregation.getSevereThreshold() ? "warning" : "severe");
        return color;
    }

    private void writePercentage(long dividende, long diviseur) throws IOException {
        if (diviseur == 0L) {
            this.write("0");
        } else {
            this.write(this.integerFormat.format(100L * dividende / diviseur));
        }
    }

    static String htmlEncodeRequestName(String requestId, String requestName) {
        if (requestId.startsWith("sql")) {
            String htmlEncoded = HtmlCounterReport.htmlEncodeButNotSpace(requestName);
            return SQL_KEYWORDS_PATTERN.matcher(htmlEncoded).replaceAll("<span class='sqlKeyword'>$1</span>");
        }
        return HtmlCounterReport.htmlEncodeButNotSpace(requestName);
    }

    static class HtmlCounterRequestGraphReport
    extends HtmlAbstractReport {
        private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
        private static final String SCRIPT_END = "</script>";
        private static int uniqueByPageAndGraphSequence;
        private final Range range;
        private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
        private final DecimalFormat nbExecutionsFormat = I18N.createPercentFormat();
        private final DecimalFormat integerFormat = I18N.createIntegerFormat();
        private List<Counter> counters;
        private Map<String, CounterRequest> requestsById;

        HtmlCounterRequestGraphReport(Range range, Writer writer) {
            super(writer);
            assert (range != null);
            this.range = range;
        }

        @Override
        void toHtml() {
            throw new UnsupportedOperationException();
        }

        void writeRequestGraph(String requestId, String requestName) throws IOException {
            this.write("<a class='tooltip' href='?part=graph&amp;graph=");
            this.write(requestId);
            this.write("'");
            this.write(" onmouseover=\"document.getElementById('");
            String id = "id" + ++uniqueByPageAndGraphSequence;
            this.write(id);
            this.write("').src='?graph=");
            this.write(requestId);
            this.write("&amp;width=100&amp;height=50'; this.onmouseover=null;\" >");
            this.write("<em><img src='?resource=db.png' id='");
            this.write(id);
            this.write("' alt='graph'/></em>");
            if (requestName.length() <= 5000) {
                this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
                this.write("</a>");
            } else {
                this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName.substring(0, 5000)));
                this.write("</a>");
                this.write("<br/> ");
                String idToShow = "request-" + requestId;
                this.writeShowHideLink(idToShow, "#Details#");
                this.writeln("<div id='request-" + requestId + "' style='display: none;'>");
                this.write("<br/> ");
                this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(requestId, requestName));
                this.writeln("</div> ");
            }
        }

        void writeRequestAndGraphDetail(Collector collector, CollectorServer collectorServer, String graphName) throws IOException {
            this.counters = collector.getRangeCounters(this.range);
            this.requestsById = this.mapAllRequestsById();
            CounterRequest request = this.requestsById.get(graphName);
            if (request != null) {
                this.writeRequest(request);
                if (JdbcWrapper.SINGLETON.getSqlCounter().isRequestIdFromThisCounter(graphName) && !request.getName().toLowerCase(Locale.ENGLISH).startsWith("alter ")) {
                    this.writeSqlRequestExplainPlan(collector, collectorServer, request);
                }
            }
            if (this.isGraphDisplayed(collector, request)) {
                this.writeln("<table summary=''><tr><td>");
                this.writeln("<div id='track' class='noPrint'>");
                this.writeln("<div class='selected' id='handle'>");
                this.writeln("<img src='?resource=scaler_slider.gif' alt=''/>");
                this.writeln("</div></div>");
                this.writeln("</td><td>");
                this.writeDirectly("<div class='noPrint' style='color: #808080;'>");
                this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                this.writeln("<label for='cb'><input id='cb' type='checkbox' onclick=\"handleHideMaximumClick(this);\"/>&nbsp;#hide_maximum#</label>");
                this.writeln("</div> ");
                this.writeln("</td></tr></table>");
                this.writeln("<div align='center'>");
                this.writeln("<table summary=''><tr><td>");
                this.writeln("<img class='synth\u00e8se' id='img' src='?width=960&amp;height=400&amp;graph=" + HtmlCounterRequestGraphReport.urlEncode(graphName) + "' alt='zoom'/>");
                this.writeDirectly("<br/><div align='right' style='color: #808080;'>");
                this.writeln("#graph_units#");
                this.writeln("</div></td></tr></table>");
                this.writeln("</div>");
                this.writeln("<div align='right'><a href='?part=lastValue&amp;graph=" + HtmlCounterRequestGraphReport.urlEncode(graphName) + "' title=\"#Lien_derniere_valeur#\">_</a></div>");
                this.writeGraphDetailScript(graphName);
            }
            if (request != null && request.getStackTrace() != null) {
                this.writeln("<blockquote><blockquote><b>Stack-trace</b><br/><font size='-1'>");
                this.writeDirectly(HtmlCounterRequestGraphReport.htmlEncodeButNotSpace(request.getStackTrace()).replaceAll("\t", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"));
                this.writeln("</font></blockquote></blockquote>");
            }
        }

        private boolean isGraphDisplayed(Collector collector, CounterRequest request) {
            return request == null || this.getCounterByRequestId(request) != null && HtmlCounterReport.isRequestGraphDisplayed(this.getCounterByRequestId(request)) && collector.getJRobin(request.getId()) != null;
        }

        private void writeSqlRequestExplainPlan(Collector collector, CollectorServer collectorServer, CounterRequest sqlRequest) throws IOException {
            try {
                String explainPlan = collectorServer == null ? DatabaseInformations.explainPlanFor(sqlRequest.getName()) : collectorServer.collectSqlRequestExplainPlan(collector.getApplication(), sqlRequest.getName());
                if (explainPlan != null) {
                    this.writeln("<b>#Plan_d_execution#</b>");
                    this.writeln("<div class='explainPlan'>");
                    this.writeDirectly(explainPlan.replace(" ", "&nbsp;").replace("\n", "<br/>"));
                    this.writeln("</div><hr/>");
                }
            }
            catch (Exception e) {
                this.writeln("<b>#Plan_d_execution#</b> ");
                this.writeln(e.toString());
                this.writeln("<br/>");
            }
        }

        void writeRequestUsages(Collector collector, String requestId) throws IOException {
            assert (requestId != null);
            this.counters = collector.getRangeCounters(this.range);
            CounterRequest myRequest = null;
            ArrayList<CounterRequest> requests = new ArrayList<CounterRequest>();
            for (Counter counter : this.counters) {
                for (CounterRequest request : counter.getOrderedRequests()) {
                    if (myRequest == null && request.getId().equals(requestId)) {
                        myRequest = request;
                    }
                    if (!request.containsChildRequest(requestId)) continue;
                    requests.add(request);
                }
            }
            this.writeRequestUsages(myRequest, requests);
        }

        private void writeRequestUsages(CounterRequest myRequest, List<CounterRequest> requests) throws IOException {
            this.writeln("<br/><b>#Utilisations_de#</b>");
            if (myRequest != null) {
                this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(myRequest.getId(), myRequest.getName()));
            }
            this.writeln("<br/><br/>");
            if (requests.isEmpty()) {
                this.writeln("#Aucune_requete#");
                return;
            }
            boolean someUsagesDisplayed = this.getUsagesDisplayed(requests);
            HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
            table.beginTable(HtmlCounterRequestGraphReport.getString("Utilisations_de"));
            this.write("<th>#Requete#</th>");
            if (someUsagesDisplayed) {
                this.write("<th class='noPrint'>#Chercher_utilisations#</th>");
            }
            for (CounterRequest request : requests) {
                table.nextRow();
                this.writeUsedRequest(request, someUsagesDisplayed);
            }
            table.endTable();
        }

        private void writeUsedRequest(CounterRequest request, boolean someUsageDisplayed) throws IOException {
            this.writeln(" <td>");
            this.writeCounterIcon(request);
            this.writeRequestGraph(request.getId(), request.getName());
            if (someUsageDisplayed) {
                this.writeln("</td><td align='center' class='noPrint'>");
                if (this.doesRequestDisplayUsages(request)) {
                    this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
                    this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' title='#Chercher_utilisations#'/></a>");
                } else {
                    this.writeln("&nbsp;");
                }
            }
            this.writeln("</td>");
        }

        private boolean getUsagesDisplayed(List<CounterRequest> requests) {
            for (CounterRequest request : requests) {
                if (!this.doesRequestDisplayUsages(request)) continue;
                return true;
            }
            return false;
        }

        private void writeRequest(CounterRequest request) throws IOException {
            boolean allChildHitsDisplayed;
            boolean hasChildren;
            Map<String, Long> childRequests = request.getChildRequestsExecutionsByRequestId();
            this.writeln(" <br/>");
            HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
            table.beginTable(HtmlCounterRequestGraphReport.getString("Drill_down"));
            this.writeln("<th>#Requete#</th>");
            boolean bl = hasChildren = !childRequests.isEmpty();
            if (hasChildren) {
                this.writeln("<th class='sorttable_numeric'>#Hits_par_requete#</th>");
            }
            this.writeln("<th class='sorttable_numeric'>#Temps_moyen#</th><th class='sorttable_numeric'>#Temps_max#</th>");
            this.writeln("<th class='sorttable_numeric'>#Ecart_type#</th><th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
            this.writeln("<th class='sorttable_numeric'>#erreur_systeme#</th>");
            Counter parentCounter = this.getCounterByRequestId(request);
            boolean bl2 = allChildHitsDisplayed = parentCounter != null && parentCounter.getChildCounterName() != null && request.hasChildHits();
            if (allChildHitsDisplayed) {
                String childCounterName = parentCounter.getChildCounterName();
                this.writeln("<th class='sorttable_numeric'>" + HtmlCounterRequestGraphReport.getFormattedString("hits_fils_moyens", childCounterName));
                this.writeln("</th><th class='sorttable_numeric'>" + HtmlCounterRequestGraphReport.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
            }
            table.nextRow();
            this.write("<td class='wrappedText'>");
            this.writeCounterIcon(request);
            this.writeDirectly(HtmlCounterReport.htmlEncodeRequestName(request.getId(), request.getName()));
            if (hasChildren) {
                this.writeln("</td><td>&nbsp;");
            }
            this.writeRequestValues(request, allChildHitsDisplayed);
            this.writeln("</td> ");
            if (hasChildren) {
                this.writeChildRequests(request, childRequests, allChildHitsDisplayed, table);
            }
            table.endTable();
            if (this.doesRequestDisplayUsages(request)) {
                this.writeln("<div align='right' class='noPrint'>");
                this.writeln("<a href='?part=usages&amp;graph=" + request.getId() + "'>");
                this.writeln("<img src='?resource=find.png' alt='#Chercher_utilisations#' ");
                this.writeln("title='#Chercher_utilisations#'/> #Chercher_utilisations#</a></div>");
            } else {
                this.writeln("<br/>");
            }
        }

        private boolean doesRequestDisplayUsages(CounterRequest request) {
            Counter parentCounter = this.getCounterByRequestId(request);
            return parentCounter != null && !parentCounter.isErrorCounter() && !"http".equals(parentCounter.getName());
        }

        private void writeChildRequests(CounterRequest request, Map<String, Long> childRequests, boolean allChildHitsDisplayed, HtmlAbstractReport.HtmlTable table) throws IOException {
            for (Map.Entry<String, Long> entry : childRequests.entrySet()) {
                CounterRequest childRequest = this.requestsById.get(entry.getKey());
                if (childRequest == null) continue;
                table.nextRow();
                Long nbExecutions = entry.getValue();
                float executionsByRequest = (float)nbExecutions.longValue() / (float)request.getHits();
                this.writeChildRequest(childRequest, executionsByRequest, allChildHitsDisplayed);
            }
        }

        private void writeChildRequest(CounterRequest childRequest, float executionsByRequest, boolean allChildHitsDisplayed) throws IOException {
            this.writeln("<td>");
            this.writeln("<div style='margin-left: 10px;' class='wrappedText'>");
            this.writeCounterIcon(childRequest);
            this.writeRequestGraph(childRequest.getId(), childRequest.getName());
            this.writeln("</div></td><td align='right'>");
            this.write(this.nbExecutionsFormat.format(executionsByRequest));
            this.writeRequestValues(childRequest, allChildHitsDisplayed);
            this.writeln("</td>");
        }

        private void writeRequestValues(CounterRequest request, boolean allChildHitsDisplayed) throws IOException {
            String nextColumn = "</td><td align='right'>";
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getMean()));
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getMaximum()));
            this.writeln("</td><td align='right'>");
            this.writeln(this.integerFormat.format(request.getStandardDeviation()));
            this.writeln("</td><td align='right'>");
            String nbsp = "&nbsp;";
            if (request.getCpuTimeMean() >= 0) {
                this.writeln(this.integerFormat.format(request.getCpuTimeMean()));
            } else {
                this.writeln("&nbsp;");
            }
            this.writeln("</td><td align='right'>");
            this.writeln(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
            if (allChildHitsDisplayed) {
                this.writeln("</td><td align='right'>");
                boolean childHitsDisplayed = request.hasChildHits();
                if (childHitsDisplayed) {
                    this.writeln(this.integerFormat.format(request.getChildHitsMean()));
                } else {
                    this.writeln("&nbsp;");
                }
                this.writeln("</td><td align='right'>");
                if (childHitsDisplayed) {
                    this.writeln(this.integerFormat.format(request.getChildDurationsMean()));
                } else {
                    this.writeln("&nbsp;");
                }
            }
        }

        private void writeCounterIcon(CounterRequest request) throws IOException {
            Counter parentCounter = this.getCounterByRequestId(request);
            if (parentCounter != null && parentCounter.getIconName() != null) {
                this.writeln("<img src='?resource=" + parentCounter.getIconName() + "' alt='" + parentCounter.getName() + "' width='16' height='16' />&nbsp;");
            }
        }

        private void writeGraphDetailScript(String graphName) throws IOException {
            this.writeln(SCRIPT_BEGIN);
            this.writeln("function handleHideMaximumClick(checkbox) {");
            this.writeln("    var img = document.getElementById('img');");
            this.writeln("    if (checkbox.checked) {");
            this.writeln("        img.src = img.src + '\\u0026max=false\\u0026r=' + Math.random();");
            this.writeln("    } else {");
            this.writeln("        img.src = img.src.replace('\\u0026max=false','');");
            this.writeln("    }");
            this.writeln("}");
            this.writeln("function scaleImage(v, min, max) {");
            this.writeln("    var images = document.getElementsByClassName('synth\u00e8se');");
            this.writeln("    w = (max - min) * v + min;");
            this.writeln("    for (i = 0; i < images.length; i++) {");
            this.writeln("        images[i].style.width = w + 'px';");
            this.writeln("    }");
            this.writeln("}");
            this.writeln("var slider = new Control.Slider('handle', 'track', {axis:'horizontal', alignX: 0, increment: 2});");
            this.writeln("slider.options.onSlide = function(value) {");
            this.writeln("  scaleImage(value, initialWidth, initialWidth / 2 * 3);");
            this.writeln("}");
            this.writeln("slider.options.onChange = function(value) {");
            this.writeln("  width = Math.round(Element.getStyle('img','width').replace('px','')) - 80;");
            this.writeln("  height = Math.round(width * initialHeight / initialWidth) - 48;");
            this.writeln("  document.getElementById('img').src = '?graph=" + HtmlCounterRequestGraphReport.htmlEncodeButNotSpace(HtmlCounterRequestGraphReport.urlEncode(graphName)) + "\\u0026width=' + width + '\\u0026height=' + height;");
            this.writeln("  document.getElementById('img').style.width = '';");
            this.writeln("}");
            this.writeln("window.onload = function() {");
            this.writeln("  if (navigator.appName == 'Microsoft Internet Explorer') {");
            this.writeln("    initialWidth = document.getElementById('img').width;");
            this.writeln("    initialHeight = document.getElementById('img').height;");
            this.writeln("  } else {");
            this.writeln("    initialWidth = Math.round(Element.getStyle('img','width').replace('px',''));");
            this.writeln("    initialHeight = Math.round(Element.getStyle('img','height').replace('px',''));");
            this.writeln("  }");
            this.writeln("}");
            this.writeln(SCRIPT_END);
        }

        private Map<String, CounterRequest> mapAllRequestsById() {
            HashMap<String, CounterRequest> result = new HashMap<String, CounterRequest>();
            for (Counter counter : this.counters) {
                for (CounterRequest request : counter.getRequests()) {
                    result.put(request.getId(), request);
                }
            }
            return result;
        }

        private Counter getCounterByRequestId(CounterRequest request) {
            String requestId = request.getId();
            for (Counter counter : this.counters) {
                if (!counter.isRequestIdFromThisCounter(requestId)) continue;
                return counter;
            }
            return null;
        }
    }
}

