/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.CacheInformations;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfAbstractReport;
import net.bull.javamelody.PdfCacheInformationsReport;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfCounterRequestContextReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.PdfJavaInformationsReport;
import net.bull.javamelody.PdfJobInformationsReport;
import net.bull.javamelody.PdfThreadInformationsReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.Range;

class PdfCoreReport
extends PdfAbstractReport {
    static final int SMALL_GRAPH_WIDTH = 200;
    static final int SMALL_GRAPH_HEIGHT = 50;
    static final int LARGE_GRAPH_WIDTH = 960;
    static final int LARGE_GRAPH_HEIGHT = 370;
    private final Collector collector;
    private final List<JavaInformations> javaInformationsList;
    private final Range range;
    private Range counterRange;
    private List<CounterRequestContext> currentRequests;
    private final boolean collectorServer;
    private final PdfDocumentFactory pdfDocumentFactory;
    private final Font normalFont = PdfFonts.NORMAL.getFont();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font boldFont = PdfFonts.BOLD.getFont();
    private final long start = System.currentTimeMillis();
    private Map<String, byte[]> smallGraphs;
    private Map<String, byte[]> smallOtherGraphs;
    private Map<String, byte[]> largeGraphs;

    PdfCoreReport(Collector collector, boolean collectorServer, List<JavaInformations> javaInformationsList, Range range, PdfDocumentFactory pdfDocumentFactory, Document document) {
        super(document);
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        assert (pdfDocumentFactory != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.javaInformationsList = javaInformationsList;
        this.range = range;
        this.counterRange = range;
        this.pdfDocumentFactory = pdfDocumentFactory;
    }

    void preInitGraphs(Map<String, byte[]> newSmallGraphs, Map<String, byte[]> newSmallOtherGraphs, Map<String, byte[]> newLargeGraphs) {
        this.smallGraphs = newSmallGraphs;
        this.smallOtherGraphs = newSmallOtherGraphs;
        this.largeGraphs = newLargeGraphs;
    }

    void setCounterRange(Range counterRange) {
        this.counterRange = counterRange;
    }

    void setCurrentRequests(List<CounterRequestContext> currentRequests) {
        this.currentRequests = currentRequests;
    }

    @Override
    void toPdf() throws IOException, DocumentException {
        this.addParagraph(this.buildSummary(), "systemmonitor.png");
        this.writeGraphs(this.collector.getDisplayedCounterJRobins(), this.smallGraphs);
        List<Counter> counters = this.collector.getRangeCountersToBeDisplayed(this.counterRange);
        List<PdfCounterReport> pdfCounterReports = this.writeCounters(counters);
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        if (!this.collectorServer) {
            this.addParagraph(PdfCoreReport.getString("Requetes_en_cours"), "hourglass.png");
            pdfCounterRequestContextReports.addAll(this.writeCurrentRequests(this.javaInformationsList.get(0), counters, pdfCounterReports));
        }
        this.addToDocument((Element)new Phrase("\n", this.normalFont));
        this.addParagraph(PdfCoreReport.getString("Informations_systemes"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.getDocument()).toPdf();
        this.addParagraph(PdfCoreReport.getString("Threads"), "threads.png");
        this.writeThreads(false);
        PdfCounterReport pdfJobCounterReport = null;
        Counter rangeJobCounter = null;
        if (this.isJobEnabled()) {
            rangeJobCounter = this.collector.getRangeCounter(this.counterRange, "job");
            this.addToDocument((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfCoreReport.getString("Jobs"), "jobs.png");
            this.writeJobs(rangeJobCounter, false);
            pdfJobCounterReport = this.writeCounter(rangeJobCounter);
        }
        if (this.isCacheEnabled()) {
            this.addToDocument((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfCoreReport.getString("Caches"), "caches.png");
            this.writeCaches(false);
        }
        this.newPage();
        this.addParagraph(PdfCoreReport.getString("Statistiques_detaillees"), "systemmonitor.png");
        this.writeGraphs(this.collector.getDisplayedOtherJRobins(), this.smallOtherGraphs);
        this.writeGraphDetails();
        this.writeCountersDetails(pdfCounterReports);
        if (!this.collectorServer) {
            this.addParagraph(PdfCoreReport.getString("Requetes_en_cours_detaillees"), "hourglass.png");
            this.writeCurrentRequestsDetails(pdfCounterRequestContextReports);
        }
        this.addParagraph(PdfCoreReport.getString("Informations_systemes_detaillees"), "systeminfo.png");
        new PdfJavaInformationsReport(this.javaInformationsList, this.getDocument()).writeInformationsDetails();
        this.addParagraph(PdfCoreReport.getString("Threads_detailles"), "threads.png");
        this.writeThreads(true);
        if (this.isJobEnabled()) {
            this.addToDocument((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfCoreReport.getString("Jobs_detailles"), "jobs.png");
            this.writeJobs(rangeJobCounter, true);
            this.writeCounterDetails(pdfJobCounterReport);
        }
        if (this.isCacheEnabled()) {
            this.addToDocument((Element)new Phrase("\n", this.normalFont));
            this.addParagraph(PdfCoreReport.getString("Caches_detailles"), "caches.png");
            this.writeCaches(true);
        }
        this.writeDurationAndOverhead();
    }

    private String buildSummary() {
        String tmp;
        if (this.range.getPeriod() == Period.TOUT) {
            String startDate = I18N.createDateAndTimeFormat().format(this.collector.getCounters().get(0).getStartDate());
            tmp = PdfCoreReport.getFormattedString("Statistiques", "JavaMelody", I18N.getCurrentDateAndTime(), startDate, this.collector.getApplication());
        } else {
            tmp = PdfCoreReport.getFormattedString("Statistiques_sans_depuis", "JavaMelody", I18N.getCurrentDateAndTime(), this.collector.getApplication());
        }
        if (this.javaInformationsList.get(0).getContextDisplayName() != null) {
            return tmp + " (" + this.javaInformationsList.get(0).getContextDisplayName() + ')';
        }
        return tmp;
    }

    private void writeGraphs(Collection<JRobin> jrobins, Map<String, byte[]> mySmallGraphs) throws IOException, DocumentException {
        if (this.collector.isStopped()) {
            String message = PdfCoreReport.getString("collect_server_misusage");
            Paragraph jrobinParagraph = new Paragraph(message, PdfFonts.BOLD.getFont());
            jrobinParagraph.setAlignment(1);
            this.addToDocument((Element)jrobinParagraph);
            return;
        }
        Paragraph jrobinParagraph = new Paragraph("", FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0));
        jrobinParagraph.setAlignment(1);
        jrobinParagraph.add((Object)new Phrase("\n\n\n\n"));
        int i = 0;
        if (mySmallGraphs != null) {
            for (byte[] imageData : mySmallGraphs.values()) {
                if (i % 3 == 0 && i != 0) {
                    jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
                }
                Image image = Image.getInstance((byte[])imageData);
                image.scalePercent(50.0f);
                jrobinParagraph.add((Object)new Phrase(new Chunk(image, 0.0f, 0.0f)));
                jrobinParagraph.add((Object)new Phrase(" "));
                ++i;
            }
        } else {
            if (jrobins.isEmpty()) {
                return;
            }
            for (JRobin jrobin : jrobins) {
                if (i % 3 == 0 && i != 0) {
                    jrobinParagraph.add((Object)new Phrase("\n\n\n\n\n"));
                }
                Image image = Image.getInstance((byte[])jrobin.graph(this.range, 200, 50));
                image.scalePercent(50.0f);
                jrobinParagraph.add((Object)new Phrase(new Chunk(image, 0.0f, 0.0f)));
                jrobinParagraph.add((Object)new Phrase(" "));
                ++i;
            }
        }
        jrobinParagraph.add((Object)new Phrase("\n"));
        this.addToDocument((Element)jrobinParagraph);
    }

    private void writeGraphDetails() throws IOException, DocumentException {
        if (this.collector.isStopped()) {
            return;
        }
        PdfPTable jrobinTable = new PdfPTable(1);
        jrobinTable.setHorizontalAlignment(1);
        jrobinTable.setWidthPercentage(100.0f);
        jrobinTable.getDefaultCell().setBorder(0);
        if (this.largeGraphs != null) {
            for (byte[] imageData : this.largeGraphs.values()) {
                Image image = Image.getInstance((byte[])imageData);
                jrobinTable.addCell(image);
            }
        } else {
            Collection<JRobin> counterJRobins = this.collector.getDisplayedCounterJRobins();
            if (counterJRobins.isEmpty()) {
                return;
            }
            for (JRobin jrobin : counterJRobins) {
                Image image = Image.getInstance((byte[])jrobin.graph(this.range, 960, 370));
                jrobinTable.addCell(image);
            }
        }
        this.newPage();
        this.addToDocument((Element)jrobinTable);
        this.newPage();
    }

    private List<PdfCounterReport> writeCounters(List<Counter> counters) throws IOException, DocumentException {
        ArrayList<PdfCounterReport> pdfCounterReports = new ArrayList<PdfCounterReport>();
        for (Counter counter : counters) {
            pdfCounterReports.add(this.writeCounter(counter));
        }
        return pdfCounterReports;
    }

    private PdfCounterReport writeCounter(Counter counter) throws DocumentException, IOException {
        String counterLabel = PdfCoreReport.getString(counter.getName() + "Label");
        this.addParagraph(PdfCoreReport.getFormattedString("Statistiques_compteur", counterLabel) + " - " + this.range.getLabel(), counter.getIconName());
        PdfCounterReport pdfCounterReport = new PdfCounterReport(this.collector, counter, this.range, false, this.getDocument());
        pdfCounterReport.toPdf();
        return pdfCounterReport;
    }

    private void writeCountersDetails(List<PdfCounterReport> pdfCounterReports) throws DocumentException, IOException {
        for (PdfCounterReport pdfCounterReport : pdfCounterReports) {
            this.writeCounterDetails(pdfCounterReport);
        }
    }

    private void writeCounterDetails(PdfCounterReport pdfCounterReport) throws DocumentException, IOException {
        String counterLabel = PdfCoreReport.getString(pdfCounterReport.getCounterName() + "Label");
        this.addParagraph(PdfCoreReport.getFormattedString("Statistiques_compteur_detaillees", counterLabel) + " - " + this.range.getLabel(), pdfCounterReport.getCounterIconName());
        pdfCounterReport.writeRequestDetails();
        if (pdfCounterReport.isErrorCounter()) {
            this.addParagraph(PdfCoreReport.getString(pdfCounterReport.getCounterName() + "ErrorLabel") + " - " + this.range.getLabel(), pdfCounterReport.getCounterIconName());
            pdfCounterReport.writeErrorDetails();
        }
    }

    private List<PdfCounterRequestContextReport> writeCurrentRequests(JavaInformations javaInformations, List<Counter> counters, List<PdfCounterReport> pdfCounterReports) throws IOException, DocumentException {
        ArrayList<PdfCounterRequestContextReport> pdfCounterRequestContextReports = new ArrayList<PdfCounterRequestContextReport>();
        List<CounterRequestContext> rootCurrentContexts = this.currentRequests == null ? this.collector.getRootCurrentContexts(counters) : this.currentRequests;
        if (rootCurrentContexts.isEmpty()) {
            this.addToDocument((Element)new Phrase(PdfCoreReport.getString("Aucune_requete_en_cours"), this.normalFont));
        } else {
            PdfCounterRequestContextReport pdfCounterRequestContextReport = new PdfCounterRequestContextReport(rootCurrentContexts, pdfCounterReports, javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.getDocument());
            pdfCounterRequestContextReport.toPdf();
            pdfCounterRequestContextReports.add(pdfCounterRequestContextReport);
        }
        return pdfCounterRequestContextReports;
    }

    private void writeCurrentRequestsDetails(List<PdfCounterRequestContextReport> pdfCounterRequestContextReports) throws IOException, DocumentException {
        for (PdfCounterRequestContextReport pdfCounterRequestContextReport : pdfCounterRequestContextReports) {
            pdfCounterRequestContextReport.writeContextDetails();
        }
        if (pdfCounterRequestContextReports.isEmpty()) {
            this.addToDocument((Element)new Phrase(PdfCoreReport.getString("Aucune_requete_en_cours"), this.normalFont));
        }
    }

    private void writeThreads(boolean includeDetails) throws DocumentException, IOException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.addToDocument((Element)new Phrase(eol + PdfCoreReport.getFormattedString("Threads_sur", javaInformations.getHost()) + ": ", this.boldFont));
            this.addToDocument((Element)new Phrase(PdfCoreReport.getFormattedString("thread_count", javaInformations.getThreadCount(), javaInformations.getPeakThreadCount(), javaInformations.getTotalStartedThreadCount()), this.normalFont));
            PdfThreadInformationsReport pdfThreadInformationsReport = new PdfThreadInformationsReport(javaInformations.getThreadInformationsList(), javaInformations.isStackTraceEnabled(), this.pdfDocumentFactory, this.getDocument());
            pdfThreadInformationsReport.writeDeadlocks();
            if (includeDetails) {
                pdfThreadInformationsReport.toPdf();
            }
            eol = "\n";
        }
    }

    private void writeCaches(boolean includeDetails) throws DocumentException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            List<CacheInformations> cacheInformationsList = javaInformations.getCacheInformationsList();
            String msg = PdfCoreReport.getFormattedString("caches_sur", cacheInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount());
            this.addToDocument((Element)new Phrase(eol + msg, this.boldFont));
            if (includeDetails) {
                new PdfCacheInformationsReport(cacheInformationsList, this.getDocument()).toPdf();
            }
            eol = "\n";
        }
    }

    private boolean isCacheEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isCacheEnabled()) continue;
            return true;
        }
        return false;
    }

    private void writeJobs(Counter rangeJobCounter, boolean includeDetails) throws DocumentException, IOException {
        String eol = "";
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            List<JobInformations> jobInformationsList = javaInformations.getJobInformationsList();
            String msg = PdfCoreReport.getFormattedString("jobs_sur", jobInformationsList.size(), javaInformations.getHost(), javaInformations.getCurrentlyExecutingJobCount());
            this.addToDocument((Element)new Phrase(eol + msg, this.boldFont));
            if (includeDetails) {
                new PdfJobInformationsReport(jobInformationsList, rangeJobCounter, this.getDocument()).toPdf();
            }
            eol = "\n";
        }
    }

    private boolean isJobEnabled() {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            if (!javaInformations.isJobEnabled()) continue;
            return true;
        }
        return false;
    }

    private void writeDurationAndOverhead() throws DocumentException {
        long displayDuration = System.currentTimeMillis() - this.start;
        String tmp = "\n\n" + PdfCoreReport.getString("temps_derniere_collecte") + ": " + this.collector.getLastCollectDuration() + ' ' + PdfCoreReport.getString("ms") + '\n' + PdfCoreReport.getString("temps_affichage") + ": " + displayDuration + ' ' + PdfCoreReport.getString("ms") + '\n' + PdfCoreReport.getString("Estimation_overhead_memoire") + ": < " + (this.collector.getEstimatedMemorySize() / 1024L / 1024L + 1L) + ' ' + PdfCoreReport.getString("Mo") + '\n' + PdfCoreReport.getString("Usage_disque") + ": " + (this.collector.getDiskUsage() / 1024L / 1024L + 1L) + ' ' + PdfCoreReport.getString("Mo");
        String string = Parameters.JAVAMELODY_VERSION != null ? tmp + "\n\nJavaMelody " + Parameters.JAVAMELODY_VERSION : tmp;
        this.addToDocument((Element)new Phrase(string, this.cellFont));
    }

    private void addParagraph(String paragraphTitle, String iconName) throws DocumentException, IOException {
        this.addToDocument(this.pdfDocumentFactory.createParagraphElement(paragraphTitle, iconName));
    }
}

