/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.internal.model.MBeansAccessor;
import net.bull.javamelody.internal.model.PID;

public class ThreadInformations
implements Serializable {
    private static final long serialVersionUID = 3604281253550723654L;
    private static final ThreadMXBean THREAD_BEAN = ManagementFactory.getThreadMXBean();
    private static final boolean CPU_TIME_ENABLED = THREAD_BEAN.isThreadCpuTimeSupported() && THREAD_BEAN.isThreadCpuTimeEnabled();
    private static final Method THREAD_ALLOCATED_BYTES_METHOD = ThreadInformations.getThreadAllocatedBytesMethod();
    private final String name;
    private final long id;
    private final int priority;
    private final boolean daemon;
    private final Thread.State state;
    private final long cpuTimeMillis;
    private final long userTimeMillis;
    private final boolean deadlocked;
    private final String globalThreadId;
    private final List<StackTraceElement> stackTrace;

    public ThreadInformations(Thread thread, List<StackTraceElement> stackTrace, long cpuTimeMillis, long userTimeMillis, boolean deadlocked, String hostAddress) {
        assert (thread != null);
        assert (stackTrace == null || stackTrace instanceof Serializable);
        this.name = thread.getName();
        this.id = thread.getId();
        this.priority = thread.getPriority();
        this.daemon = thread.isDaemon();
        this.state = thread.getState();
        this.stackTrace = stackTrace;
        this.cpuTimeMillis = cpuTimeMillis;
        this.userTimeMillis = userTimeMillis;
        this.deadlocked = deadlocked;
        this.globalThreadId = ThreadInformations.buildGlobalThreadId(thread, hostAddress);
    }

    public static long getCurrentThreadCpuTime() {
        return ThreadInformations.getThreadCpuTime(Thread.currentThread().getId());
    }

    static long getThreadCpuTime(long threadId) {
        if (CPU_TIME_ENABLED) {
            return THREAD_BEAN.getThreadCpuTime(threadId);
        }
        return 0L;
    }

    public static long getCurrentThreadAllocatedBytes() {
        return ThreadInformations.getThreadAllocatedBytes(Thread.currentThread().getId());
    }

    static long getThreadAllocatedBytes(long threadId) {
        if (THREAD_ALLOCATED_BYTES_METHOD != null) {
            try {
                return (Long)THREAD_ALLOCATED_BYTES_METHOD.invoke((Object)THREAD_BEAN, threadId);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return MBeansAccessor.getThreadAllocatedBytes(threadId);
    }

    private static Method getThreadAllocatedBytesMethod() {
        try {
            Class<?> clazz = THREAD_BEAN.getClass();
            Method method = clazz.getMethod("getThreadAllocatedBytes", Long.TYPE);
            if (method != null) {
                method.setAccessible(true);
                Long bytes = (Long)method.invoke((Object)THREAD_BEAN, Thread.currentThread().getId());
                if (bytes != -1L) {
                    return method;
                }
            }
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getId() {
        return this.id;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public Thread.State getState() {
        return this.state;
    }

    public List<StackTraceElement> getStackTrace() {
        if (this.stackTrace != null) {
            return Collections.unmodifiableList(this.stackTrace);
        }
        return this.stackTrace;
    }

    public String getExecutedMethod() {
        List<StackTraceElement> trace = this.stackTrace;
        if (trace != null && !trace.isEmpty()) {
            return trace.get(0).toString();
        }
        return "";
    }

    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getUserTimeMillis() {
        return this.userTimeMillis;
    }

    public boolean isDeadlocked() {
        return this.deadlocked;
    }

    public String getGlobalThreadId() {
        return this.globalThreadId;
    }

    private static String buildGlobalThreadId(Thread thread, String hostAddress) {
        return PID.getPID() + '_' + hostAddress + '_' + thread.getId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", name=" + this.getName() + ", daemon=" + this.isDaemon() + ", priority=" + this.getPriority() + ", deadlocked=" + this.isDeadlocked() + ", state=" + (Object)((Object)this.getState()) + ']';
    }
}

