/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import net.bull.javamelody.internal.model.DatabaseInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlDatabaseInformationsReport
extends HtmlAbstractReport {
    private final DatabaseInformations databaseInformations;

    HtmlDatabaseInformationsReport(DatabaseInformations databaseInformations, Writer writer) {
        super(writer);
        assert (databaseInformations != null);
        this.databaseInformations = databaseInformations;
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        String title = HtmlDatabaseInformationsReport.getString("database") + " : " + HtmlDatabaseInformationsReport.getString(this.databaseInformations.getSelectedRequestName());
        this.writeTitle("db.png", title);
        String[][] values = this.databaseInformations.getResult();
        int nbColumns = this.databaseInformations.getNbColumns();
        new TableReport(values, nbColumns, this.getWriter()).toHtml();
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=database&amp;request=" + this.databaseInformations.getSelectedRequestIndex() + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlDatabaseInformationsReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=database&amp;request=" + this.databaseInformations.getSelectedRequestIndex() + "&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<select name='request' onchange=\"location.href='?part=database&amp;request='+options.selectedIndex;\">");
        int index = 0;
        for (String request : this.databaseInformations.getRequestNames()) {
            this.write("<option value='");
            this.write(String.valueOf(index));
            this.write("'");
            if (index == this.databaseInformations.getSelectedRequestIndex()) {
                this.write(" selected='selected'");
            }
            this.write(">");
            this.write(HtmlDatabaseInformationsReport.getString(request));
            this.write("</option>");
            ++index;
        }
        this.writeln("</select>");
        this.writeln("</div>");
    }

    static class TableReport
    extends HtmlAbstractReport {
        private final String[][] values;
        private final int nbColumns;

        TableReport(String[][] values, int nbColumns, Writer writer) {
            super(writer);
            this.values = (String[][])values.clone();
            this.nbColumns = nbColumns;
        }

        @Override
        void toHtml() throws IOException {
            int rowsByColumn;
            if (this.nbColumns > 1) {
                rowsByColumn = (this.values.length - 1) / this.nbColumns + 1;
                this.writeln("<table width='100%' summary=''><tr><td valign='top'>");
            } else {
                rowsByColumn = -1;
            }
            if (this.values.length <= 1) {
                return;
            }
            String[] headerValues = this.values[0];
            HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
            table.beginTable(TableReport.getString("database"));
            this.writeTableHeaders(headerValues);
            int index = 0;
            for (String[] row : this.values) {
                if (index == 0) {
                    ++index;
                    continue;
                }
                table.nextRow();
                this.writeRow(row);
                if (rowsByColumn <= 0 || (++index - 1) % rowsByColumn != 0 || index == this.values.length) continue;
                table.endTable();
                this.writeln("</td><td valign='top'>");
                table = new HtmlAbstractReport.HtmlTable(this);
                table.beginTable(TableReport.getString("database"));
                this.writeTableHeaders(headerValues);
            }
            table.endTable();
            if (this.nbColumns > 1) {
                this.writeln("</td></tr></table>");
            }
        }

        private void writeTableHeaders(String[] headerValues) throws IOException {
            for (String value : headerValues) {
                this.write("<th>");
                this.writeDirectly(value.replace("\n", "<br/>"));
                this.write("</th>");
            }
        }

        private void writeRow(String[] row) throws IOException {
            for (String value : row) {
                if (value == null || value.isEmpty()) {
                    this.write("<td>&nbsp;</td>");
                    continue;
                }
                if (TableReport.isNumber(value)) {
                    this.write("<td align='right' valign='top'>");
                    this.writeDirectly(value);
                } else {
                    this.write("<td valign='top'>");
                    this.writeDirectly(value.replace("\n", "<br/>"));
                }
                this.write("</td>");
            }
        }

        private static boolean isNumber(String text) {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return false;
            }
            return true;
        }
    }
}

