/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.ProcessInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

public class HtmlProcessInformationsReport
extends HtmlAbstractReport {
    private final List<ProcessInformations> processInformationsList;
    private final boolean windows;
    private final DecimalFormat percentFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();

    HtmlProcessInformationsReport(List<ProcessInformations> processInformationsList, Writer writer) {
        super(writer);
        assert (processInformationsList != null);
        this.processInformationsList = processInformationsList;
        this.windows = HtmlProcessInformationsReport.isWindowsProcessList(processInformationsList);
    }

    @Override
    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeTitle("processes.png", HtmlProcessInformationsReport.getString("Processus"));
        this.writeTable();
    }

    void writeTable() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlProcessInformationsReport.getString("Processus"));
        this.write("<th>#Utilisateur#</th>");
        this.write("<th class='sorttable_numeric'>#PID#</th>");
        if (!this.windows) {
            this.write("<th class='sorttable_numeric'>#cpu#</th><th class='sorttable_numeric'>#mem#</th>");
        }
        this.write("<th class='sorttable_numeric'>#vsz#</th>");
        if (!this.windows) {
            this.write("<th class='sorttable_numeric'>#rss#</th><th>#tty#</th>");
            this.write("<th>#stat#</th><th>#start#</th>");
        }
        this.write("<th>#cpuTime#</th><th>#command#</th>");
        for (ProcessInformations processInformations : this.processInformationsList) {
            table.nextRow();
            this.writeProcessInformations(processInformations);
        }
        table.endTable();
        if (!this.windows) {
            this.write("<div align='right'>");
            this.write("<a href='http://en.wikipedia.org/wiki/Ps_(Unix)' target='_blank'>ps command reference</a></div>");
        }
    }

    private void writeProcessInformations(ProcessInformations processInformations) throws IOException {
        this.write("<td>");
        this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getUser()));
        String newColumnRight = "</td><td align='right'>";
        String newColumn = "</td><td>";
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(processInformations.getPid()));
        if (!this.windows) {
            this.write("</td><td align='right'>");
            this.write(this.percentFormat.format(processInformations.getCpuPercentage()));
            this.write("</td><td align='right'>");
            this.write(this.percentFormat.format(processInformations.getMemPercentage()));
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(processInformations.getVsz()));
        if (!this.windows) {
            this.write("</td><td align='right'>");
            this.write(this.integerFormat.format(processInformations.getRss()));
            this.write("</td><td>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getTty()));
            this.write("</td><td>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getStat()));
            this.write("</td><td align='right'>");
            this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getStart()));
        }
        this.write("</td><td align='right'>");
        this.write(HtmlProcessInformationsReport.htmlEncode(processInformations.getCpuTime()));
        this.write("</td><td>");
        this.writeDirectly(HtmlProcessInformationsReport.htmlEncode(processInformations.getCommand()));
        this.write("</td>");
    }

    void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=processes'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlProcessInformationsReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=processes&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }

    public static boolean isWindowsProcessList(List<ProcessInformations> processInformationsList) {
        for (ProcessInformations processInformations : processInformationsList) {
            if (processInformations.getTty() == null) continue;
            return false;
        }
        return true;
    }
}

