/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.sun.management.OperatingSystemMXBean;
import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.DecimalFormat;
import net.bull.javamelody.I18N;

class MemoryInformations
implements Serializable {
    private static final long serialVersionUID = 3281861236369720876L;
    private static final String NEXT = ",\n";
    private static final String MO = " Mo";
    private final long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    private final long maxMemory = Runtime.getRuntime().maxMemory();
    private final long usedPermGen;
    private final long maxPermGen;
    private final long garbageCollectionTimeMillis;
    private final String memoryDetails;

    MemoryInformations() {
        MemoryPoolMXBean permGenMemoryPool = MemoryInformations.getPermGenMemoryPool();
        if (permGenMemoryPool != null) {
            MemoryUsage usage = permGenMemoryPool.getUsage();
            this.usedPermGen = usage.getUsed();
            this.maxPermGen = usage.getMax();
        } else {
            this.usedPermGen = -1L;
            this.maxPermGen = -1L;
        }
        this.garbageCollectionTimeMillis = MemoryInformations.buildGarbageCollectionTimeMillis();
        this.memoryDetails = MemoryInformations.buildMemoryDetails();
    }

    private static MemoryPoolMXBean getPermGenMemoryPool() {
        for (MemoryPoolMXBean memoryPool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!"Perm Gen".equals(memoryPool.getName())) continue;
            return memoryPool;
        }
        return null;
    }

    private static long buildGarbageCollectionTimeMillis() {
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean garbageCollector : ManagementFactory.getGarbageCollectorMXBeans()) {
            garbageCollectionTime += garbageCollector.getCollectionTime();
        }
        return garbageCollectionTime;
    }

    private static String buildMemoryDetails() {
        DecimalFormat integerFormat = I18N.createIntegerFormat();
        String nonHeapMemory = "Non heap memory = " + integerFormat.format(ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed() / 1024L / 1024L) + MO;
        String classLoading = "Loaded classes = " + integerFormat.format(ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
        String gc = "Garbage collection time = " + integerFormat.format(MemoryInformations.buildGarbageCollectionTimeMillis()) + " ms";
        java.lang.management.OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        String osInfo = "";
        if (MemoryInformations.isSunOsMBean(operatingSystem)) {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)operatingSystem;
            osInfo = "Process cpu time = " + integerFormat.format(osBean.getProcessCpuTime() / 1000000L) + " ms,\nCommitted virtual memory = " + integerFormat.format(osBean.getCommittedVirtualMemorySize() / 1024L / 1024L) + MO + ",\nFree physical memory = " + integerFormat.format(osBean.getFreePhysicalMemorySize() / 1024L / 1024L) + MO + ",\nTotal physical memory = " + integerFormat.format(osBean.getTotalPhysicalMemorySize() / 1024L / 1024L) + MO + ",\nFree swap space = " + integerFormat.format(osBean.getFreeSwapSpaceSize() / 1024L / 1024L) + MO + ",\nTotal swap space = " + integerFormat.format(osBean.getTotalSwapSpaceSize() / 1024L / 1024L) + MO;
        }
        return nonHeapMemory + NEXT + classLoading + NEXT + gc + NEXT + osInfo;
    }

    private static boolean isSunOsMBean(java.lang.management.OperatingSystemMXBean operatingSystem) {
        String className = operatingSystem.getClass().getName();
        return "com.sun.management.OperatingSystem".equals(className) || "com.sun.management.UnixOperatingSystem".equals(className);
    }

    long getUsedMemory() {
        return this.usedMemory;
    }

    long getMaxMemory() {
        return this.maxMemory;
    }

    long getUsedPermGen() {
        return this.usedPermGen;
    }

    long getMaxPermGen() {
        return this.maxPermGen;
    }

    long getGarbageCollectionTimeMillis() {
        return this.garbageCollectionTimeMillis;
    }

    String getMemoryDetails() {
        return this.memoryDetails;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[usedMemory=" + this.getUsedMemory() + ", maxMemroy=" + this.getMaxMemory() + ']';
    }
}

