/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CompressionServletResponseWrapper;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.PdfReport;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.TransportFormat;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MonitoringController {
    static final String HTML_CHARSET = "ISO-8859-1";
    static final String HTML_CONTENT_TYPE = "text/html; charset=ISO-8859-1";
    static final String ACTION_PARAMETER = "action";
    static final String PART_PARAMETER = "part";
    static final String PERIOD_PARAMETER = "period";
    static final String SESSION_ID_PARAMETER = "sessionId";
    static final String COLLECTOR_PARAMETER = "collector";
    static final String REQUEST_PARAMETER = "request";
    static final String HEAP_HISTO_PART = "heaphisto";
    static final String PROCESSES_PART = "processes";
    static final String CURRENT_REQUESTS_PART = "currentRequests";
    static final String WEB_XML_PART = "web.xml";
    static final String POM_XML_PART = "pom.xml";
    static final String SESSIONS_PART = "sessions";
    static final String DATABASE_PART = "database";
    static final String GRAPH_PART = "graph";
    private static final String COUNTER_PARAMETER = "counter";
    private static final String GRAPH_PARAMETER = "graph";
    private static final String RESOURCE_PARAMETER = "resource";
    private static final String FORMAT_PARAMETER = "format";
    private static final String WIDTH_PARAMETER = "width";
    private static final String HEIGHT_PARAMETER = "height";
    private final Collector collector;
    private final boolean collectorServer;
    private HeapHistogram heapHistogramIfCollectServer;
    private List<SessionInformations> sessionsInformationsIfCollectServer;
    private String messageForReport;

    MonitoringController(Collector collector, boolean collectorServer) {
        assert (collector != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
    }

    boolean isJavaInformationsNeeded(HttpServletRequest httpRequest) {
        return httpRequest.getParameter(RESOURCE_PARAMETER) == null && httpRequest.getParameter("graph") == null && httpRequest.getParameter(PART_PARAMETER) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeActionIfNeeded(HttpServletRequest httpRequest) throws IOException {
        assert (httpRequest != null);
        String actionParameter = httpRequest.getParameter(ACTION_PARAMETER);
        if (actionParameter != null) {
            try {
                I18N.bindLocale(httpRequest.getLocale());
                Action action = Action.valueOfIgnoreCase(actionParameter);
                if (action != Action.CLEAR_COUNTER) {
                    Action.checkSystemActionsEnabled();
                }
                String counterName = httpRequest.getParameter(COUNTER_PARAMETER);
                String sessionId = httpRequest.getParameter(SESSION_ID_PARAMETER);
                this.messageForReport = action.execute(this.collector, counterName, sessionId);
            }
            finally {
                I18N.unbindLocale();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReport(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList) throws IOException {
        assert (httpRequest != null);
        assert (httpResponse != null);
        assert (javaInformationsList != null);
        String resource = httpRequest.getParameter(RESOURCE_PARAMETER);
        if (resource != null) {
            this.doResource(httpResponse, resource);
            return;
        }
        MonitoringController.noCache(httpResponse);
        try {
            I18N.bindLocale(httpRequest.getLocale());
            Period period = MonitoringController.getPeriod(httpRequest);
            String part = httpRequest.getParameter(PART_PARAMETER);
            String graph = httpRequest.getParameter("graph");
            if (part == null && graph != null) {
                this.doGraph(httpRequest, httpResponse, period, graph);
                return;
            }
            if (WEB_XML_PART.equalsIgnoreCase(part)) {
                this.doWebXml(httpResponse);
                return;
            }
            if (POM_XML_PART.equalsIgnoreCase(part)) {
                this.doPomXml(httpResponse);
                return;
            }
            String format = httpRequest.getParameter(FORMAT_PARAMETER);
            if (format == null || "html".equalsIgnoreCase(format)) {
                this.doCompressedHtml(httpRequest, httpResponse, javaInformationsList, period, part);
            } else if ("pdf".equalsIgnoreCase(format)) {
                this.doPdf(httpRequest, httpResponse, period, javaInformationsList);
            } else {
                TransportFormat transportFormat = TransportFormat.valueOfIgnoreCase(format);
                Serializable serializable = this.createSerializable(httpRequest, javaInformationsList);
                httpResponse.setContentType(transportFormat.getMimeType());
                String fileName = "JavaMelody_" + this.collector.getApplication().replace(' ', '_').replace("/", "") + '_' + I18N.getCurrentDate().replace('/', '_') + '.' + transportFormat.getCode();
                httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
                transportFormat.writeSerializableTo(serializable, (OutputStream)httpResponse.getOutputStream());
                if ("stop".equalsIgnoreCase(httpRequest.getParameter(COLLECTOR_PARAMETER))) {
                    this.collector.stop();
                }
            }
        }
        finally {
            I18N.unbindLocale();
        }
    }

    static void noCache(HttpServletResponse httpResponse) {
        httpResponse.addHeader("Cache-Control", "no-cache");
        httpResponse.addHeader("Pragma", "no-cache");
        httpResponse.addHeader("Expires", "-1");
    }

    static Period getPeriod(HttpServletRequest req) {
        Period period = req.getParameter(PERIOD_PARAMETER) == null ? Period.JOUR : Period.valueOfIgnoreCase(req.getParameter(PERIOD_PARAMETER));
        return period;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompressedHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, Period period, String part) throws IOException {
        if (MonitoringController.isCompressionSupported(httpRequest)) {
            CompressionServletResponseWrapper wrappedResponse = new CompressionServletResponseWrapper(httpResponse, 4096);
            try {
                this.doHtml(httpRequest, (HttpServletResponse)wrappedResponse, javaInformationsList, period, part);
            }
            finally {
                wrappedResponse.finishResponse();
            }
        } else {
            this.doHtml(httpRequest, httpResponse, javaInformationsList, period, part);
        }
    }

    private Serializable createSerializable(HttpServletRequest httpRequest, List<JavaInformations> javaInformationsList) {
        String part = httpRequest.getParameter(PART_PARAMETER);
        try {
            if (HEAP_HISTO_PART.equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                return VirtualMachine.createHeapHistogram();
            }
            if (SESSIONS_PART.equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                String sessionId = httpRequest.getParameter(SESSION_ID_PARAMETER);
                if (sessionId == null) {
                    List<SessionInformations> sessionsInformations = SessionListener.getAllSessionsInformations();
                    return (Serializable)((Object)sessionsInformations);
                }
                SessionInformations sessionInformations = SessionListener.getSessionInformationsBySessionId(sessionId);
                return sessionInformations;
            }
            if (PROCESSES_PART.equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                return (Serializable)((Object)ProcessInformations.buildProcessInformations());
            }
            if (DATABASE_PART.equalsIgnoreCase(part)) {
                Action.checkSystemActionsEnabled();
                int requestIndex = Integer.parseInt(httpRequest.getParameter(REQUEST_PARAMETER));
                return new DatabaseInformations(requestIndex);
            }
        }
        catch (Exception e) {
            return e;
        }
        List<Counter> counters = this.collector.getCounters();
        ArrayList<Serializable> serialized = new ArrayList<Serializable>(counters.size() + javaInformationsList.size());
        for (Counter counter : counters) {
            serialized.add(counter.clone());
        }
        for (JavaInformations javaInformations : javaInformationsList) {
            serialized.add(javaInformations);
        }
        return serialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHtml(HttpServletRequest httpRequest, HttpServletResponse httpResponse, List<JavaInformations> javaInformationsList, Period period, String part) throws IOException {
        if (!this.collectorServer && (part == null || CURRENT_REQUESTS_PART.equalsIgnoreCase(part) || "graph".equalsIgnoreCase(part))) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType(HTML_CONTENT_TYPE);
        BufferedWriter writer = new BufferedWriter(httpResponse.getWriter());
        try {
            HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, javaInformationsList, period, writer);
            if (part == null) {
                htmlReport.toHtml(this.messageForReport);
            } else {
                this.doHtmlPart(httpRequest, part, htmlReport);
            }
        }
        finally {
            writer.close();
        }
    }

    private void doHtmlPart(HttpServletRequest httpRequest, String part, HtmlReport htmlReport) throws IOException {
        if ("graph".equalsIgnoreCase(part)) {
            String graphName = httpRequest.getParameter("graph");
            htmlReport.writeRequestAndGraphDetail(graphName);
        } else if (SESSIONS_PART.equalsIgnoreCase(part)) {
            this.doSessions(httpRequest, htmlReport);
        } else if (!this.collectorServer && CURRENT_REQUESTS_PART.equalsIgnoreCase(part)) {
            this.doCurrentRequests(htmlReport);
        } else if (HEAP_HISTO_PART.equalsIgnoreCase(part)) {
            this.doHeapHisto(htmlReport);
        } else if (PROCESSES_PART.equalsIgnoreCase(part)) {
            this.doProcesses(htmlReport);
        } else if (DATABASE_PART.equalsIgnoreCase(part)) {
            int requestIndex = httpRequest.getParameter(REQUEST_PARAMETER) != null ? Integer.parseInt(httpRequest.getParameter(REQUEST_PARAMETER)) : 0;
            this.doDatabase(htmlReport, requestIndex);
        } else {
            throw new IllegalArgumentException(part);
        }
    }

    private void doSessions(HttpServletRequest httpRequest, HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        List<SessionInformations> sessionsInformations = this.sessionsInformationsIfCollectServer;
        assert (sessionsInformations == null && !this.collectorServer || sessionsInformations != null && this.collectorServer);
        String sessionId = httpRequest.getParameter(SESSION_ID_PARAMETER);
        if (sessionId == null) {
            if (sessionsInformations == null) {
                sessionsInformations = SessionListener.getAllSessionsInformations();
            }
            htmlReport.writeSessions(sessionsInformations, this.messageForReport, SESSIONS_PART);
        } else {
            SessionInformations sessionInformation = sessionsInformations == null ? SessionListener.getSessionInformationsBySessionId(sessionId) : sessionsInformations.get(0);
            htmlReport.writeSessionDetail(sessionId, sessionInformation);
        }
    }

    private void doCurrentRequests(HtmlReport htmlReport) throws IOException {
        assert (!this.collectorServer);
        htmlReport.writeCurrentRequests(JavaInformations.buildThreadInformationsList(), true, new HashMap<String, HtmlCounterReport>());
    }

    private void doHeapHisto(HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        HeapHistogram heapHistogram = this.heapHistogramIfCollectServer;
        assert (heapHistogram == null && !this.collectorServer || heapHistogram != null && this.collectorServer);
        if (heapHistogram == null) {
            try {
                heapHistogram = VirtualMachine.createHeapHistogram();
            }
            catch (Exception e) {
                Collector.printStackTrace(e);
                htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
                return;
            }
        }
        htmlReport.writeHeapHistogram(heapHistogram, this.messageForReport, HEAP_HISTO_PART);
    }

    private void doProcesses(HtmlReport htmlReport) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeProcesses(ProcessInformations.buildProcessInformations());
        }
        catch (Exception e) {
            Collector.printStackTrace(e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    private void doDatabase(HtmlReport htmlReport, int requestIndex) throws IOException {
        Action.checkSystemActionsEnabled();
        try {
            htmlReport.writeDatabase(new DatabaseInformations(requestIndex));
        }
        catch (Exception e) {
            Collector.printStackTrace(e);
            htmlReport.writeMessageIfNotNull(String.valueOf(e.getMessage()), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHtmlToLastShutdownFile() {
        try {
            File dir = Parameters.getStorageDirectory(this.collector.getApplication());
            if (!dir.mkdirs() && !dir.exists()) {
                throw new IOException("JavaMelody directory can't be created: " + dir.getPath());
            }
            File lastShutdownFile = new File(dir, "last_shutdown.html");
            BufferedWriter writer = new BufferedWriter(new FileWriter(lastShutdownFile));
            try {
                JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), true);
                HtmlReport htmlReport = new HtmlReport(this.collector, this.collectorServer, Collections.singletonList(javaInformations), Period.JOUR, writer);
                htmlReport.toHtml(null);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPdf(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Period period, List<JavaInformations> javaInformationsList) throws IOException {
        if (!this.collectorServer) {
            this.collector.collectLocalContextWithoutErrors();
        }
        httpResponse.setContentType("application/pdf");
        httpResponse.addHeader("Content-Disposition", MonitoringController.encodeFileNameToContentDisposition(httpRequest, PdfReport.getFileName(this.collector.getApplication())));
        try {
            PdfReport pdfReport = new PdfReport(this.collector, this.collectorServer, javaInformationsList, period, (OutputStream)httpResponse.getOutputStream());
            pdfReport.toPdf();
        }
        finally {
            httpResponse.getOutputStream().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResource(HttpServletResponse httpResponse, String resource) throws IOException {
        httpResponse.addHeader("Cache-Control", "max-age=3600");
        ServletOutputStream out = httpResponse.getOutputStream();
        String localResource = Parameters.getResourcePath(resource.replace("..", ""));
        httpResponse.setContentType(Parameters.getServletContext().getMimeType(localResource));
        BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(localResource));
        try {
            TransportFormat.pump(in, (OutputStream)out);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private void doGraph(HttpServletRequest httpRequest, HttpServletResponse httpResponse, Period period, String graphName) throws IOException {
        int width = Math.min(Integer.parseInt(httpRequest.getParameter(WIDTH_PARAMETER)), 1600);
        int height = Math.min(Integer.parseInt(httpRequest.getParameter(HEIGHT_PARAMETER)), 1600);
        JRobin jrobin = this.collector.getJRobin(graphName);
        if (jrobin != null) {
            byte[] img = jrobin.graph(period, width, height);
            httpResponse.setContentType("image/png");
            httpResponse.setContentLength(img.length);
            String fileName = graphName + ".png";
            httpResponse.addHeader("Content-Disposition", "inline;filename=" + fileName);
            httpResponse.getOutputStream().write(img);
            httpResponse.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWebXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=web.xml");
        InputStream in = MonitoringController.getWebXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPomXml(HttpServletResponse httpResponse) throws IOException {
        Action.checkSystemActionsEnabled();
        ServletOutputStream out = httpResponse.getOutputStream();
        httpResponse.setContentType(Parameters.getServletContext().getMimeType("/WEB-INF/web.xml"));
        httpResponse.addHeader("Content-Disposition", "inline;filename=pom.xml");
        InputStream in = MonitoringController.getPomXmlAsStream();
        if (in != null) {
            try {
                TransportFormat.pump(in, (OutputStream)out);
            }
            finally {
                in.close();
            }
        }
    }

    private static InputStream getWebXmlAsStream() {
        InputStream webXml = Parameters.getServletContext().getResourceAsStream("/WEB-INF/web.xml");
        if (webXml == null) {
            return null;
        }
        return new BufferedInputStream(webXml);
    }

    private static InputStream getPomXmlAsStream() {
        ServletContext servletContext = Parameters.getServletContext();
        Set mavenDir = servletContext.getResourcePaths("/META-INF/maven/");
        if (mavenDir == null || mavenDir.isEmpty()) {
            return null;
        }
        Set groupDir = servletContext.getResourcePaths((String)mavenDir.iterator().next());
        if (groupDir == null || groupDir.isEmpty()) {
            return null;
        }
        InputStream pomXml = servletContext.getResourceAsStream(groupDir.iterator().next() + POM_XML_PART);
        if (pomXml == null) {
            return null;
        }
        return new BufferedInputStream(pomXml);
    }

    private static String encodeFileNameToContentDisposition(HttpServletRequest httpRequest, String fileName) {
        assert (fileName != null);
        String userAgent = httpRequest.getHeader("user-agent");
        if (userAgent != null && userAgent.contains("MSIE")) {
            return "attachment;filename=" + fileName;
        }
        return MonitoringController.encodeFileNameToStandardContentDisposition(fileName);
    }

    private static String encodeFileNameToStandardContentDisposition(String fileName) {
        int length = fileName.length();
        StringBuilder sb = new StringBuilder(length + length / 4);
        sb.append("attachment;filename*=\"");
        for (int i = 0; i < length; ++i) {
            char c = fileName.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') {
                sb.append(c);
                continue;
            }
            sb.append('%');
            if (c < '\u0010') {
                sb.append('0');
            }
            sb.append(Integer.toHexString(c));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static boolean isCompressionSupported(HttpServletRequest httpRequest) {
        boolean supportCompression = false;
        ArrayList<String> acceptEncodings = Collections.list(httpRequest.getHeaders("Accept-Encoding"));
        for (String name : acceptEncodings) {
            if (!name.contains("gzip")) continue;
            supportCompression = true;
            break;
        }
        return supportCompression;
    }

    void setHeapHistogramIfCollectServer(HeapHistogram heapHistogram) {
        assert (this.collectorServer);
        this.heapHistogramIfCollectServer = heapHistogram;
    }

    void setSessionsInformations(List<SessionInformations> sessionsInformations) {
        assert (this.collectorServer);
        this.sessionsInformationsIfCollectServer = sessionsInformations;
    }

    static {
        boolean webXmlExists = false;
        boolean pomXmlExists = false;
        try {
            InputStream pomXmlAsStream;
            InputStream webXmlAsStream = MonitoringController.getWebXmlAsStream();
            if (webXmlAsStream != null) {
                webXmlAsStream.close();
                webXmlExists = true;
            }
            if ((pomXmlAsStream = MonitoringController.getPomXmlAsStream()) != null) {
                pomXmlAsStream.close();
                pomXmlExists = true;
            }
        }
        catch (IOException e) {
            Collector.printStackTrace(e);
        }
        JavaInformations.setWebXmlExistsAndPomXmlExists(webXmlExists, pomXmlExists);
    }
}

