/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectorServer {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private final Map<String, Collector> collectorsByApplication = new LinkedHashMap<String, Collector>();
    private final Map<String, List<JavaInformations>> javaInformationsByApplication = new LinkedHashMap<String, List<JavaInformations>>();
    private final Timer timer = new Timer("collector", true);

    CollectorServer() throws IOException {
        Map<String, List<URL>> urlsByApplication = Parameters.getCollectorUrlsByApplications();
        LOGGER.info((Object)("applications monitor\u00e9es : " + urlsByApplication.keySet()));
        LOGGER.info((Object)("urls des applications monitor\u00e9es : " + urlsByApplication));
        int periodMillis = Parameters.getResolutionSeconds() * 1000;
        LOGGER.info((Object)("r\u00e9solution du monitoring en secondes : " + Parameters.getResolutionSeconds()));
        TimerTask collectTask = new TimerTask(){

            public void run() {
                CollectorServer.this.collectWithoutErrors();
            }
        };
        this.timer.schedule(collectTask, 100L, (long)periodMillis);
    }

    void collectWithoutErrors() {
        LinkedHashMap<String, List<URL>> clone;
        try {
            clone = new LinkedHashMap<String, List<URL>>(Parameters.getCollectorUrlsByApplications());
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        for (Map.Entry entry : clone.entrySet()) {
            String application = (String)entry.getKey();
            List urls = (List)entry.getValue();
            try {
                this.collectForApplication(application, urls);
                assert (this.collectorsByApplication.size() == this.javaInformationsByApplication.size());
            }
            catch (Throwable e) {
                LOGGER.warn((Object)e.getMessage(), e);
            }
        }
    }

    void collectForApplication(String application, List<URL> urls) throws IOException, ClassNotFoundException {
        LOGGER.info((Object)("collecte pour l'application " + application + " sur " + urls));
        assert (application != null);
        assert (urls != null);
        long start = System.currentTimeMillis();
        ArrayList<JavaInformations> javaInformationsList = new ArrayList<JavaInformations>();
        Collector collector = this.collectorsByApplication.get(application);
        for (URL url : urls) {
            List serialized = (List)new LabradorRetriever(url).call();
            ArrayList<Counter> counters = new ArrayList<Counter>();
            for (Serializable serializable : serialized) {
                if (serializable instanceof Counter) {
                    Counter counter = (Counter)serializable;
                    counter.setApplication(application);
                    counters.add(counter);
                    continue;
                }
                if (!(serializable instanceof JavaInformations)) continue;
                JavaInformations newJavaInformations = (JavaInformations)serializable;
                javaInformationsList.add(newJavaInformations);
            }
            if (collector == null) {
                collector = this.createCollector(application, counters);
                this.collectorsByApplication.put(application, collector);
                continue;
            }
            this.addRequestsAndErrors(collector, counters);
        }
        this.javaInformationsByApplication.put(application, javaInformationsList);
        collector.collectWithoutErrors(javaInformationsList);
        LOGGER.info((Object)("collecte pour l'application " + application + " effectu\u00e9e en " + (System.currentTimeMillis() - start) + "ms"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("counters " + application + " : " + collector.getCounters()));
            LOGGER.debug((Object)("javaInformations " + application + " : " + javaInformationsList));
        }
    }

    private void addRequestsAndErrors(Collector collector, List<Counter> counters) {
        block0: for (Counter newCounter : counters) {
            for (Counter counter : collector.getCounters()) {
                if (!counter.getName().equals(newCounter.getName())) continue;
                counter.addRequestsAndErrors(newCounter);
                continue block0;
            }
        }
    }

    private Collector createCollector(String application, List<Counter> counters) {
        Collector collector = new Collector(application, counters, this.timer);
        if (Parameters.getParameter(Parameter.MAIL_SESSION) != null && Parameters.getParameter(Parameter.ADMIN_EMAILS) != null) {
            this.scheduleReportMailForCollectorServer(application);
            LOGGER.info((Object)("Rapport hebdomadaire programm\u00e9 pour l'application " + application + " \u00e0 destination de " + Parameters.getParameter(Parameter.ADMIN_EMAILS)));
        }
        return collector;
    }

    void addCollectorApplication(String application, List<URL> urls) throws IOException, ClassNotFoundException {
        this.collectForApplication(application, urls);
        Parameters.addCollectorApplication(application, urls);
    }

    void removeCollectorApplication(String application) throws IOException {
        Parameters.removeCollectorApplication(application);
        this.collectorsByApplication.remove(application);
        this.javaInformationsByApplication.remove(application);
    }

    Collector getCollectorByApplication(String application) {
        return this.collectorsByApplication.get(application);
    }

    List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.javaInformationsByApplication.get(application);
    }

    String getFirstApplication() {
        if (this.collectorsByApplication.isEmpty()) {
            return null;
        }
        return this.collectorsByApplication.keySet().iterator().next();
    }

    boolean isApplicationDataAvailable(String application) {
        assert (application != null);
        return this.collectorsByApplication.containsKey(application) && this.javaInformationsByApplication.containsKey(application);
    }

    void scheduleReportMailForCollectorServer(final String application) {
        assert (application != null);
        final MailReport mailReport = new MailReport();
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    Collector collector = CollectorServer.this.getCollectorByApplication(application);
                    List<JavaInformations> javaInformationsList = CollectorServer.this.getJavaInformationsByApplication(application);
                    mailReport.sendReportMail(collector, true, javaInformationsList);
                }
                catch (Throwable t) {
                    Collector.printStackTrace(t);
                }
                CollectorServer.this.scheduleReportMailForCollectorServer(application);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate());
    }

    void stop() {
        for (Collector collector : this.collectorsByApplication.values()) {
            collector.stop();
        }
        this.timer.cancel();
        this.collectorsByApplication.clear();
        this.javaInformationsByApplication.clear();
    }
}

