/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Timer;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdNioBackend;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

final class JRobin {
    static final int SMALL_HEIGHT = 50;
    private static final Color LIGHT_RED = Color.RED.brighter().brighter();
    private static final Paint SMALL_GRADIENT = new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, 50.0f, Color.GREEN, false);
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private final RrdDbPool rrdPool = RrdDbPool.getInstance();
    private final String application;
    private final String name;
    private final String rrdFileName;
    private final String requestName;

    private JRobin(String application, String name, File rrdFile, int step, String requestName) throws RrdException, IOException {
        assert (application != null);
        assert (name != null);
        assert (rrdFile != null);
        assert (step > 0);
        this.application = application;
        this.name = name;
        this.rrdFileName = rrdFile.getPath();
        this.requestName = requestName;
        this.init(step);
    }

    static void stop() throws IOException {
        try {
            Field field = RrdNioBackend.class.getDeclaredField("fileSyncTimer");
            JRobin.setFieldAccessible(field);
            Timer fileSyncTimer = (Timer)field.get(null);
            fileSyncTimer.cancel();
        }
        catch (NoSuchFieldException e) {
            throw JRobin.createIOException(e);
        }
        catch (IllegalAccessException e) {
            throw JRobin.createIOException(e);
        }
    }

    private static void setFieldAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    static JRobin createInstance(String application, String name, String requestName) throws IOException {
        File dir = Parameters.getStorageDirectory(application);
        File rrdFile = new File(dir, name + ".rrd");
        int step = Parameters.getResolutionSeconds();
        try {
            return new JRobin(application, name, rrdFile, step, requestName);
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private void init(int step) throws IOException, RrdException {
        File rrdFile = new File(this.rrdFileName);
        File rrdDirectory = rrdFile.getParentFile();
        if (!rrdDirectory.mkdirs() && !rrdDirectory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + rrdDirectory.getPath());
        }
        if (!rrdFile.exists()) {
            RrdDef rrdDef = new RrdDef(this.rrdFileName, (long)step);
            rrdDef.setStartTime(Util.getTime() - (long)step);
            String dsType = "GAUGE";
            int heartbeat = step * 2;
            rrdDef.addDatasource(this.getDataSourceName(), "GAUGE", (long)heartbeat, 0.0, Double.NaN);
            String average = "AVERAGE";
            String max = "MAX";
            rrdDef.addArchive("AVERAGE", 0.25, 1, 86400 / step);
            rrdDef.addArchive("MAX", 0.25, 1, 86400 / step);
            rrdDef.addArchive("AVERAGE", 0.25, 3600 / step, 168);
            rrdDef.addArchive("MAX", 0.25, 3600 / step, 168);
            rrdDef.addArchive("AVERAGE", 0.25, 21600 / step, 124);
            rrdDef.addArchive("MAX", 0.25, 21600 / step, 124);
            rrdDef.addArchive("AVERAGE", 0.25, 172800 / step, 360);
            rrdDef.addArchive("MAX", 0.25, 172800 / step, 360);
            RrdDb rrdDb = this.rrdPool.requestRrdDb(rrdDef);
            this.rrdPool.release(rrdDb);
        }
    }

    byte[] graph(Period period, int width, int height) throws IOException {
        try {
            RrdGraphDef graphDef = new RrdGraphDef();
            this.initGraphSource(graphDef, height);
            this.initGraphPeriodAndSize(period, width, height, graphDef);
            graphDef.setImageFormat("png");
            graphDef.setFilename("-");
            graphDef.setPoolUsed(true);
            return new RrdGraph(graphDef).getRrdGraphInfo().getBytes();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private void initGraphPeriodAndSize(Period period, int width, int height, RrdGraphDef graphDef) {
        long endTime = Util.getTime();
        long startTime = endTime - (long)period.getDurationSeconds();
        String titleStart = this.getLabel() + " - " + period.getLabel();
        String titleEnd = width > 400 ? " - " + I18N.getCurrentDate() + " sur " + this.getApplication() : "";
        graphDef.setStartTime(startTime);
        graphDef.setEndTime(endTime);
        graphDef.setTitle(titleStart + titleEnd);
        graphDef.setWidth(width);
        graphDef.setHeight(height);
        if (width <= 100) {
            graphDef.setNoLegend(true);
            graphDef.setUnitsLength(0);
            graphDef.setShowSignature(false);
            graphDef.setTitle(null);
        }
    }

    private void initGraphSource(RrdGraphDef graphDef, int height) {
        String average = "average";
        String max = "max";
        String dataSourceName = this.getDataSourceName();
        graphDef.datasource("average", this.rrdFileName, dataSourceName, "AVERAGE");
        graphDef.datasource("max", this.rrdFileName, dataSourceName, "MAX");
        graphDef.setMinValue(0.0);
        String moyenneLabel = I18N.getString("Moyenne");
        String maximumLabel = I18N.getString("Maximum");
        graphDef.area("average", JRobin.getPaint(height), moyenneLabel);
        graphDef.line("max", (Paint)Color.BLUE, maximumLabel);
        graphDef.gprint("average", "AVERAGE", moyenneLabel + ": %9.0f %S\\r");
        graphDef.gprint("max", "MAX", maximumLabel + ": %9.0f %S\\r");
    }

    private static Paint getPaint(int height) {
        if (height == 50) {
            return SMALL_GRADIENT;
        }
        return new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, height, Color.GREEN, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValue(double value) throws IOException {
        try {
            RrdDb rrdDb = this.rrdPool.requestRrdDb(this.rrdFileName);
            try {
                Sample sample = rrdDb.createSample();
                if (sample.getTime() > rrdDb.getLastUpdateTime()) {
                    sample.setValue(this.getDataSourceName(), value);
                    sample.update();
                }
            }
            finally {
                this.rrdPool.release(rrdDb);
            }
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    boolean deleteFile() {
        return new File(this.rrdFileName).delete();
    }

    private String getApplication() {
        return this.application;
    }

    String getName() {
        return this.name;
    }

    private String getDataSourceName() {
        return this.name.substring(0, Math.min(20, this.name.length()));
    }

    String getLabel() {
        String request = this.getRequestName();
        if (request == null) {
            return I18N.getString(this.getName());
        }
        String shortRequestName = request.substring(0, Math.min(30, request.length()));
        if (this.getName().startsWith("error")) {
            return I18N.getString("Erreurs_par_minute_pour") + ' ' + shortRequestName;
        }
        return I18N.getString("Temps_moyens_de") + ' ' + shortRequestName;
    }

    String getRequestName() {
        return this.requestName;
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }
}

