/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MonitoringProxy
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = 1882880665014391301L;
    private static final Counter SERVICES_COUNTER = new Counter("services", "beans.png", JdbcDriver.SINGLETON.getJdbcWrapper().getSqlCounter());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    private final Object facade;

    private MonitoringProxy(Object facade) {
        this.facade = facade;
    }

    public static <T> T createProxy(T facade) {
        return JdbcWrapper.createProxy(facade, new MonitoringProxy(facade));
    }

    static Counter getServicesCounter() {
        return SERVICES_COUNTER;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (DISABLED || !SERVICES_COUNTER.isDisplayed()) {
            return method.invoke(this.facade, args);
        }
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        String requestName = method.getDeclaringClass().getSimpleName() + '.' + method.getName();
        boolean systemError = false;
        try {
            SERVICES_COUNTER.bindContext(requestName, requestName, null, startCpuTime);
            Object object = method.invoke(this.facade, args);
            return object;
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            long duration = Math.max(System.currentTimeMillis() - start, 0L);
            long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
            SERVICES_COUNTER.addRequest(requestName, duration, cpuUsedMillis, systemError, -1);
        }
    }
}

