/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.SessionInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

public class HtmlSessionInformationsReport
extends HtmlAbstractReport {
    private static final String[] OS = new String[]{"linux", "windows", "mac", "solaris", "hp", "ibm", "android"};
    private static final String[] BROWSERS = new String[]{"chrome", "crios", "edge", "edg", "firefox", "msie", "opera", "safari"};
    private static final String A_HREF_PART_SESSIONS = "<a href='?part=sessions";
    private final List<SessionInformations> sessionsInformations;
    private final HttpSession currentSession;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final DateFormat expiryFormat = I18N.createDateAndTimeFormat();

    HtmlSessionInformationsReport(List<SessionInformations> sessionsInformations, Writer writer) {
        super(writer);
        this.sessionsInformations = sessionsInformations;
        this.currentSession = SessionListener.getCurrentSession();
    }

    @Override
    void toHtml() throws IOException {
        this.writeBackAndRefreshLinks();
        this.writeln("<br/>");
        assert (this.sessionsInformations != null);
        if (this.sessionsInformations.isEmpty()) {
            this.writeln("#Aucune_session#");
            return;
        }
        this.writeTitle("system-users.png", HtmlSessionInformationsReport.getString("Sessions"));
        long totalSerializedSize = 0L;
        int nbSerializableSessions = 0;
        for (SessionInformations sessionInformations : this.sessionsInformations) {
            int size = sessionInformations.getSerializedSize();
            if (size < 0) continue;
            totalSerializedSize += (long)size;
            ++nbSerializableSessions;
        }
        long meanSerializedSize = nbSerializableSessions > 0 ? totalSerializedSize / (long)nbSerializableSessions : -1L;
        if (this.sessionsInformations.size() > 20) {
            this.writeSessionsSizes(this.sessionsInformations.size(), meanSerializedSize);
            this.writeln("<br/>");
        }
        this.writeSessions(this.sessionsInformations);
        this.writeln("<br/>");
        this.writeSessionsSizes(this.sessionsInformations.size(), meanSerializedSize);
    }

    private void writeSessions(List<SessionInformations> sessions) throws IOException {
        boolean displayUser = false;
        for (SessionInformations sessionInformations : sessions) {
            if (sessionInformations.getRemoteUser() == null) continue;
            displayUser = true;
            break;
        }
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlSessionInformationsReport.getString("Sessions"));
        this.write("<th>#Session_id#</th><th class='sorttable_numeric'>#Dernier_acces#</th>");
        this.write("<th class='sorttable_numeric'>#Age#</th><th class='sorttable_date'>#Expiration#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_attributs#</th><th>#Serialisable#</th><th>#Taille_serialisee#</th>");
        this.write("<th class='sorttable_numeric'>#Adresse_IP#</th><th>#Pays#</th><th>#Navigateur#</th><th>#OS#</th>");
        if (displayUser) {
            this.write("<th>#Utilisateur#</th>");
        }
        this.write("<th class='noPrint'>#Invalider#</th>");
        for (SessionInformations session : sessions) {
            table.nextRow();
            this.writeSession(session, displayUser);
        }
        table.endTable();
    }

    private void writeSessionsSizes(int sessionsInfoSize, long meanSerializedSize) throws IOException {
        this.writeln("<div align='right'>" + HtmlSessionInformationsReport.getFormattedString("nb_sessions", sessionsInfoSize) + "<br/>" + HtmlSessionInformationsReport.getFormattedString("taille_moyenne_sessions", meanSerializedSize) + "</div>");
    }

    private void writeBackAndRefreshLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'>");
        this.writeln("<img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlSessionInformationsReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=sessions&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions&amp;action=invalidate_sessions" + HtmlSessionInformationsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlSessionInformationsReport.getStringForJavascript("confirm_invalidate_sessions") + "');\">");
        this.writeln("<img width='16' height='16' src='?resource=user-trash.png' alt='#invalidate_sessions#' title='#invalidate_sessions#' /> #invalidate_sessions#</a>");
        this.writeln("</div>");
    }

    private void writeBackAndRefreshLinksForSession(String sessionId) throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions&amp;sessionId=" + HtmlSessionInformationsReport.urlEncode(sessionId) + "'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private void writeSession(SessionInformations session, boolean displayUser) throws IOException {
        String nextColumnAlignRight = "</td><td align='right'>";
        String nextColumnAlignCenter = "</td><td align='center'>";
        this.write("<td><a href='?part=sessions&amp;sessionId=");
        this.write(HtmlSessionInformationsReport.urlEncode(session.getId()));
        this.write("'>");
        this.write(HtmlSessionInformationsReport.htmlEncodeButNotSpace(session.getId()));
        this.write("</a>");
        if (this.currentSession != null && session.getId().equals(this.currentSession.getId())) {
            this.write("<img src='?resource=bullets/blue.png' alt='#Votre_session#' title='#Votre_session#'/>");
        }
        this.write("</td><td align='right'>");
        this.write(this.durationFormat.format(session.getLastAccess()));
        this.write("</td><td align='right'>");
        this.write(this.durationFormat.format(session.getAge()));
        this.write("</td><td align='right'>");
        this.write(this.expiryFormat.format(session.getExpirationDate()));
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(session.getAttributeCount()));
        this.write("</td><td align='center'>");
        if (session.isSerializable()) {
            this.write("#oui#");
        } else {
            this.write("<span class='severe'>#non#</span>");
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(session.getSerializedSize()));
        String nextColumn = "</td><td>";
        this.write("</td><td>");
        String remoteAddr = session.getRemoteAddr();
        if (remoteAddr == null) {
            this.write("&nbsp;");
        } else {
            this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(remoteAddr));
        }
        this.write("</td><td align='center'>");
        this.writeCountry(session);
        this.write("</td><td align='center'>");
        this.writeBrowserAndOs(session);
        if (displayUser) {
            this.write("</td><td>");
            String remoteUser = session.getRemoteUser();
            if (remoteUser == null) {
                this.write("&nbsp;");
            } else {
                this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(remoteUser));
            }
        }
        this.write("</td><td align='center' class='noPrint'>");
        this.writeInvalidateSessionLink(session);
        this.write("</td>");
    }

    private void writeCountry(SessionInformations session) throws IOException {
        String country = session.getCountry();
        if (country == null) {
            this.write("&nbsp;");
        } else {
            String fileName = "flags/" + country + ".gif";
            if (this.getClass().getResource(Parameters.getResourcePath(fileName)) == null) {
                this.write(HtmlSessionInformationsReport.htmlEncodeButNotSpace(country));
            } else {
                this.write("<img src='?resource=");
                this.write(HtmlSessionInformationsReport.urlEncode(fileName));
                this.write("' alt='");
                this.write(HtmlSessionInformationsReport.urlEncode(country));
                this.write("' title='");
                this.write(HtmlSessionInformationsReport.urlEncode(session.getCountryDisplay()));
                this.write("' />");
            }
        }
    }

    private void writeBrowserAndOs(SessionInformations session) throws IOException {
        String browser = session.getBrowser();
        if (browser == null) {
            this.write("&nbsp;");
        } else {
            String browserIconName = HtmlSessionInformationsReport.getBrowserIconName(browser);
            if (browserIconName != null) {
                String browserEncoded = HtmlSessionInformationsReport.htmlEncode(browser);
                this.writeDirectly("<img src='?resource=browsers/" + browserIconName + "' alt='" + browserEncoded + "' title='" + browserEncoded + "'/>");
            }
        }
        this.write("</td><td align='center'>");
        String os = session.getOs();
        if (os == null) {
            this.write("&nbsp;");
        } else {
            String osIconName = HtmlSessionInformationsReport.getOSIconName(os);
            if (osIconName != null) {
                String osEncoded = HtmlSessionInformationsReport.htmlEncode(os);
                this.writeDirectly("<img src='?resource=servers/" + osIconName + "' alt='" + osEncoded + "' title='" + osEncoded + "' />");
            }
        }
    }

    public static String getOSIconName(String os) {
        String tmp = os.toLowerCase(Locale.ENGLISH);
        for (String anOS : OS) {
            if (!tmp.contains(anOS)) continue;
            return anOS + ".png";
        }
        return null;
    }

    public static String getBrowserIconName(String browser) {
        String tmp = browser.toLowerCase(Locale.ENGLISH);
        for (String aBrowser : BROWSERS) {
            if (!tmp.contains(aBrowser)) continue;
            return aBrowser + ".png";
        }
        return null;
    }

    private void writeInvalidateSessionLink(SessionInformations session) throws IOException {
        this.write(A_HREF_PART_SESSIONS);
        this.write("&amp;action=invalidate_session&amp;sessionId=");
        this.write(HtmlSessionInformationsReport.urlEncode(session.getId()));
        this.write(HtmlSessionInformationsReport.getCsrfTokenUrlPart());
        this.write("' onclick=\"javascript:return confirm('" + HtmlSessionInformationsReport.getStringForJavascript("confirm_invalidate_session") + "');\">");
        this.write("<img width='16' height='16' src='?resource=user-trash.png' alt='#invalidate_session#' title='#invalidate_session#' />");
        this.write("</a>");
    }

    void writeSessionDetails(String sessionId, SessionInformations sessionInformations) throws IOException {
        this.writeBackAndRefreshLinksForSession(sessionId);
        this.writeln("<br/>");
        if (sessionInformations == null) {
            this.writeln(HtmlSessionInformationsReport.getFormattedString("session_invalidee", HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionId)));
            return;
        }
        this.writeTitle("system-users.png", HtmlSessionInformationsReport.getFormattedString("Details_session", HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionId)));
        this.writeSessions(Collections.singletonList(sessionInformations));
        this.writeln("<br/><b>#Attributs#</b>");
        this.writeSessionAttributes(sessionInformations);
    }

    private void writeSessionAttributes(SessionInformations sessionInformations) throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlSessionInformationsReport.getString("Attributs"));
        this.write("<th>#Nom#</th><th>Type</th><th>#Serialisable#</th><th>#Taille_serialisee#</th><th>#Contenu#</th>");
        for (SessionInformations.SessionAttribute sessionAttribute : sessionInformations.getAttributes()) {
            table.nextRow();
            this.writeAttribute(sessionAttribute);
        }
        table.endTable();
    }

    private void writeAttribute(SessionInformations.SessionAttribute sessionAttribute) throws IOException {
        this.write("<td>");
        this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionAttribute.getName()));
        this.write("</td><td>");
        if (sessionAttribute.getType() == null) {
            this.write("null");
        } else {
            this.write(HtmlSourceReport.addLinkToClassName(sessionAttribute.getType()));
        }
        this.write("</td><td align='center'>");
        if (sessionAttribute.isSerializable()) {
            this.write("#oui#");
        } else {
            this.write("<span class='severe'>#non#</span>");
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(sessionAttribute.getSerializedSize()));
        this.write("</td><td>");
        this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(String.valueOf(sessionAttribute.getContent())));
        this.write("</td>");
    }
}

