/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JdbcDriver;
import net.bull.javamelody.JdbcWrapperHelper;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatabaseInformations
implements Serializable {
    static final String RESOURCE_BUNDLE_BASE_NAME = Parameters.getResourcePath("databaseInformations").replace('/', '.').substring(1);
    private static final long serialVersionUID = -6105478981257689782L;
    private final int requestIndex;
    private final List<String> requestNames;
    private final String[][] result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatabaseInformations(int requestIndex) throws Exception {
        this.requestIndex = requestIndex;
        Connection connection = DatabaseInformations.getConnection();
        try {
            Database database = Database.getDatabaseForConnection(connection);
            this.requestNames = database.getRequestNames();
            String request = database.getRequestByName(this.requestNames.get(requestIndex));
            this.result = DatabaseInformations.executeRequest(connection, request);
        }
        finally {
            connection.close();
        }
    }

    int getRequestIndex() {
        return this.requestIndex;
    }

    String[][] getResult() {
        return this.result;
    }

    List<String> getRequestNames() {
        return this.requestNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[][] executeRequest(Connection connection, String request) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            String[][] stringArray;
            ResultSet resultSet = statement.executeQuery(request);
            try {
                int i;
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                ArrayList<String[]> list = new ArrayList<String[]>();
                String[] values = new String[columnCount];
                for (i = 1; i <= columnCount; ++i) {
                    values[i - 1] = metaData.getColumnName(i) + '\n' + metaData.getColumnTypeName(i) + '(' + metaData.getColumnDisplaySize(i) + ')';
                }
                list.add(values);
                while (resultSet.next()) {
                    values = new String[columnCount];
                    for (i = 1; i <= columnCount; ++i) {
                        values[i - 1] = resultSet.getString(i);
                    }
                    list.add(values);
                }
                stringArray = (String[][])list.toArray((T[])new String[list.size()][]);
            }
            catch (Throwable throwable) {
                try {
                    resultSet.close();
                    throw throwable;
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 942 && e.getMessage() != null && e.getMessage().startsWith("ORA-")) {
                        SQLException ex = new SQLException(I18N.getFormattedString("oracle.grantSelectAnyDictionnary", connection.getMetaData().getUserName()));
                        ex.initCause(e);
                        throw ex;
                    }
                    throw e;
                }
            }
            resultSet.close();
            return stringArray;
        }
        finally {
            statement.close();
        }
    }

    private static Connection getConnection() throws SQLException, NamingException {
        JdbcDriver jdbcDriver = JdbcDriver.SINGLETON;
        if (jdbcDriver.getLastConnectUrl() != null) {
            Connection connection = DriverManager.getConnection(jdbcDriver.getLastConnectUrl(), jdbcDriver.getLastConnectInfo());
            connection.setAutoCommit(false);
            return connection;
        }
        Collection<DataSource> dataSources = JdbcWrapperHelper.getDataSources().values();
        if (!dataSources.isEmpty()) {
            Connection connection = dataSources.iterator().next().getConnection();
            connection.setAutoCommit(false);
            return connection;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Database {
        POSTGRESQL,
        MYSQL,
        ORACLE,
        DB2,
        H2;


        List<String> getRequestNames() {
            List<String> tmp;
            switch (this) {
                case POSTGRESQL: {
                    tmp = Arrays.asList("pg_stat_activity", "pg_stat_database", "pg_stat_user_tables", "pg_stat_user_indexes", "pg_statio_user_tables", "pg_statio_user_indexes", "pg_statio_user_sequences", "pg_settings");
                    break;
                }
                case MYSQL: {
                    tmp = Arrays.asList("processlist", "databases", "variables", "status", "innodb_status");
                    break;
                }
                case ORACLE: {
                    tmp = Arrays.asList("sessions", "locks", "sqlTimes", "instance", "database", "nlsParameters", "tablespaceFreespace", "datafileIo", "tablespaceExtents", "ratios", "parameters", "rollbackSegmentStatistics", "statistics", "events");
                    break;
                }
                case DB2: {
                    tmp = Arrays.asList("current_queries");
                    break;
                }
                case H2: {
                    tmp = Arrays.asList("memory");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ArrayList<String> result = new ArrayList<String>(tmp.size());
            String prefix = this.toString().toLowerCase(Locale.getDefault()) + '.';
            for (String requestName : tmp) {
                result.add(prefix + requestName);
            }
            return result;
        }

        String getRequestByName(String requestName) {
            return ResourceBundle.getBundle(RESOURCE_BUNDLE_BASE_NAME).getString(requestName);
        }

        static Database getDatabaseForConnection(Connection connection) throws SQLException {
            String url = connection.getMetaData().getURL();
            for (Database database : Database.values()) {
                if (!url.contains(database.toString().toLowerCase(Locale.getDefault()))) continue;
                return database;
            }
            throw new IllegalArgumentException(I18N.getFormattedString("type_base_de_donnees_inconnu", url));
        }
    }
}

