/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import net.bull.javamelody.Counter;
import net.bull.javamelody.MonitoredWithSpring;
import net.bull.javamelody.MonitoringInterceptor;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;

public class MonitoringSpringInterceptor
implements MethodInterceptor,
Serializable {
    private static final long serialVersionUID = -6594338383847482623L;
    private static final Counter SPRING_COUNTER = MonitoringInterceptor.getSpringCounter();
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        if (DISABLED || !SPRING_COUNTER.isDisplayed()) {
            return invocation.proceed();
        }
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        String requestName = MonitoringSpringInterceptor.getMonitorName(invocation);
        boolean systemError = false;
        try {
            SPRING_COUNTER.bindContext(requestName, requestName, null, startCpuTime);
            object = invocation.proceed();
            Object var10_8 = null;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                SPRING_COUNTER.addRequest(requestName, duration, cpuUsedMillis, systemError, -1);
                throw throwable;
            }
        }
        long duration = Math.max(System.currentTimeMillis() - start, 0L);
        long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
        SPRING_COUNTER.addRequest(requestName, duration, cpuUsedMillis, systemError, -1);
        return object;
    }

    private static String getMonitorName(MethodInvocation invocation) {
        String classPart = MonitoringSpringInterceptor.getClassPart(invocation);
        String methodPart = MonitoringSpringInterceptor.getMethodPart(invocation);
        return classPart + '.' + methodPart;
    }

    private static String getClassPart(MethodInvocation invocation) {
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        MonitoredWithSpring classAnnotation = targetClass.getAnnotation(MonitoredWithSpring.class);
        if (classAnnotation == null || classAnnotation.name() == null || classAnnotation.name().length() == 0) {
            return targetClass.getSimpleName();
        }
        return classAnnotation.name();
    }

    private static String getMethodPart(MethodInvocation invocation) {
        MonitoredWithSpring methodAnnotation = invocation.getMethod().getAnnotation(MonitoredWithSpring.class);
        if (methodAnnotation == null || methodAnnotation.name() == null || methodAnnotation.name().length() == 0) {
            return invocation.getMethod().getName();
        }
        return methodAnnotation.name();
    }
}

