/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;
import net.bull.javamelody.internal.web.html.HtmlSourceReport;

public class HtmlThreadInformationsReport
extends HtmlAbstractReport {
    private final List<ThreadInformations> threadInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean stackTraceEnabled;
    private final boolean cpuTimeEnabled;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    public HtmlThreadInformationsReport(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, Writer writer) {
        super(writer);
        assert (threadInformationsList != null);
        this.threadInformationsList = threadInformationsList;
        this.stackTraceEnabled = stackTraceEnabled;
        this.cpuTimeEnabled = !threadInformationsList.isEmpty() && threadInformationsList.get(0).getCpuTimeMillis() != -1L;
    }

    @Override
    void toHtml() throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable();
        table.beginTable(HtmlThreadInformationsReport.getString("Threads"));
        this.write("<th>#Thread#</th>");
        this.write("<th>#Demon#</th><th class='sorttable_numeric'>#Priorite#</th><th>#Etat#</th>");
        if (this.stackTraceEnabled) {
            this.write("<th>#Methode_executee#</th>");
        }
        if (this.cpuTimeEnabled) {
            this.write("<th class='sorttable_numeric'>#Temps_cpu#</th><th class='sorttable_numeric'>#Temps_user#</th>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<th class='noPrint'>#Interrupt#</th>");
            this.writeln("<th class='noPrint'>#Tuer#</th>");
        }
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            table.nextRow();
            this.writeThreadInformations(threadInformations);
        }
        table.endTable();
        this.writeln("<div align='right'>");
        this.writeln("#Temps_threads#");
        this.writeln("</div>");
    }

    void writeDeadlocks() throws IOException {
        List<ThreadInformations> deadlockedThreads = this.getDeadLockedThreads();
        if (!deadlockedThreads.isEmpty()) {
            this.write("<div class='severe'>#Threads_deadlocks#");
            String separator = " ";
            for (ThreadInformations thread : deadlockedThreads) {
                this.writeDirectly(separator);
                this.writeDirectly(HtmlThreadInformationsReport.htmlEncode(thread.getName()));
                separator = ", ";
            }
            this.write("</div>");
        }
    }

    public void writeThreadsDump() throws IOException {
        List<ThreadInformations> deadlockedThreads = this.getDeadLockedThreads();
        if (!deadlockedThreads.isEmpty()) {
            this.write("#Threads_deadlocks#");
            String separator = " ";
            for (ThreadInformations thread : deadlockedThreads) {
                this.writeDirectly(separator);
                this.writeDirectly(thread.getName());
                separator = ", ";
            }
            this.writeDirectly("\n\n");
        }
        if (this.stackTraceEnabled) {
            for (ThreadInformations threadInformations : this.threadInformationsList) {
                this.writeDirectly("\"");
                this.writeDirectly(threadInformations.getName());
                this.writeDirectly("\"");
                if (threadInformations.isDaemon()) {
                    this.writeDirectly(" daemon");
                }
                this.writeDirectly(" prio=");
                this.writeDirectly(String.valueOf(threadInformations.getPriority()));
                this.writeDirectly(" ");
                this.writeDirectly(String.valueOf((Object)threadInformations.getState()));
                List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
                if (stackTrace != null && !stackTrace.isEmpty()) {
                    for (StackTraceElement element : stackTrace) {
                        this.writeDirectly("\n\t");
                        this.writeDirectly(element.toString());
                    }
                }
                this.writeDirectly("\n\n");
            }
            this.writeDirectly("\n");
        }
    }

    private List<ThreadInformations> getDeadLockedThreads() {
        ArrayList<ThreadInformations> deadlockedThreads = new ArrayList<ThreadInformations>();
        for (ThreadInformations thread : this.threadInformationsList) {
            if (!thread.isDeadlocked()) continue;
            deadlockedThreads.add(thread);
        }
        return deadlockedThreads;
    }

    private void writeThreadInformations(ThreadInformations threadInformations) throws IOException {
        this.write("<td>");
        this.writeThreadWithStackTrace(threadInformations);
        this.write("</td> <td align='center'>");
        if (threadInformations.isDaemon()) {
            this.write("#oui#");
        } else {
            this.write("#non#");
        }
        this.write("</td> <td align='right'>");
        this.write(this.integerFormat.format(threadInformations.getPriority()));
        this.write("</td> <td>");
        this.write("<img src='?resource=bullets/");
        this.write(HtmlThreadInformationsReport.getStateIcon(threadInformations));
        this.write("' alt='");
        this.write(String.valueOf((Object)threadInformations.getState()));
        this.write("'/>");
        this.write(String.valueOf((Object)threadInformations.getState()));
        if (this.stackTraceEnabled) {
            this.write("</td> <td>");
            this.writeExecutedMethod(threadInformations);
        }
        if (this.cpuTimeEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(threadInformations.getCpuTimeMillis()));
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(threadInformations.getUserTimeMillis()));
        }
        this.writeSendThreadInterrupt(threadInformations);
        this.writeKillThread(threadInformations);
        this.write("</td>");
    }

    public static String getStateIcon(ThreadInformations threadInformations) {
        switch (threadInformations.getState()) {
            case RUNNABLE: {
                return "green.png";
            }
            case WAITING: {
                return "yellow.png";
            }
            case TIMED_WAITING: {
                if (HtmlThreadInformationsReport.isSleeping(threadInformations)) {
                    return "blue.png";
                }
                return "yellow.png";
            }
            case BLOCKED: {
                return "red.png";
            }
            case NEW: 
            case TERMINATED: {
                return "gray.png";
            }
        }
        throw new IllegalArgumentException("state inconnu" + (Object)((Object)threadInformations.getState()));
    }

    private static boolean isSleeping(ThreadInformations threadInformations) {
        List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
        return stackTrace != null && !stackTrace.isEmpty() && "sleep".equals(stackTrace.get(0).getMethodName()) && "java.lang.Thread".equals(stackTrace.get(0).getClassName());
    }

    void writeThreadWithStackTrace(ThreadInformations threadInformations) throws IOException {
        List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
        String encodedName = HtmlThreadInformationsReport.htmlEncode(threadInformations.getName());
        if (stackTrace != null && !stackTrace.isEmpty()) {
            this.writeln("<div class='tooltip'>");
            this.writeln("<em>");
            this.writeDirectly(encodedName);
            this.writeln("<br/>");
            for (StackTraceElement stackTraceElement : stackTrace) {
                this.writeDirectly(HtmlSourceReport.htmlEncodeStackTraceElement(stackTraceElement.toString()));
                this.writeDirectly("<br/>");
            }
            this.writeln("</em>");
            this.writeDirectly(encodedName);
            this.writeln("</div>");
        } else {
            this.writeDirectly(encodedName);
        }
    }

    void writeExecutedMethod(ThreadInformations threadInformations) throws IOException {
        String executedMethod = threadInformations.getExecutedMethod();
        if (executedMethod != null && !executedMethod.isEmpty()) {
            this.writeDirectly(HtmlSourceReport.htmlEncodeStackTraceElement(threadInformations.getExecutedMethod()));
        } else {
            this.writeDirectly("&nbsp;");
        }
    }

    void writeSendThreadInterrupt(ThreadInformations threadInformations) throws IOException {
        if (this.systemActionsEnabled) {
            this.write("</td> <td align='center' class='noPrint'>");
            this.write("<a href='?action=send_thread_interrupt&amp;threadId=");
            this.write(threadInformations.getGlobalThreadId());
            this.write(HtmlThreadInformationsReport.getCsrfTokenUrlPart());
            String confirmSendThreadInterrupt = HtmlThreadInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlThreadInformationsReport.getFormattedString("confirm_send_thread_interrupt", threadInformations.getName()));
            this.writeDirectly("' class='confirm' data-confirm='" + confirmSendThreadInterrupt + "'>");
            String title = HtmlThreadInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlThreadInformationsReport.getFormattedString("send_thread_interrupt", threadInformations.getName()));
            this.writeDirectly("<img width='16' height='16' src='?resource=action_interrupt.png' alt='" + title + "' title='" + title + "' />");
            this.write("</a>");
        }
    }

    void writeKillThread(ThreadInformations threadInformations) throws IOException {
        if (this.systemActionsEnabled) {
            this.write("</td> <td align='center' class='noPrint'>");
            this.write("<a href='?action=kill_thread&amp;threadId=");
            this.write(threadInformations.getGlobalThreadId());
            this.write(HtmlThreadInformationsReport.getCsrfTokenUrlPart());
            String confirmKillThread = HtmlThreadInformationsReport.htmlEncodeButNotSpaceAndNewLine(HtmlThreadInformationsReport.getFormattedString("confirm_kill_thread", threadInformations.getName()));
            this.writeDirectly("' class='confirm' data-confirm='" + confirmKillThread + "'>");
            String title = HtmlThreadInformationsReport.htmlEncode(HtmlThreadInformationsReport.getFormattedString("kill_thread", threadInformations.getName()));
            this.writeDirectly("<img width='16' height='16' src='?resource=stop.png' alt='" + title + "' title='" + title + "' />");
            this.write("</a>");
        }
    }
}

