/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.File;
import java.io.IOException;
import java.security.CodeSource;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.bull.javamelody.CounterRequestMXBean;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JobGlobalListener;
import net.bull.javamelody.JpaPersistence;
import net.bull.javamelody.JsfActionHelper;
import net.bull.javamelody.JspWrapper;
import net.bull.javamelody.Log4J2Appender;
import net.bull.javamelody.LogbackAppender;
import net.bull.javamelody.LoggingHandler;
import net.bull.javamelody.MonitoringInitialContextFactory;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.Collector;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.JRobin;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.model.MBeans;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.Period;
import net.bull.javamelody.internal.model.SamplingProfiler;
import net.bull.javamelody.internal.model.UpdateChecker;
import net.bull.javamelody.internal.web.HttpCookieManager;
import net.bull.javamelody.internal.web.MailReport;
import net.bull.javamelody.internal.web.MonitoringController;

class FilterContext {
    private static final boolean MOJARRA_AVAILABLE = FilterContext.isMojarraAvailable();
    private static final boolean JPA2_AVAILABLE = FilterContext.isJpa2Available();
    private final String applicationType;
    private final Collector collector;
    private final Timer timer;
    private final SamplingProfiler samplingProfiler;
    private final TimerTask collectTimerTask;
    private final Set<ObjectName> jmxNames = new HashSet<ObjectName>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FilterContext(String applicationType) {
        assert (applicationType != null);
        this.applicationType = applicationType;
        boolean initOk = false;
        this.timer = new Timer("javamelody" + Parameters.getServletContext().getContextPath().replace('/', ' '), true);
        try {
            String fontConfig;
            this.logSystemInformationsAndParameters();
            FilterContext.initLogs();
            if (Parameter.CONTEXT_FACTORY_ENABLED.getValueAsBoolean()) {
                MonitoringInitialContextFactory.init();
            }
            JdbcWrapper.SINGLETON.initServletContext(Parameters.getServletContext());
            if (!Parameters.isNoDatabase()) {
                JdbcWrapper.SINGLETON.rebindDataSources();
            } else {
                JdbcWrapper.SINGLETON.stop();
            }
            if (JobInformations.QUARTZ_AVAILABLE) {
                JobGlobalListener.initJobGlobalListener();
            }
            if (MOJARRA_AVAILABLE) {
                JsfActionHelper.initJsfActionListener();
            }
            if (JPA2_AVAILABLE) {
                JpaPersistence.initPersistenceProviderResolver();
            }
            this.samplingProfiler = this.initSamplingProfiler();
            List<Counter> counters = FilterContext.initCounters();
            String application = Parameters.getCurrentApplication();
            this.collector = new Collector(application, counters, this.samplingProfiler);
            this.collectTimerTask = new CollectTimerTask(this.collector);
            this.initCollect();
            if (Parameter.JMX_EXPOSE_ENABLED.getValueAsBoolean()) {
                this.initJmxExpose();
            }
            UpdateChecker.init(this.timer, this.collector, applicationType);
            if (Parameters.getServletContext().getServerInfo().contains("Google App Engine") && new File(fontConfig = System.getProperty("java.home") + "/lib/fontconfig.Prodimage.properties").exists()) {
                System.setProperty("sun.awt.fontconfig", fontConfig);
            }
            initOk = true;
        }
        finally {
            if (!initOk) {
                this.timer.cancel();
                LOG.debug("JavaMelody init failed");
            }
        }
    }

    private static List<Counter> initCounters() {
        List<Counter> counters;
        Counter sqlCounter = JdbcWrapper.SINGLETON.getSqlCounter();
        Counter httpCounter = new Counter("http", "dbweb.png", sqlCounter);
        Counter errorCounter = new Counter("error", "error.png");
        errorCounter.setMaxRequestsCount(250);
        Counter jpaCounter = MonitoringProxy.getJpaCounter();
        Counter ejbCounter = MonitoringProxy.getEjbCounter();
        Counter springCounter = MonitoringProxy.getSpringCounter();
        Counter guiceCounter = MonitoringProxy.getGuiceCounter();
        Counter servicesCounter = MonitoringProxy.getServicesCounter();
        Counter strutsCounter = MonitoringProxy.getStrutsCounter();
        Counter jsfCounter = MonitoringProxy.getJsfCounter();
        Counter logCounter = LoggingHandler.getLogCounter();
        Counter jspCounter = JspWrapper.getJspCounter();
        if (JobInformations.QUARTZ_AVAILABLE) {
            Counter jobCounter = JobGlobalListener.getJobCounter();
            counters = List.of(httpCounter, sqlCounter, jpaCounter, ejbCounter, springCounter, guiceCounter, servicesCounter, strutsCounter, jsfCounter, jspCounter, errorCounter, logCounter, jobCounter);
        } else {
            counters = List.of(httpCounter, sqlCounter, jpaCounter, ejbCounter, springCounter, guiceCounter, servicesCounter, strutsCounter, jsfCounter, jspCounter, errorCounter, logCounter);
        }
        FilterContext.setRequestTransformPatterns(counters);
        String displayedCounters = Parameter.DISPLAYED_COUNTERS.getValue();
        if (displayedCounters == null) {
            httpCounter.setDisplayed(true);
            sqlCounter.setDisplayed(!Parameters.isNoDatabase());
            errorCounter.setDisplayed(true);
            logCounter.setDisplayed(true);
            jpaCounter.setDisplayed(jpaCounter.isUsed());
            ejbCounter.setDisplayed(ejbCounter.isUsed());
            springCounter.setDisplayed(springCounter.isUsed());
            guiceCounter.setDisplayed(guiceCounter.isUsed());
            servicesCounter.setDisplayed(servicesCounter.isUsed());
            strutsCounter.setDisplayed(strutsCounter.isUsed());
            jsfCounter.setDisplayed(jsfCounter.isUsed());
            jspCounter.setDisplayed(jspCounter.isUsed());
        } else {
            FilterContext.setDisplayedCounters(counters, displayedCounters);
        }
        LOG.debug("counters initialized");
        return counters;
    }

    private static void setRequestTransformPatterns(List<Counter> counters) {
        for (Counter counter : counters) {
            Parameter parameter = Parameter.valueOfIgnoreCase(counter.getName() + "_TRANSFORM_PATTERN");
            if (parameter.getValue() == null) continue;
            Pattern pattern = Pattern.compile(parameter.getValue(), 40);
            counter.setRequestTransformPattern(pattern);
        }
    }

    private static void setDisplayedCounters(List<Counter> counters, String displayedCounters) {
        for (Counter counter : counters) {
            counter.setDisplayed(counter.isJobCounter());
        }
        if (!displayedCounters.isEmpty()) {
            for (String displayedCounter : displayedCounters.split(",")) {
                String displayedCounterName = displayedCounter.trim();
                boolean found = false;
                for (Counter counter : counters) {
                    if (!displayedCounterName.equalsIgnoreCase(counter.getName())) continue;
                    counter.setDisplayed(true);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new IllegalArgumentException("Unknown counter: " + displayedCounterName);
            }
        }
    }

    private void initCollect() {
        try {
            Class.forName("org.jrobin.core.RrdDb");
            Class.forName("org.jrobin.core.RrdException");
        }
        catch (ClassNotFoundException e) {
            LOG.debug("jrobin classes unavailable: collect of data is disabled");
            HttpCookieManager.setDefaultRange(Period.TOUT.getRange());
            return;
        }
        if (this.collector.isStorageUsedByMultipleInstances()) {
            LOG.info(I18N.getString("storage_used_by_multiple_instances"));
        }
        try {
            JRobin.initBackendFactory(this.timer);
        }
        catch (IOException e) {
            LOG.warn(e.toString(), e);
        }
        int resolutionSeconds = Parameters.getResolutionSeconds();
        int periodMillis = resolutionSeconds * 1000;
        this.timer.schedule(this.collectTimerTask, periodMillis, (long)periodMillis);
        LOG.debug("collect task scheduled every " + resolutionSeconds + "s");
        this.collector.collectLocalContextWithoutErrors();
        LOG.debug("first collect of data done");
        if (Parameter.MAIL_SESSION.getValue() != null && Parameter.ADMIN_EMAILS.getValue() != null) {
            MailReport.scheduleReportMailForLocalServer(this.collector, this.timer);
            LOG.debug("mail reports scheduled for " + Parameter.ADMIN_EMAILS.getValue());
        }
    }

    private SamplingProfiler initSamplingProfiler() {
        if (Parameter.SAMPLING_SECONDS.getValue() != null) {
            String excludedPackagesParameter = Parameter.SAMPLING_EXCLUDED_PACKAGES.getValue();
            String includedPackagesParameter = Parameter.SAMPLING_INCLUDED_PACKAGES.getValue();
            final SamplingProfiler sampler = excludedPackagesParameter == null && includedPackagesParameter == null ? new SamplingProfiler() : new SamplingProfiler(excludedPackagesParameter, includedPackagesParameter);
            TimerTask samplingTimerTask = new TimerTask(){

                @Override
                public void run() {
                    sampler.update();
                }
            };
            long periodInMillis = Math.round(Double.parseDouble(Parameter.SAMPLING_SECONDS.getValue()) * 1000.0);
            this.timer.schedule(samplingTimerTask, 10000L, periodInMillis);
            LOG.debug("hotspots sampling initialized");
            return sampler;
        }
        return null;
    }

    private static void initLogs() {
        LoggingHandler.getSingleton().register();
        if (LOG.LOG4J2_ENABLED) {
            Log4J2Appender.getSingleton().register();
        }
        if (LOG.LOGBACK_ENABLED) {
            LogbackAppender.getSingleton().register();
        }
        LOG.debug("log listeners initialized");
    }

    private static boolean isMojarraAvailable() {
        try {
            Class.forName("com.sun.faces.application.ActionListenerImpl");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean isJpa2Available() {
        try {
            Class.forName("javax.persistence.spi.PersistenceProviderResolverHolder");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void logSystemInformationsAndParameters() {
        LOG.debug("OS: " + System.getProperty("os.name") + " " + System.getProperty("sun.os.patch.level") + ", " + System.getProperty("os.arch") + "/" + System.getProperty("sun.arch.data.model"));
        LOG.debug("Java: " + System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version"));
        LOG.debug("Server: " + Parameters.getServletContext().getServerInfo());
        LOG.debug("Webapp context: " + Parameters.getServletContext().getContextPath());
        LOG.debug("JavaMelody version: " + Parameters.JAVAMELODY_VERSION);
        String location = FilterContext.getJavaMelodyLocation();
        if (location != null) {
            LOG.debug("JavaMelody classes loaded from: " + location);
        }
        LOG.debug("Application type: " + this.applicationType);
        LOG.debug("Application version: " + MavenArtifact.getWebappVersion());
        LOG.debug("Host: " + Parameters.getHostName() + "@" + Parameters.getHostAddress());
        for (Parameter parameter : Parameter.values()) {
            String value = parameter.getValue();
            if (value == null || parameter == Parameter.ANALYTICS_ID) continue;
            if (parameter == Parameter.AUTHORIZED_USERS) {
                LOG.debug("parameter defined: " + Parameter.AUTHORIZED_USERS.getCode() + "=*****");
                continue;
            }
            LOG.debug("parameter defined: " + parameter.getCode() + "=" + value);
        }
    }

    private static String getJavaMelodyLocation() {
        Class<FilterContext> clazz = FilterContext.class;
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource != null && codeSource.getLocation() != null) {
            String clazzFileName;
            String location = codeSource.getLocation().toString();
            if (location.endsWith(clazzFileName = clazz.getSimpleName() + ".class")) {
                location = location.substring(0, location.length() - clazzFileName.length());
            }
            return location;
        }
        return null;
    }

    private void initJmxExpose() {
        String packageName = this.getClass().getName().substring(0, this.getClass().getName().length() - this.getClass().getSimpleName().length() - 1);
        String webapp = Parameters.getServletContext().getContextPath();
        if (!webapp.isEmpty() && webapp.charAt(0) == '/') {
            webapp = webapp.substring(1);
        }
        List<Counter> counters = this.collector.getCounters();
        MBeanServer platformMBeanServer = MBeans.getPlatformMBeanServer();
        try {
            for (Counter counter : counters) {
                if (Parameters.isCounterHidden(counter.getName())) continue;
                CounterRequestMXBean.CounterRequestMXBeanImpl mxBean = new CounterRequestMXBean.CounterRequestMXBeanImpl(counter);
                ObjectName name = new ObjectName(packageName + ":type=CounterRequest,context=" + webapp + ",name=" + counter.getName());
                platformMBeanServer.registerMBean(mxBean, name);
                this.jmxNames.add(name);
            }
            LOG.debug("JMX mbeans registered");
        }
        catch (JMException e) {
            LOG.warn("failed to register JMX mbeans", e);
        }
    }

    void stopCollector() {
        if (this.collectTimerTask != null) {
            this.collectTimerTask.cancel();
        }
        this.collector.stop();
    }

    void destroy() {
        try {
            try {
                if (this.collector != null) {
                    new MonitoringController(this.collector, null).writeHtmlToLastShutdownFile();
                }
            }
            finally {
                JdbcWrapper.SINGLETON.stop();
                FilterContext.deregisterJdbcDriver();
                FilterContext.deregisterLogs();
                if (JobInformations.QUARTZ_AVAILABLE) {
                    JobGlobalListener.destroyJobGlobalListener();
                }
                this.unregisterJmxExpose();
            }
        }
        finally {
            MonitoringInitialContextFactory.stop();
            if (this.timer != null) {
                this.timer.cancel();
            }
            if (this.samplingProfiler != null) {
                this.samplingProfiler.clear();
            }
            if (this.collector != null) {
                this.collector.stop();
            }
            Collector.stopJRobin();
            Collector.detachVirtualMachine();
        }
    }

    private static void deregisterJdbcDriver() {
        Class<FilterContext> classe = FilterContext.class;
        String packageName = classe.getName().substring(0, classe.getName().length() - classe.getSimpleName().length() - 1);
        for (Driver driver : Collections.list(DriverManager.getDrivers())) {
            if (!driver.getClass().getName().startsWith(packageName)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static void deregisterLogs() {
        if (LOG.LOGBACK_ENABLED) {
            LogbackAppender.getSingleton().deregister();
        }
        if (LOG.LOG4J2_ENABLED) {
            Log4J2Appender.getSingleton().deregister();
        }
        LoggingHandler.getSingleton().deregister();
    }

    private void unregisterJmxExpose() {
        if (this.jmxNames.isEmpty()) {
            return;
        }
        try {
            MBeanServer platformMBeanServer = MBeans.getPlatformMBeanServer();
            for (ObjectName name : this.jmxNames) {
                platformMBeanServer.unregisterMBean(name);
            }
        }
        catch (JMException e) {
            LOG.warn("failed to unregister JMX beans", e);
        }
    }

    Collector getCollector() {
        return this.collector;
    }

    Timer getTimer() {
        return this.timer;
    }

    private static final class CollectTimerTask
    extends TimerTask {
        private final Collector collector;

        CollectTimerTask(Collector collector) {
            this.collector = collector;
        }

        @Override
        public void run() {
            this.collector.collectLocalContextWithoutErrors();
        }
    }
}

