/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequestContext;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.web.html.HtmlCounterRequestContextReport;
import net.bull.javamelody.internal.web.pdf.PdfAbstractTableReport;
import net.bull.javamelody.internal.web.pdf.PdfCounterReport;
import net.bull.javamelody.internal.web.pdf.PdfDocumentFactory;
import net.bull.javamelody.internal.web.pdf.PdfFonts;

class PdfCounterRequestContextReport
extends PdfAbstractTableReport {
    private final List<CounterRequestContext> rootCurrentContexts;
    private final Map<String, PdfCounterReport> counterReportsByCounterName;
    private final Map<Long, ThreadInformations> threadInformationsByThreadId;
    private final boolean childHitsDisplayed;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private long timeOfSnapshot = System.currentTimeMillis();
    private final boolean stackTraceEnabled;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font normalFont = PdfFonts.NORMAL.getFont();
    private final Font infoCellFont = PdfFonts.INFO_CELL.getFont();
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfCounterRequestContextReport(List<CounterRequestContext> rootCurrentContexts, List<PdfCounterReport> pdfCounterReports, List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, PdfDocumentFactory pdfDocumentFactory, Document document) {
        super(document);
        assert (rootCurrentContexts != null);
        assert (pdfCounterReports != null);
        assert (threadInformationsList != null);
        assert (pdfDocumentFactory != null);
        this.rootCurrentContexts = rootCurrentContexts;
        this.counterReportsByCounterName = new HashMap<String, PdfCounterReport>(pdfCounterReports.size());
        for (PdfCounterReport counterReport : pdfCounterReports) {
            this.counterReportsByCounterName.put(counterReport.getCounterName(), counterReport);
        }
        this.threadInformationsByThreadId = new HashMap<Long, ThreadInformations>(threadInformationsList.size());
        for (ThreadInformations threadInformations : threadInformationsList) {
            this.threadInformationsByThreadId.put(threadInformations.getId(), threadInformations);
        }
        this.pdfDocumentFactory = pdfDocumentFactory;
        boolean oneRootHasChild = false;
        for (CounterRequestContext rootCurrentContext : rootCurrentContexts) {
            if (!rootCurrentContext.hasChildHits()) continue;
            oneRootHasChild = true;
            break;
        }
        this.childHitsDisplayed = oneRootHasChild;
        this.stackTraceEnabled = stackTraceEnabled;
    }

    void setTimeOfSnapshot(long timeOfSnapshot) {
        this.timeOfSnapshot = timeOfSnapshot;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            return;
        }
        this.writeContexts(Collections.singletonList(this.rootCurrentContexts.get(0)));
    }

    void writeContextDetails() throws DocumentException, IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            return;
        }
        this.writeContexts(this.rootCurrentContexts);
    }

    private void writeContexts(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        boolean displayRemoteUser = false;
        for (CounterRequestContext context : contexts) {
            if (context.getRemoteUser() == null) continue;
            displayRemoteUser = true;
            break;
        }
        this.writeHeader(contexts, displayRemoteUser);
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setLeading(2.0f, 1.0f);
        defaultCell.setPaddingTop(0.0f);
        for (CounterRequestContext context : contexts) {
            this.nextRow();
            this.writeContext(context, displayRemoteUser);
        }
        this.addTableToDocument();
        this.writeFooter();
    }

    private void writeHeader(List<CounterRequestContext> contexts, boolean displayRemoteUser) throws DocumentException {
        List<String> headers = this.createHeaders(contexts, displayRemoteUser);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (displayRemoteUser) {
            relativeWidths[2] = 6;
        } else {
            relativeWidths[1] = 6;
        }
        if (this.stackTraceEnabled) {
            relativeWidths[headers.size() - 1] = 3;
        }
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders(List<CounterRequestContext> contexts, boolean displayRemoteUser) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfCounterRequestContextReport.getString("Thread"));
        if (displayRemoteUser) {
            headers.add(PdfCounterRequestContextReport.getString("Utilisateur"));
        }
        headers.add(PdfCounterRequestContextReport.getString("Requete"));
        headers.add(PdfCounterRequestContextReport.getString("Duree_ecoulee"));
        headers.add(PdfCounterRequestContextReport.getString("Temps_moyen"));
        headers.add(PdfCounterRequestContextReport.getString("Temps_cpu"));
        headers.add(PdfCounterRequestContextReport.getString("Temps_cpu_moyen"));
        if (this.childHitsDisplayed) {
            String childCounterName = contexts.get(0).getParentCounter().getChildCounterName();
            headers.add(PdfCounterRequestContextReport.getFormattedString("hits_fils", childCounterName));
            headers.add(PdfCounterRequestContextReport.getFormattedString("hits_fils_moyens", childCounterName));
            headers.add(PdfCounterRequestContextReport.getFormattedString("temps_fils", childCounterName));
            headers.add(PdfCounterRequestContextReport.getFormattedString("temps_fils_moyen", childCounterName));
        }
        if (this.stackTraceEnabled) {
            headers.add(PdfCounterRequestContextReport.getString("Methode_executee"));
        }
        return headers;
    }

    private void writeFooter() throws DocumentException {
        Paragraph footer = new Paragraph(PdfCounterRequestContextReport.getFormattedString("nb_requete_en_cours", this.integerFormat.format(this.rootCurrentContexts.size())), this.normalFont);
        footer.setAlignment(2);
        this.addToDocument((Element)footer);
    }

    private void writeContext(CounterRequestContext rootContext, boolean displayRemoteUser) throws DocumentException, IOException {
        this.getDefaultCell().setHorizontalAlignment(0);
        this.addCell(rootContext.getThreadName());
        if (displayRemoteUser) {
            if (rootContext.getRemoteUser() == null) {
                this.addCell("");
            } else {
                this.addCell(rootContext.getRemoteUser());
            }
        }
        ArrayList<CounterRequestContext> contexts = new ArrayList<CounterRequestContext>();
        contexts.add(rootContext);
        contexts.addAll(rootContext.getChildContexts());
        this.writeRequests(contexts);
        this.writeDurations(contexts);
        HtmlCounterRequestContextReport.CounterRequestContextReportHelper counterRequestContextReportHelper = new HtmlCounterRequestContextReport.CounterRequestContextReportHelper(contexts, this.childHitsDisplayed);
        for (int[] requestValues : counterRequestContextReportHelper.getRequestValues()) {
            this.writeRequestValues(requestValues);
        }
        if (this.stackTraceEnabled) {
            this.getDefaultCell().setHorizontalAlignment(0);
            ThreadInformations threadInformations = this.threadInformationsByThreadId.get(rootContext.getThreadId());
            if (threadInformations == null) {
                List<StackTraceElement> stackTrace = rootContext.getThreadStackTrace();
                if (stackTrace != null && !stackTrace.isEmpty()) {
                    this.addCell(stackTrace.get(0).toString());
                } else {
                    this.addCell("");
                }
            } else {
                this.addCell(threadInformations.getExecutedMethod());
            }
        }
    }

    private void writeDurations(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        this.getDefaultCell().setHorizontalAlignment(2);
        Paragraph paragraph = new Paragraph("", this.cellFont);
        boolean first = true;
        for (CounterRequestContext context : contexts) {
            if (!first) {
                paragraph.add((Object)new Chunk('\n', this.cellFont));
            }
            int duration = context.getDuration(this.timeOfSnapshot);
            Counter parentCounter = context.getParentCounter();
            PdfCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
            if (parentCounter.getIconName() != null) {
                paragraph.add((Object)new Chunk(this.getImage(parentCounter.getIconName()), 0.0f, -1.0f));
            }
            Font slaFont = counterReport == null ? this.infoCellFont : counterReport.getSlaFont(duration);
            paragraph.add((Object)new Phrase(this.integerFormat.format(duration), slaFont));
            first = false;
        }
        this.addCell((Phrase)paragraph);
    }

    private void writeRequests(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        PdfPCell requestCell = new PdfPCell();
        Paragraph phrase = new Paragraph("", this.cellFont);
        int margin = 0;
        for (CounterRequestContext context : contexts) {
            this.writeRequest(context, requestCell, margin);
            margin += 5;
        }
        requestCell.addElement((Element)phrase);
        requestCell.setGrayFill(defaultCell.getGrayFill());
        requestCell.setPaddingTop(defaultCell.getPaddingTop());
        this.addCell(requestCell);
    }

    private void writeRequest(CounterRequestContext context, PdfPCell cell, int margin) throws DocumentException, IOException {
        Paragraph paragraph = new Paragraph(this.getDefaultCell().getLeading() + this.cellFont.getSize());
        paragraph.setIndentationLeft((float)margin);
        if (context.getParentCounter().getIconName() != null) {
            paragraph.add((Object)new Chunk(this.getImage(context.getParentCounter().getIconName()), 0.0f, -1.0f));
        }
        paragraph.add((Object)new Phrase(context.getCompleteRequestName(), this.cellFont));
        cell.addElement((Element)paragraph);
    }

    private void writeRequestValues(int[] requestValues) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int value : requestValues) {
            if (!first) {
                sb.append('\n');
            }
            if (value != -1) {
                sb.append(this.integerFormat.format(value));
            }
            first = false;
        }
        this.addCell(sb.toString());
    }

    private Image getImage(String resourceFileName) throws DocumentException, IOException {
        return this.pdfDocumentFactory.getSmallImage(resourceFileName);
    }
}

