/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.ClassConstant;
import net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import net.bytebuddy.implementation.bytecode.constant.LongConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodHandleConstant;
import net.bytebuddy.implementation.bytecode.constant.MethodTypeConstant;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.constant.TextConstant;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;
import org.objectweb.asm.MethodVisitor;

public abstract class FixedValue
implements Implementation {
    protected final Assigner assigner;
    protected final boolean dynamicallyTyped;

    protected FixedValue(Assigner assigner, boolean dynamicallyTyped) {
        this.assigner = assigner;
        this.dynamicallyTyped = dynamicallyTyped;
    }

    public static Implementation nullValue() {
        return FixedValue.value(null);
    }

    public static AssignerConfigurable value(Object fixedValue) {
        if (fixedValue == null) {
            return new ForPoolValue(NullConstant.INSTANCE, TypeDescription.OBJECT, Assigner.DEFAULT, true);
        }
        Class<?> type = fixedValue.getClass();
        if (type == String.class) {
            return new ForPoolValue(new TextConstant((String)fixedValue), TypeDescription.STRING, Assigner.DEFAULT, false);
        }
        if (type == Class.class) {
            return new ForPoolValue(ClassConstant.of(new TypeDescription.ForLoadedType(type)), TypeDescription.CLASS, Assigner.DEFAULT, false);
        }
        if (type == Boolean.class) {
            return new ForPoolValue(IntegerConstant.forValue((Boolean)fixedValue), new TypeDescription.ForLoadedType(Boolean.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Byte.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Byte)fixedValue).byteValue()), new TypeDescription.ForLoadedType(Byte.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Short.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Short)fixedValue).shortValue()), new TypeDescription.ForLoadedType(Short.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Character.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Character)fixedValue).charValue()), new TypeDescription.ForLoadedType(Character.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Integer.class) {
            return new ForPoolValue(IntegerConstant.forValue((Integer)fixedValue), new TypeDescription.ForLoadedType(Integer.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Long.class) {
            return new ForPoolValue(LongConstant.forValue((Long)fixedValue), new TypeDescription.ForLoadedType(Long.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Float.class) {
            return new ForPoolValue(FloatConstant.forValue(((Float)fixedValue).floatValue()), new TypeDescription.ForLoadedType(Float.TYPE), Assigner.DEFAULT, false);
        }
        if (type == Double.class) {
            return new ForPoolValue(DoubleConstant.forValue((Double)fixedValue), new TypeDescription.ForLoadedType(Double.TYPE), Assigner.DEFAULT, false);
        }
        if (JavaType.METHOD_HANDLE.getTypeStub().isAssignableFrom(type)) {
            return new ForPoolValue(MethodHandleConstant.of(JavaInstance.MethodHandle.of(fixedValue)), new TypeDescription.ForLoadedType(type), Assigner.DEFAULT, false);
        }
        if (JavaType.METHOD_TYPE.getTypeStub().represents(type)) {
            return new ForPoolValue(MethodTypeConstant.of(JavaInstance.MethodType.of(fixedValue)), new TypeDescription.ForLoadedType(type), Assigner.DEFAULT, false);
        }
        return FixedValue.reference(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue) {
        return (AssignerConfigurable)((Object)(fixedValue == null ? new ForPoolValue(NullConstant.INSTANCE, TypeDescription.OBJECT, Assigner.DEFAULT, true) : new ForStaticField(fixedValue, Assigner.DEFAULT, false)));
    }

    public static AssignerConfigurable reference(Object fixedValue, String fieldName) {
        if (fixedValue == null) {
            throw new IllegalArgumentException("The fixed value must not be null");
        }
        return new ForStaticField(ByteBuddyCommons.isValidIdentifier(fieldName), fixedValue, Assigner.DEFAULT, false);
    }

    public static AssignerConfigurable value(TypeDescription fixedValue) {
        return new ForPoolValue(ClassConstant.of(fixedValue), TypeDescription.CLASS, Assigner.DEFAULT, false);
    }

    public static AssignerConfigurable value(JavaInstance fixedValue) {
        return new ForPoolValue(fixedValue.asStackManipulation(), fixedValue.getInstanceType(), Assigner.DEFAULT, false);
    }

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod, TypeDescription fixedValueType, StackManipulation valueLoadingInstruction) {
        StackManipulation assignment = this.assigner.assign(fixedValueType, instrumentedMethod.getReturnType(), this.dynamicallyTyped);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + fixedValueType + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(valueLoadingInstruction, assignment, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.dynamicallyTyped == ((FixedValue)other).dynamicallyTyped && this.assigner.equals(((FixedValue)other).assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + (this.dynamicallyTyped ? 1 : 0);
    }

    protected static class ForStaticField
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "fixedValue";
        private final String fieldName;
        private final Object fixedValue;
        private final TypeDescription fieldType;

        protected ForStaticField(Object fixedValue, Assigner assigner, boolean dynamicallyTyped) {
            this(String.format("%s$%d", PREFIX, Math.abs(fixedValue.hashCode())), fixedValue, assigner, dynamicallyTyped);
        }

        protected ForStaticField(String fieldName, Object fixedValue, Assigner assigner, boolean dynamicallyTyped) {
            super(assigner, dynamicallyTyped);
            this.fieldName = fieldName;
            this.fixedValue = fixedValue;
            this.fieldType = new TypeDescription.ForLoadedType(fixedValue.getClass());
        }

        @Override
        public Implementation withAssigner(Assigner assigner, boolean dynamicallyTyped) {
            return new ForStaticField(this.fieldName, this.fixedValue, ByteBuddyCommons.nonNull(assigner), dynamicallyTyped);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, this.fieldType, 4106).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.fixedValue));
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return new StaticFieldByteCodeAppender(implementationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForStaticField)other).fieldName) && this.fixedValue.equals(((ForStaticField)other).fixedValue) && super.equals(other);
        }

        @Override
        public int hashCode() {
            return 961 * super.hashCode() + 31 * this.fieldName.hashCode() + this.fixedValue.hashCode();
        }

        public String toString() {
            return "FixedValue.ForStaticField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", fixedValue=" + this.fixedValue + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
        }

        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                this.fieldGetAccess = FieldAccess.forField((FieldDescription)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(ForStaticField.this.fieldName))).getOnly()).getter();
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return ForStaticField.this.apply(methodVisitor, implementationContext, instrumentedMethod, ForStaticField.this.fieldType, this.fieldGetAccess);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldGetAccess.equals(((StaticFieldByteCodeAppender)other).fieldGetAccess);
            }

            public int hashCode() {
                return this.fieldGetAccess.hashCode();
            }

            public String toString() {
                return "StaticFieldByteCodeAppender{fieldGetAccess=" + this.fieldGetAccess + '}';
            }
        }
    }

    protected static class ForPoolValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        private ForPoolValue(StackManipulation valueLoadInstruction, TypeDescription loadedType, Assigner assigner, boolean dynamicallyTyped) {
            super(assigner, dynamicallyTyped);
            this.valueLoadInstruction = valueLoadInstruction;
            this.loadedType = loadedType;
        }

        @Override
        public Implementation withAssigner(Assigner assigner, boolean dynamicallyTyped) {
            return new ForPoolValue(this.valueLoadInstruction, this.loadedType, ByteBuddyCommons.nonNull(assigner), dynamicallyTyped);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return this;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            return this.apply(methodVisitor, implementationContext, instrumentedMethod, this.loadedType, this.valueLoadInstruction);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.loadedType.equals(((ForPoolValue)other).loadedType) && this.valueLoadInstruction.equals(((ForPoolValue)other).valueLoadInstruction);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.valueLoadInstruction.hashCode();
            result = 31 * result + this.loadedType.hashCode();
            return result;
        }

        public String toString() {
            return "FixedValue.ForPoolValue{valueLoadInstruction=" + this.valueLoadInstruction + ", loadedType=" + this.loadedType + ", assigner=" + this.assigner + ", dynamicallyTyped=" + this.dynamicallyTyped + '}';
        }
    }

    public static interface AssignerConfigurable
    extends Implementation {
        public Implementation withAssigner(Assigner var1, boolean var2);
    }
}

