/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.ElementMatchers;
import org.objectweb.asm.MethodVisitor;

public enum FieldAccess {
    STATIC(179, 178, StackSize.ZERO),
    INSTANCE(181, 180, StackSize.SINGLE);

    private final int putterOpcode;
    private final int getterOpcode;
    private final int targetSizeChange;

    private FieldAccess(int putterOpcode, int getterOpcode, StackSize targetSizeChange) {
        this.putterOpcode = putterOpcode;
        this.getterOpcode = getterOpcode;
        this.targetSizeChange = targetSizeChange.getSize();
    }

    public static StackManipulation forEnumeration(EnumerationDescription enumerationDescription) {
        StackManipulation stackManipulation;
        FieldList fieldList = (FieldList)enumerationDescription.getEnumerationType().getDeclaredFields().filter(ElementMatchers.named(enumerationDescription.getValue()));
        if (!(fieldList.size() == 1 && ((FieldDescription)fieldList.getOnly()).isStatic() && ((FieldDescription)fieldList.getOnly()).isPublic() && ((FieldDescription)fieldList.getOnly()).isEnum())) {
            stackManipulation = StackManipulation.Illegal.INSTANCE;
        } else {
            FieldAccess fieldAccess = STATIC;
            ((Object)((Object)fieldAccess)).getClass();
            stackManipulation = fieldAccess.new AccessDispatcher((FieldDescription)fieldList.getOnly()).getter();
        }
        return stackManipulation;
    }

    public static Defined forField(FieldDescription fieldDescription) {
        if (fieldDescription.isStatic()) {
            FieldAccess fieldAccess = STATIC;
            ((Object)((Object)fieldAccess)).getClass();
            return fieldAccess.new AccessDispatcher(fieldDescription);
        }
        FieldAccess fieldAccess = INSTANCE;
        ((Object)((Object)fieldAccess)).getClass();
        return fieldAccess.new AccessDispatcher(fieldDescription);
    }

    public String toString() {
        return "FieldAccess." + this.name();
    }

    protected class AccessDispatcher
    implements Defined {
        private final FieldDescription fieldDescription;

        protected AccessDispatcher(FieldDescription fieldDescription) {
            this.fieldDescription = fieldDescription;
        }

        @Override
        public StackManipulation getter() {
            return new FieldGetInstruction();
        }

        @Override
        public StackManipulation putter() {
            return new FieldPutInstruction();
        }

        @Override
        public FieldDescription getDefinedField() {
            return this.fieldDescription;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && FieldAccess.this.equals((Object)((AccessDispatcher)other).getFieldAccess()) && this.fieldDescription.equals(((AccessDispatcher)other).fieldDescription);
        }

        public int hashCode() {
            return this.fieldDescription.hashCode() + 31 * FieldAccess.this.hashCode();
        }

        public String toString() {
            return "FieldAccess.AccessDispatcher{fieldAccess=" + (Object)((Object)FieldAccess.this) + ", fieldDescription=" + this.fieldDescription + '}';
        }

        private FieldAccess getFieldAccess() {
            return FieldAccess.this;
        }

        protected class FieldPutInstruction
        extends AbstractFieldInstruction {
            protected FieldPutInstruction() {
            }

            @Override
            protected int getOpcode() {
                return FieldAccess.this.putterOpcode;
            }

            @Override
            protected StackManipulation.Size resolveSize(StackSize fieldSize) {
                return new StackManipulation.Size(-1 * (fieldSize.getSize() + FieldAccess.this.targetSizeChange), 0);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.getAccessDispatcher().equals(((FieldPutInstruction)other).getAccessDispatcher());
            }

            public int hashCode() {
                return this.getAccessDispatcher().hashCode() + 14;
            }

            public String toString() {
                return "FieldAccess.AccessDispatcher.FieldPutInstruction{fieldDescription=" + AccessDispatcher.this.fieldDescription + '}';
            }

            private AccessDispatcher getAccessDispatcher() {
                return AccessDispatcher.this;
            }
        }

        protected class FieldGetInstruction
        extends AbstractFieldInstruction {
            protected FieldGetInstruction() {
            }

            @Override
            protected int getOpcode() {
                return FieldAccess.this.getterOpcode;
            }

            @Override
            protected StackManipulation.Size resolveSize(StackSize fieldSize) {
                int sizeChange = fieldSize.getSize() - FieldAccess.this.targetSizeChange;
                return new StackManipulation.Size(sizeChange, sizeChange);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.getAccessDispatcher().equals(((FieldGetInstruction)other).getAccessDispatcher());
            }

            public int hashCode() {
                return this.getAccessDispatcher().hashCode() + 7;
            }

            public String toString() {
                return "FieldAccess.AccessDispatcher.FieldGetInstruction{fieldDescription=" + AccessDispatcher.this.fieldDescription + '}';
            }

            private AccessDispatcher getAccessDispatcher() {
                return AccessDispatcher.this;
            }
        }

        private abstract class AbstractFieldInstruction
        implements StackManipulation {
            private AbstractFieldInstruction() {
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                methodVisitor.visitFieldInsn(this.getOpcode(), AccessDispatcher.this.fieldDescription.getDeclaringType().getInternalName(), AccessDispatcher.this.fieldDescription.getInternalName(), AccessDispatcher.this.fieldDescription.getDescriptor());
                return this.resolveSize(AccessDispatcher.this.fieldDescription.getFieldType().getStackSize());
            }

            protected abstract int getOpcode();

            protected abstract StackManipulation.Size resolveSize(StackSize var1);
        }
    }

    public static interface Defined {
        public StackManipulation getter();

        public StackManipulation putter();

        public FieldDescription getDefinedField();
    }
}

