/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.member;

import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

public enum MethodInvocation {
    VIRTUAL(182, 5),
    INTERFACE(185, 9),
    STATIC(184, 6),
    SPECIAL(183, 7),
    SPECIAL_CONSTRUCTOR(183, 8);

    private final int invocationOpcode;
    private final int handle;

    private MethodInvocation(int callOpcode, int handle) {
        this.invocationOpcode = callOpcode;
        this.handle = handle;
    }

    public static WithImplicitInvocationTargetType invoke(MethodDescription methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            return IllegalInvocation.INSTANCE;
        }
        if (methodDescription.isStatic()) {
            MethodInvocation methodInvocation = STATIC;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isConstructor()) {
            MethodInvocation methodInvocation = SPECIAL_CONSTRUCTOR;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isPrivate() || methodDescription.isDefaultMethod()) {
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.getDeclaringType().isInterface()) {
            MethodInvocation methodInvocation = INTERFACE;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        MethodInvocation methodInvocation = VIRTUAL;
        ((Object)((Object)methodInvocation)).getClass();
        return methodInvocation.new Invocation(methodDescription);
    }

    public String toString() {
        return "MethodInvocation." + this.name();
    }

    protected class DynamicInvocation
    implements StackManipulation {
        private final String methodName;
        private final TypeDescription returnType;
        private final TypeList parameterTypes;
        private final MethodDescription bootstrapMethod;
        private final List<?> arguments;

        public DynamicInvocation(String methodName, TypeDescription returnType, TypeList parameterTypes, MethodDescription bootstrapMethod, List<?> arguments) {
            this.methodName = methodName;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.bootstrapMethod = bootstrapMethod;
            this.arguments = arguments;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            StringBuilder stringBuilder = new StringBuilder("(");
            for (TypeDescription parameterType : this.parameterTypes) {
                stringBuilder.append(parameterType.getDescriptor());
            }
            String methodDescriptor = stringBuilder.append(')').append(this.returnType.getDescriptor()).toString();
            methodVisitor.visitInvokeDynamicInsn(this.methodName, methodDescriptor, new Handle(MethodInvocation.this.handle, this.bootstrapMethod.getDeclaringType().getInternalName(), this.bootstrapMethod.getInternalName(), this.bootstrapMethod.getDescriptor()), this.arguments.toArray(new Object[this.arguments.size()]));
            int stackSize = this.returnType.getStackSize().getSize() - this.parameterTypes.getStackSize();
            return new StackManipulation.Size(stackSize, Math.max(stackSize, 0));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            DynamicInvocation that = (DynamicInvocation)other;
            return MethodInvocation.this == that.getOuter() && this.arguments.equals(that.arguments) && this.bootstrapMethod.equals(that.bootstrapMethod) && this.returnType.equals(that.returnType) && this.parameterTypes.equals(that.parameterTypes) && this.methodName.equals(that.methodName);
        }

        private MethodInvocation getOuter() {
            return MethodInvocation.this;
        }

        public int hashCode() {
            int result = this.methodName.hashCode();
            result = 31 * result + MethodInvocation.this.hashCode();
            result = 31 * result + this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            result = 31 * result + this.bootstrapMethod.hashCode();
            result = 31 * result + this.arguments.hashCode();
            return result;
        }

        public String toString() {
            return "MethodInvocation.DynamicInvocation{methodInvocation=" + (Object)((Object)MethodInvocation.this) + ", methodName='" + this.methodName + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + ", bootstrapMethod=" + this.bootstrapMethod + ", arguments=" + this.arguments + '}';
        }
    }

    protected class Invocation
    implements WithImplicitInvocationTargetType {
        private final TypeDescription typeDescription;
        private final MethodDescription methodDescription;

        protected Invocation(MethodDescription methodDescription) {
            this(methodDescription, methodDescription.getDeclaringType());
        }

        protected Invocation(MethodDescription methodDescription, TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
            this.methodDescription = methodDescription;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitMethodInsn(MethodInvocation.this.invocationOpcode, this.typeDescription.getInternalName(), this.methodDescription.getInternalName(), this.methodDescription.getDescriptor(), this.typeDescription.isInterface());
            int parameterSize = this.methodDescription.getStackSize();
            int returnValueSize = this.methodDescription.getReturnType().getStackSize().getSize();
            return new StackManipulation.Size(returnValueSize - parameterSize, Math.max(0, returnValueSize - parameterSize));
        }

        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            if (this.methodDescription.isPrivate() || this.methodDescription.isConstructor() || this.methodDescription.isStatic()) {
                return StackManipulation.Illegal.INSTANCE;
            }
            if (invocationTarget.isInterface()) {
                MethodInvocation methodInvocation = INTERFACE;
                ((Object)((Object)methodInvocation)).getClass();
                return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            }
            MethodInvocation methodInvocation = VIRTUAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            StackManipulation stackManipulation;
            if (this.methodDescription.isSpecializableFor(invocationTarget)) {
                MethodInvocation methodInvocation = SPECIAL;
                ((Object)((Object)methodInvocation)).getClass();
                stackManipulation = methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            } else {
                stackManipulation = StackManipulation.Illegal.INSTANCE;
            }
            return stackManipulation;
        }

        @Override
        public StackManipulation dynamic(String methodName, TypeDescription returnType, List<? extends TypeDescription> methodType, List<?> arguments) {
            return this.methodDescription.isBootstrap() ? new DynamicInvocation(methodName, returnType, new TypeList.Explicit(methodType), this.methodDescription, arguments) : StackManipulation.Illegal.INSTANCE;
        }

        private MethodInvocation getOuterInstance() {
            return MethodInvocation.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Invocation that = (Invocation)other;
            return MethodInvocation.this.equals((Object)((Invocation)other).getOuterInstance()) && this.methodDescription.getInternalName().equals(that.methodDescription.getInternalName()) && this.methodDescription.getReturnType().equals(((Invocation)other).methodDescription.getReturnType()) && this.methodDescription.getParameters().asTypeList().equals(((Invocation)other).methodDescription.getParameters().asTypeList()) && this.typeDescription.equals(that.typeDescription);
        }

        public int hashCode() {
            int result = this.typeDescription.hashCode();
            result = 31 * result + MethodInvocation.this.hashCode();
            result = 31 * result + this.methodDescription.getInternalName().hashCode();
            result = 31 * result + this.methodDescription.getParameters().asTypeList().hashCode();
            result = 31 * result + this.methodDescription.getReturnType().hashCode();
            return result;
        }

        public String toString() {
            return "MethodInvocation.Invocation{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + '}';
        }
    }

    public static interface WithImplicitInvocationTargetType
    extends StackManipulation {
        public StackManipulation virtual(TypeDescription var1);

        public StackManipulation special(TypeDescription var1);

        public StackManipulation dynamic(String var1, TypeDescription var2, List<? extends TypeDescription> var3, List<?> var4);
    }

    protected static enum IllegalInvocation implements WithImplicitInvocationTargetType
    {
        INSTANCE;


        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public StackManipulation dynamic(String methodName, TypeDescription returnType, List<? extends TypeDescription> methodType, List<?> arguments) {
            return StackManipulation.Illegal.INSTANCE;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            return StackManipulation.Illegal.INSTANCE.apply(methodVisitor, implementationContext);
        }

        public String toString() {
            return "MethodInvocation.IllegalInvocation." + this.name();
        }
    }
}

