/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.dataforte.cassandra.pool.CassandraHost;
import net.dataforte.cassandra.pool.HostCyclePolicy;
import net.dataforte.cassandra.pool.OffsetArrayList;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.thrift.TException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CassandraRing {
    private HostCyclePolicy policy;
    private Random random = new Random();
    private Map<String, CassandraHost> hosts;

    public CassandraRing(String[] hosts) {
        this(hosts, HostCyclePolicy.RANDOM);
    }

    public CassandraRing(String[] hosts, HostCyclePolicy policy) {
        this.policy = policy;
        this.hosts = this.hostArrayToMap(hosts);
    }

    private Map<String, CassandraHost> hostArrayToMap(String[] hostAddresses) {
        HashMap<String, CassandraHost> hostsMap = new HashMap<String, CassandraHost>();
        for (String hostAddress : hostAddresses) {
            CassandraHost host;
            CassandraHost cassandraHost = host = this.hosts == null ? null : this.hosts.get(hostAddress);
            if (host == null) {
                host = new CassandraHost(hostAddress);
            }
            hostsMap.put(hostAddress, host);
        }
        return hostsMap;
    }

    public synchronized void refresh(Cassandra.Iface connection) throws TException, InvalidRequestException {
        List ks = connection.describe_keyspaces();
        String keyspace = null;
        for (KsDef k : ks) {
            if ("system".equalsIgnoreCase(k.getName())) continue;
            keyspace = k.getName();
            break;
        }
        List ranges = connection.describe_ring(keyspace);
        HashSet addresses = new HashSet();
        for (TokenRange range : ranges) {
            addresses.addAll(range.getEndpoints());
        }
        this.hosts = this.hostArrayToMap(addresses.toArray(new String[0]));
    }

    public List<CassandraHost> getHosts() {
        switch (this.policy) {
            case RANDOM: {
                ArrayList<CassandraHost> list = new ArrayList<CassandraHost>(this.hosts.values());
                Collections.shuffle(list, this.random);
                return list;
            }
        }
        return new OffsetArrayList<CassandraHost>(this.hosts.values(), this.random.nextInt(this.hosts.size()));
    }

    public String toString() {
        return "CassandraRing [policy=" + (Object)((Object)this.policy) + ", activeHosts=" + this.hosts.values() + "]";
    }
}

