/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import net.dataforte.cassandra.pool.DataSourceProxy;
import net.dataforte.cassandra.pool.HostFailoverPolicy;
import net.dataforte.cassandra.pool.PoolConfiguration;
import net.dataforte.cassandra.pool.PoolProperties;
import net.dataforte.cassandra.thrift.CassandraThriftDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSource
extends DataSourceProxy
implements PoolConfiguration,
CassandraThriftDataSource,
MBeanRegistration {
    private static final Logger log = LoggerFactory.getLogger(DataSource.class);
    protected volatile ObjectName oname = null;

    public DataSource() {
        super(new PoolProperties());
    }

    public DataSource(PoolConfiguration poolProperties) {
        super(poolProperties);
    }

    public void postDeregister() {
        if (this.oname != null) {
            this.unregisterJmx();
        }
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        try {
            this.oname = this.createObjectName(name);
            if (this.oname != null) {
                this.registerJmx();
            }
        }
        catch (MalformedObjectNameException x) {
            log.error("Unable to create object name for connection pool.", (Throwable)x);
        }
        return name;
    }

    public ObjectName createObjectName(ObjectName original) throws MalformedObjectNameException {
        String domain = "cassandra.pool";
        Hashtable<String, String> properties = original.getKeyPropertyList();
        String origDomain = original.getDomain();
        properties.put("type", "ConnectionPool");
        properties.put("class", this.getClass().getName());
        if (original.getKeyProperty("path") != null) {
            properties.put("engine", origDomain);
        }
        ObjectName name = new ObjectName(domain, properties);
        return name;
    }

    protected void registerJmx() {
        try {
            if (this.pool.getJmxPool() != null) {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                mbs.registerMBean(this.pool.getJmxPool(), this.oname);
            }
        }
        catch (Exception e) {
            log.error("Unable to register connection pool with JMX", (Throwable)e);
        }
    }

    protected void unregisterJmx() {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            mbs.unregisterMBean(this.oname);
        }
        catch (InstanceNotFoundException ignore) {
        }
        catch (Exception e) {
            log.error("Unable to unregister connection pool with JMX", (Throwable)e);
        }
    }

    public void set(String name, Object value) {
        this.poolProperties.set(name, value);
    }

    public Object get(String name) {
        return this.poolProperties.get(name);
    }

    public void setHost(String host) {
        this.poolProperties.setHost(host);
    }

    public String getHost() {
        return this.poolProperties.getHost();
    }

    public void setPort(int port) {
        this.poolProperties.setPort(port);
    }

    public int getPort() {
        return this.poolProperties.getPort();
    }

    public void setUrl(String url) {
        this.poolProperties.setUrl(url);
    }

    public String getUrl() {
        return this.poolProperties.getUrl();
    }

    public void setFramed(boolean framed) {
        this.poolProperties.setFramed(framed);
    }

    public boolean isFramed() {
        return this.poolProperties.isFramed();
    }

    public void setAutomaticHostDiscovery(boolean autoDiscovery) {
        this.poolProperties.setAutomaticHostDiscovery(autoDiscovery);
    }

    public boolean isAutomaticHostDiscovery() {
        return this.poolProperties.isAutomaticHostDiscovery();
    }

    public void setFailoverPolicy(HostFailoverPolicy failoverPolicy) {
        this.poolProperties.setFailoverPolicy(failoverPolicy);
    }

    public HostFailoverPolicy getFailoverPolicy() {
        return this.poolProperties.getFailoverPolicy();
    }

    public void setAbandonWhenPercentageFull(int percentage) {
        this.poolProperties.setAbandonWhenPercentageFull(percentage);
    }

    public int getAbandonWhenPercentageFull() {
        return this.poolProperties.getAbandonWhenPercentageFull();
    }

    public boolean isFairQueue() {
        return this.poolProperties.isFairQueue();
    }

    public void setFairQueue(boolean fairQueue) {
        this.poolProperties.setFairQueue(fairQueue);
    }

    public int getInitialSize() {
        return this.poolProperties.getInitialSize();
    }

    public void setInitialSize(int initialSize) {
        this.poolProperties.setInitialSize(initialSize);
    }

    public boolean isLogAbandoned() {
        return this.poolProperties.isLogAbandoned();
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.poolProperties.setLogAbandoned(logAbandoned);
    }

    public int getMaxActive() {
        return this.poolProperties.getMaxActive();
    }

    public void setMaxActive(int maxActive) {
        this.poolProperties.setMaxActive(maxActive);
    }

    public int getMaxIdle() {
        return this.poolProperties.getMaxIdle();
    }

    public void setMaxIdle(int maxIdle) {
        this.poolProperties.setMaxIdle(maxIdle);
    }

    public int getMaxWait() {
        return this.poolProperties.getMaxWait();
    }

    public void setMaxWait(int maxWait) {
        this.poolProperties.setMaxWait(maxWait);
    }

    public int getMinEvictableIdleTimeMillis() {
        return this.poolProperties.getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.poolProperties.setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public int getMinIdle() {
        return this.poolProperties.getMinIdle();
    }

    public void setMinIdle(int minIdle) {
        this.poolProperties.setMinIdle(minIdle);
    }

    public String getName() {
        return this.poolProperties.getName();
    }

    public void setName(String name) {
        this.poolProperties.setName(name);
    }

    public int getNumTestsPerEvictionRun() {
        return this.poolProperties.getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.poolProperties.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public String getPassword() {
        return this.poolProperties.getPassword();
    }

    public void setPassword(String password) {
        this.poolProperties.setPassword(password);
    }

    public String getPoolName() {
        return this.poolProperties.getPoolName();
    }

    public String getKeySpace() {
        return this.poolProperties.getKeySpace();
    }

    public void setKeySpace(String keySpace) {
        this.poolProperties.setKeySpace(keySpace);
    }

    public String getUsername() {
        return this.poolProperties.getUsername();
    }

    public void setUsername(String username) {
        this.poolProperties.setUsername(username);
    }

    public boolean isRemoveAbandoned() {
        return this.poolProperties.isRemoveAbandoned();
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.poolProperties.setRemoveAbandoned(removeAbandoned);
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.poolProperties.setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    public int getRemoveAbandonedTimeout() {
        return this.poolProperties.getRemoveAbandonedTimeout();
    }

    public boolean isTestOnBorrow() {
        return this.poolProperties.isTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.poolProperties.setTestOnBorrow(testOnBorrow);
    }

    public boolean isTestOnReturn() {
        return this.poolProperties.isTestOnBorrow();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.poolProperties.setTestOnReturn(testOnReturn);
    }

    public boolean isTestWhileIdle() {
        return this.poolProperties.isTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.poolProperties.setTestWhileIdle(testWhileIdle);
    }

    public int getTimeBetweenEvictionRunsMillis() {
        return this.poolProperties.getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.poolProperties.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public long getValidationInterval() {
        return this.poolProperties.getValidationInterval();
    }

    public void setValidationInterval(long validationInterval) {
        this.poolProperties.setValidationInterval(validationInterval);
    }

    public boolean isTestOnConnect() {
        return this.poolProperties.isTestOnConnect();
    }

    public void setTestOnConnect(boolean testOnConnect) {
        this.poolProperties.setTestOnConnect(testOnConnect);
    }

    public boolean isJmxEnabled() {
        return this.poolProperties.isJmxEnabled();
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.poolProperties.setJmxEnabled(jmxEnabled);
    }

    public boolean isPoolSweeperEnabled() {
        return this.poolProperties.isPoolSweeperEnabled();
    }

    public boolean isUseEquals() {
        return this.poolProperties.isUseEquals();
    }

    public void setUseEquals(boolean useEquals) {
        this.poolProperties.setUseEquals(useEquals);
    }

    public long getMaxAge() {
        return this.poolProperties.getMaxAge();
    }

    public void setMaxAge(long maxAge) {
        this.poolProperties.setMaxAge(maxAge);
    }

    public boolean getUseLock() {
        return this.poolProperties.getUseLock();
    }

    public void setUseLock(boolean useLock) {
        this.poolProperties.setUseLock(useLock);
    }

    public void setSuspectTimeout(int seconds) {
        this.poolProperties.setSuspectTimeout(seconds);
    }

    public int getSuspectTimeout() {
        return this.poolProperties.getSuspectTimeout();
    }

    public int getSocketTimeout() {
        return this.poolProperties.getSocketTimeout();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.poolProperties.setSocketTimeout(socketTimeout);
    }

    public String[] getConfiguredHosts() {
        return this.poolProperties.getConfiguredHosts();
    }

    public long getHostRetryInterval() {
        return this.poolProperties.getHostRetryInterval();
    }

    public void setHostRetryInterval(long hostRetryInterval) {
        this.poolProperties.setHostRetryInterval(hostRetryInterval);
    }

    public void setDataSourceJNDI(String jndiDS) {
        this.poolProperties.setDataSourceJNDI(jndiDS);
    }

    public String getDataSourceJNDI() {
        return this.poolProperties.getDataSourceJNDI();
    }

    public void setDataSource(Object ds) {
        this.poolProperties.setDataSource(ds);
    }

    public Object getDataSource() {
        return this.poolProperties.getDataSource();
    }
}

