/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import net.dataforte.cassandra.pool.DataSource;
import net.dataforte.cassandra.pool.PoolConfiguration;
import net.dataforte.cassandra.pool.PoolProperties;
import net.dataforte.cassandra.thrift.CassandraThriftDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceFactory
implements ObjectFactory {
    private static final Logger log = LoggerFactory.getLogger(DataSourceFactory.class);
    public static final String OBJECT_NAME = "object_name";

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        boolean ok;
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        boolean bl = ok = CassandraThriftDataSource.class.getName().equals(ref.getClassName()) || DataSource.class.getName().equals(ref.getClassName());
        if (!ok) {
            log.warn(ref.getClassName() + " is not a valid class name/type for this JNDI factory.");
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String propertyName : PoolProperties.getPropertyNames()) {
            RefAddr ra = ref.get(propertyName);
            if (ra == null) continue;
            String propertyValue = ra.getContent().toString();
            properties.put(propertyName, propertyValue);
        }
        return this.createDataSource(properties, nameCtx);
    }

    public static PoolConfiguration parsePoolProperties(Map<String, String> properties) throws IOException {
        PoolProperties poolProperties = new PoolProperties();
        for (Map.Entry<String, String> property : properties.entrySet()) {
            poolProperties.set(property.getKey(), property.getValue());
        }
        return poolProperties;
    }

    public CassandraThriftDataSource createDataSource(Map<String, String> properties) throws Exception {
        return this.createDataSource(properties, null);
    }

    public CassandraThriftDataSource createDataSource(Map<String, String> properties, Context context) throws Exception {
        PoolConfiguration poolProperties = DataSourceFactory.parsePoolProperties(properties);
        if (poolProperties.getDataSourceJNDI() != null && poolProperties.getDataSource() == null) {
            this.performJNDILookup(context, poolProperties);
        }
        DataSource dataSource = new DataSource(poolProperties);
        dataSource.createPool();
        return dataSource;
    }

    public void performJNDILookup(Context context, PoolConfiguration poolProperties) {
        Object jndiDS = null;
        try {
            if (context != null) {
                jndiDS = context.lookup(poolProperties.getDataSourceJNDI());
            } else {
                log.warn("dataSourceJNDI property is configued, but local JNDI context is null.");
            }
        }
        catch (NamingException e) {
            log.debug("The name \"" + poolProperties.getDataSourceJNDI() + "\" can not be found in the local context.");
        }
        if (jndiDS == null) {
            try {
                context = new InitialContext();
                jndiDS = context.lookup(poolProperties.getDataSourceJNDI());
            }
            catch (NamingException e) {
                log.warn("The name \"" + poolProperties.getDataSourceJNDI() + "\" can not be found in the InitialContext.");
            }
        }
        if (jndiDS != null) {
            poolProperties.setDataSource(jndiDS);
        }
    }

    protected static Map<String, String> getProperties(String propText) throws IOException {
        return PoolProperties.getProperties(propText, null);
    }
}

