/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import net.dataforte.cassandra.pool.ConnectionPool;
import net.dataforte.cassandra.pool.PoolConfiguration;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceProxy {
    private static final Logger log = LoggerFactory.getLogger(DataSourceProxy.class);
    protected volatile ConnectionPool pool = null;
    protected PoolConfiguration poolProperties = null;

    public DataSourceProxy(PoolConfiguration poolProperties) {
        if (poolProperties == null) {
            throw new NullPointerException("PoolConfiguration can not be null.");
        }
        this.poolProperties = poolProperties;
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public synchronized ConnectionPool createPool() throws TException {
        if (this.pool != null) {
            return this.pool;
        }
        this.pool = new ConnectionPool(this.poolProperties);
        return this.pool;
    }

    public Cassandra.Client getConnection() throws TException {
        if (this.pool == null) {
            return this.createPool().getConnection();
        }
        return this.pool.getConnection();
    }

    public void releaseConnection(Cassandra.Client connection) {
        if (this.pool == null) {
            throw new IllegalStateException("Attempt to release a connection on an uninitialized pool");
        }
        this.pool.release(connection);
    }

    public ConnectionPool getPool() throws TException {
        if (this.pool == null) {
            return this.createPool();
        }
        return this.pool;
    }

    public void close() {
        this.close(false);
    }

    public void close(boolean all) {
        try {
            if (this.pool != null) {
                ConnectionPool p = this.pool;
                this.pool = null;
                if (p != null) {
                    p.close(all);
                }
            }
        }
        catch (Exception x) {
            log.warn("Error closing connection pool.", (Throwable)x);
        }
    }

    public int getPoolSize() throws TException {
        ConnectionPool p = this.pool;
        if (p == null) {
            return 0;
        }
        return p.getSize();
    }

    public String toString() {
        return super.toString() + "{" + this.getPoolProperties() + "}";
    }
}

