/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dataforte.cassandra.pool.HostFailoverPolicy;
import net.dataforte.cassandra.pool.PoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoolProperties
implements PoolConfiguration {
    static final Logger log = LoggerFactory.getLogger(PoolProperties.class);
    static final Pattern URL_PATTERN = Pattern.compile("cassandra:thrift://([\\S&&[^:]]+)(:(\\d{1,5}))?");
    static final int DEFAULT_THRIFT_PORT = 9160;
    protected static AtomicInteger poolCounter = new AtomicInteger(0);
    protected String url;
    protected String host;
    protected String[] configuredHosts;
    protected int port = 9160;
    protected boolean framed = true;
    protected boolean automaticHostDiscovery = false;
    protected HostFailoverPolicy failoverPolicy = HostFailoverPolicy.ON_FAIL_TRY_ALL_AVAILABLE;
    protected int socketTimeout = 5000;
    protected int initialSize = 10;
    protected int maxActive;
    protected int maxIdle = this.maxActive = 100;
    protected int minIdle = this.initialSize;
    protected int maxWait = 30000;
    protected boolean testOnBorrow = false;
    protected boolean testOnReturn = false;
    protected boolean testWhileIdle = false;
    protected int timeBetweenEvictionRunsMillis = 5000;
    protected int numTestsPerEvictionRun;
    protected int minEvictableIdleTimeMillis = 60000;
    protected final boolean accessToUnderlyingConnectionAllowed = true;
    protected boolean removeAbandoned = false;
    protected int removeAbandonedTimeout = 60;
    protected boolean logAbandoned = false;
    protected String name = "Cassandra Connection Pool[" + poolCounter.incrementAndGet() + "-" + System.identityHashCode(PoolProperties.class) + "]";
    protected String keySpace;
    protected String password;
    protected String username;
    protected long validationInterval = 30000L;
    protected long hostRetryInterval = 300000L;
    protected boolean jmxEnabled = true;
    protected boolean testOnConnect = false;
    protected boolean fairQueue = true;
    protected boolean useEquals = true;
    protected int abandonWhenPercentageFull = 0;
    protected long maxAge = 0L;
    protected boolean useLock = false;
    protected int suspectTimeout = 0;
    private String dataSourceJNDI;
    private Object dataSource;
    private static Map<String, PropertyDescriptor> propertyDescriptors = new HashMap<String, PropertyDescriptor>();

    public static Collection<String> getPropertyNames() {
        return propertyDescriptors.keySet();
    }

    @Override
    public void set(String name, Object value) {
        PropertyDescriptor pd = propertyDescriptors.get(name);
        if (pd == null) {
            log.warn("Unknown property: " + name);
            return;
        }
        Method setter = pd.getWriteMethod();
        if (setter == null) {
            log.warn("No write method for: " + name);
            return;
        }
        try {
            Class<?> type = setter.getParameterTypes()[0];
            if (value != null && value instanceof String && type != String.class) {
                String svalue = ((String)value).trim();
                if (Integer.TYPE == type) {
                    setter.invoke((Object)this, Integer.parseInt(svalue));
                    return;
                }
                if (Long.TYPE == type) {
                    setter.invoke((Object)this, Long.parseLong(svalue));
                    return;
                }
                if (Boolean.TYPE == type) {
                    setter.invoke((Object)this, Boolean.parseBoolean(svalue));
                    return;
                }
                if (type.isEnum()) {
                    Class<?> unsafeType = type;
                    setter.invoke((Object)this, Enum.valueOf(unsafeType, svalue));
                    return;
                }
            }
            setter.invoke((Object)this, value);
        }
        catch (Exception e) {
            log.warn("Error setting property: " + name, (Throwable)e);
        }
    }

    @Override
    public Object get(String name) {
        PropertyDescriptor pd = propertyDescriptors.get(name);
        if (pd == null) {
            throw new RuntimeException("Unknown property: " + name);
        }
        Method getter = pd.getReadMethod();
        if (getter == null) {
            throw new RuntimeException("No read method for: " + name);
        }
        try {
            return getter.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setAbandonWhenPercentageFull(int percentage) {
        this.abandonWhenPercentageFull = percentage < 0 ? 0 : (percentage > 100 ? 100 : percentage);
    }

    @Override
    public int getAbandonWhenPercentageFull() {
        return this.abandonWhenPercentageFull;
    }

    @Override
    public boolean isFairQueue() {
        return this.fairQueue;
    }

    @Override
    public void setFairQueue(boolean fairQueue) {
        this.fairQueue = fairQueue;
    }

    @Override
    public boolean isAutomaticHostDiscovery() {
        return this.automaticHostDiscovery;
    }

    @Override
    public void setAutomaticHostDiscovery(boolean automaticHostDiscovery) {
        this.automaticHostDiscovery = automaticHostDiscovery;
    }

    @Override
    public int getInitialSize() {
        return this.initialSize;
    }

    @Override
    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    @Override
    public int getMaxActive() {
        return this.maxActive;
    }

    @Override
    public int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public int getMaxWait() {
        return this.maxWait;
    }

    @Override
    public int getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    @Override
    public int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getPoolName() {
        return this.getName();
    }

    @Override
    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    @Override
    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    @Override
    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    public int getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public long getValidationInterval() {
        return this.validationInterval;
    }

    @Override
    public long getHostRetryInterval() {
        return 0L;
    }

    @Override
    public boolean isTestOnConnect() {
        return this.testOnConnect;
    }

    @Override
    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    @Override
    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    @Override
    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    @Override
    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public void setMinEvictableIdleTimeMillis(int minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    @Override
    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    @Override
    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    @Override
    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    @Override
    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    @Override
    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    @Override
    public void setTimeBetweenEvictionRunsMillis(int timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    @Override
    public String getKeySpace() {
        return this.keySpace;
    }

    @Override
    public void setKeySpace(String keySpace) {
        this.keySpace = keySpace;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public void setValidationInterval(long validationInterval) {
        this.validationInterval = validationInterval;
    }

    @Override
    public void setTestOnConnect(boolean testOnConnect) {
        this.testOnConnect = testOnConnect;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("ConnectionPool[]");
        return buf.toString();
    }

    public static int getPoolCounter() {
        return poolCounter.get();
    }

    @Override
    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    @Override
    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    @Override
    public int getSuspectTimeout() {
        return this.suspectTimeout;
    }

    @Override
    public void setSuspectTimeout(int seconds) {
        this.suspectTimeout = seconds;
    }

    @Override
    public boolean isPoolSweeperEnabled() {
        boolean timer = this.getTimeBetweenEvictionRunsMillis() > 0;
        boolean result = timer && this.isRemoveAbandoned() && this.getRemoveAbandonedTimeout() > 0;
        result = result || timer && this.getSuspectTimeout() > 0;
        result = result || timer && this.isTestWhileIdle();
        result = result || timer && this.getMinEvictableIdleTimeMillis() > 0;
        result = result || timer && this.isAutomaticHostDiscovery();
        return result;
    }

    @Override
    public boolean isUseEquals() {
        return this.useEquals;
    }

    @Override
    public void setUseEquals(boolean useEquals) {
        this.useEquals = useEquals;
    }

    @Override
    public long getMaxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public boolean getUseLock() {
        return this.useLock;
    }

    @Override
    public void setUseLock(boolean useLock) {
        this.useLock = useLock;
    }

    public static Map<String, String> getProperties(String propText, Map<String, String> props) {
        if (props == null) {
            props = new HashMap<String, String>();
        }
        if (propText != null) {
            try {
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes()));
                props.clear();
                for (Map.Entry<String, String> s : props.entrySet()) {
                    props.put(s.getKey(), s.getValue());
                }
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }
        return props;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        String[] hs = this.host.split(",");
        this.configuredHosts = new String[hs.length];
        for (int i = 0; i < hs.length; ++i) {
            this.configuredHosts[i] = hs[i].trim();
        }
    }

    @Override
    public String getHost() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.configuredHosts.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.configuredHosts[i]);
        }
        return sb.toString();
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        Matcher matcher = URL_PATTERN.matcher(url);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The specified url '" + url + "' is not valid");
        }
        this.url = url;
        this.setHost(matcher.group(1));
        String p = matcher.group(3);
        this.setPort(p == null ? 9160 : Integer.parseInt(p));
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setFramed(boolean framed) {
        this.framed = framed;
    }

    @Override
    public boolean isFramed() {
        return this.framed;
    }

    @Override
    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    @Override
    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    @Override
    public String[] getConfiguredHosts() {
        return this.configuredHosts;
    }

    @Override
    public void setHostRetryInterval(long hostRetryInterval) {
        this.hostRetryInterval = hostRetryInterval;
    }

    @Override
    public void setFailoverPolicy(HostFailoverPolicy failoverPolicy) {
        this.failoverPolicy = failoverPolicy;
    }

    @Override
    public HostFailoverPolicy getFailoverPolicy() {
        return this.failoverPolicy;
    }

    @Override
    public void setDataSourceJNDI(String jndiDS) {
        this.dataSourceJNDI = jndiDS;
    }

    @Override
    public String getDataSourceJNDI() {
        return this.dataSourceJNDI;
    }

    @Override
    public void setDataSource(Object ds) {
        this.dataSource = ds;
    }

    @Override
    public Object getDataSource() {
        return this.dataSource;
    }

    static {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(PoolProperties.class);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                propertyDescriptors.put(pd.getName(), pd);
            }
            propertyDescriptors = Collections.unmodifiableMap(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Could not introspect PoolProperties", e);
        }
    }

    public static class InterceptorProperty {
        String name;
        String value;

        public InterceptorProperty(String name, String value) {
            assert (name != null);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean getValueAsBoolean(boolean def) {
            if (this.value == null) {
                return def;
            }
            if ("true".equals(this.value)) {
                return true;
            }
            if ("false".equals(this.value)) {
                return false;
            }
            return def;
        }

        public int getValueAsInt(int def) {
            if (this.value == null) {
                return def;
            }
            try {
                int v = Integer.parseInt(this.value);
                return v;
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public long getValueAsLong(long def) {
            if (this.value == null) {
                return def;
            }
            try {
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public byte getValueAsByte(byte def) {
            if (this.value == null) {
                return def;
            }
            try {
                return Byte.parseByte(this.value);
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public short getValueAsShort(short def) {
            if (this.value == null) {
                return def;
            }
            try {
                return Short.parseShort(this.value);
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public float getValueAsFloat(float def) {
            if (this.value == null) {
                return def;
            }
            try {
                return Float.parseFloat(this.value);
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public double getValueAsDouble(double def) {
            if (this.value == null) {
                return def;
            }
            try {
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException nfe) {
                return def;
            }
        }

        public char getValueAschar(char def) {
            if (this.value == null) {
                return def;
            }
            try {
                return this.value.charAt(0);
            }
            catch (StringIndexOutOfBoundsException nfe) {
                return def;
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof InterceptorProperty) {
                InterceptorProperty other = (InterceptorProperty)o;
                return other.name.equals(this.name);
            }
            return false;
        }
    }
}

