/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.dataforte.cassandra.pool.CassandraHost;
import net.dataforte.cassandra.pool.ConnectionPool;
import net.dataforte.cassandra.pool.PoolConfiguration;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.AuthenticationRequest;
import org.apache.cassandra.thrift.AuthorizationException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFastFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PooledConnection {
    private static final Logger log = LoggerFactory.getLogger(PooledConnection.class);
    protected static AtomicInteger counter = new AtomicInteger(1);
    public static final int VALIDATE_BORROW = 1;
    public static final int VALIDATE_RETURN = 2;
    public static final int VALIDATE_IDLE = 3;
    public static final int VALIDATE_INIT = 4;
    protected PoolConfiguration poolProperties;
    private volatile Cassandra.Client connection;
    private volatile TTransport transport;
    private String abandonTrace = null;
    private volatile long timestamp;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
    private volatile boolean discarded = false;
    private volatile long lastConnected = -1L;
    private volatile long lastValidated = System.currentTimeMillis();
    private int instanceCount = 0;
    protected ConnectionPool parent;
    private HashMap<Object, Object> attributes = new HashMap();
    private AtomicBoolean released = new AtomicBoolean(false);
    private volatile boolean suspect = false;

    public PooledConnection(PoolConfiguration prop, ConnectionPool parent) {
        this.instanceCount = counter.addAndGet(1);
        this.poolProperties = prop;
        this.parent = parent;
    }

    public void connect() throws TException {
        if (this.released.get()) {
            throw new TException("[" + this.parent.getName() + "] A connection once released, can't be reestablished.");
        }
        if (this.connection != null) {
            try {
                this.disconnect(false);
            }
            catch (Exception x) {
                log.debug("[" + this.parent.getName() + "] Unable to disconnect previous connection.", (Throwable)x);
            }
        }
        List<CassandraHost> hosts = this.parent.getCassandraRing().getHosts();
        Iterator<CassandraHost> hostIterator = hosts.iterator();
        int tried = 0;
        CassandraHost host = null;
        this.transport = null;
        while (this.transport == null) {
            if (tried > this.poolProperties.getFailoverPolicy().numRetries || !hostIterator.hasNext()) {
                throw new TException("[" + this.parent.getName() + "] Could not connect to any hosts");
            }
            host = hostIterator.next();
            if (!host.isGood() && host.getLastUsed() + this.poolProperties.getHostRetryInterval() >= System.currentTimeMillis()) continue;
            try {
                TSocket socket = new TSocket(host.getHost(), this.poolProperties.getPort(), this.poolProperties.getSocketTimeout());
                this.transport = this.poolProperties.isFramed() ? new TFastFramedTransport((TTransport)socket) : socket;
                host.timestamp();
                this.transport.open();
                host.setGood(true);
            }
            catch (TTransportException tte) {
                host.timestamp();
                host.setGood(false);
                log.warn("[" + this.parent.getName() + "] Failed connection to " + host);
                this.transport = null;
                ++tried;
            }
        }
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.connection = new Cassandra.Client((TProtocol)protocol);
        if (this.poolProperties.getUsername() != null) {
            AuthenticationRequest authenticationRequest = new AuthenticationRequest();
            authenticationRequest.putToCredentials("username", this.poolProperties.getUsername());
            authenticationRequest.putToCredentials("password", this.poolProperties.getPassword());
            try {
                this.connection.login(authenticationRequest);
            }
            catch (AuthenticationException e) {
                this.disconnect(false);
                throw new TException((Throwable)e);
            }
            catch (AuthorizationException e) {
                this.disconnect(false);
                throw new TException((Throwable)e);
            }
        }
        if (this.poolProperties.getKeySpace() != null) {
            try {
                this.connection.set_keyspace(this.poolProperties.getKeySpace());
            }
            catch (InvalidRequestException e) {
                this.disconnect(false);
                throw new TException((Throwable)e);
            }
        }
        this.discarded = false;
        this.lastConnected = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug("[" + this.parent.getName() + "] Obtained a new connection to " + host);
        }
    }

    public boolean isInitialized() {
        return this.connection != null;
    }

    public void reconnect() throws TException, AuthenticationException, AuthorizationException, InvalidRequestException {
        this.disconnect(false);
        this.connect();
    }

    private void disconnect(boolean finalize) {
        block5: {
            if (this.isDiscarded()) {
                return;
            }
            this.setDiscarded(true);
            if (this.connection != null) {
                try {
                    this.parent.disconnectEvent(this, finalize);
                    this.transport.close();
                }
                catch (Exception ignore) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("[" + this.parent.getName() + "] Unable to close underlying Thrift connection", (Throwable)ignore);
                }
            }
        }
        this.connection = null;
        this.transport = null;
        this.lastConnected = -1L;
        if (finalize) {
            this.parent.finalize(this);
        }
    }

    public long getAbandonTimeout() {
        if (this.poolProperties.getRemoveAbandonedTimeout() <= 0) {
            return Long.MAX_VALUE;
        }
        return this.poolProperties.getRemoveAbandonedTimeout() * 1000;
    }

    private boolean doValidate(int action) {
        if (action == 1 && this.poolProperties.isTestOnBorrow()) {
            return true;
        }
        if (action == 2 && this.poolProperties.isTestOnReturn()) {
            return true;
        }
        if (action == 3 && this.poolProperties.isTestWhileIdle()) {
            return true;
        }
        return action == 4 && this.poolProperties.isTestOnConnect();
    }

    public boolean validate(int validateAction) {
        if (this.isDiscarded()) {
            return false;
        }
        if (!this.doValidate(validateAction)) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (validateAction != 4 && this.poolProperties.getValidationInterval() > 0L && now - this.lastValidated < this.poolProperties.getValidationInterval()) {
            return true;
        }
        try {
            if (this.parent.getPoolProperties().isAutomaticHostDiscovery()) {
                this.parent.getCassandraRing().refresh((Cassandra.Iface)this.connection);
            } else {
                String cluster_name = this.connection.describe_cluster_name();
                if (log.isTraceEnabled()) {
                    log.trace("[" + this.parent.getName() + "] Validated connection " + this.toString() + ", cluster name = " + cluster_name);
                }
            }
            this.lastValidated = now;
            return true;
        }
        catch (Exception ignore) {
            if (log.isDebugEnabled()) {
                log.debug("[" + this.parent.getName() + "] Unable to validate object:", (Throwable)ignore);
            }
            return false;
        }
    }

    public long getReleaseTime() {
        return this.poolProperties.getMinEvictableIdleTimeMillis();
    }

    public boolean release() {
        block2: {
            try {
                this.disconnect(true);
            }
            catch (Exception x) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("[" + this.parent.getName() + "] Unable to close Thrift connection", (Throwable)x);
            }
        }
        return this.released.compareAndSet(false, true);
    }

    public void setStackTrace(String trace) {
        this.abandonTrace = trace;
    }

    public String getStackTrace() {
        return this.abandonTrace;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
        this.setSuspect(false);
    }

    public boolean isSuspect() {
        return this.suspect;
    }

    public void setSuspect(boolean suspect) {
        this.suspect = suspect;
    }

    public void setDiscarded(boolean discarded) {
        if (this.discarded && !discarded) {
            throw new IllegalStateException("[" + this.parent.getName() + "] Unable to change the state once the connection has been discarded");
        }
        this.discarded = discarded;
    }

    public void setLastValidated(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    public void setPoolProperties(PoolConfiguration poolProperties) {
        this.poolProperties = poolProperties;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public PoolConfiguration getPoolProperties() {
        return this.poolProperties;
    }

    public void lock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().lock();
        }
    }

    public void unlock() {
        if (this.poolProperties.getUseLock() || this.poolProperties.isPoolSweeperEnabled()) {
            this.lock.writeLock().unlock();
        }
    }

    public Cassandra.Client getConnection() {
        return this.connection;
    }

    public TTransport getTransport() {
        return this.transport;
    }

    public long getLastConnected() {
        return this.lastConnected;
    }

    public String toString() {
        return "PooledConnection[instance=" + this.instanceCount + "," + (this.connection != null ? this.connection.toString() : "null") + "]";
    }

    public boolean isReleased() {
        return this.released.get();
    }

    public HashMap<Object, Object> getAttributes() {
        return this.attributes;
    }
}

