/*
 * Decompiled with CFR 0.152.
 */
package net.dataforte.cassandra.pool.jmx;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import net.dataforte.cassandra.pool.ConnectionPool;
import net.dataforte.cassandra.pool.PoolConfiguration;
import net.dataforte.cassandra.pool.PoolProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPoolMBean
extends NotificationBroadcasterSupport
implements DynamicMBean {
    private static final Logger log = LoggerFactory.getLogger(ConnectionPoolMBean.class);
    protected ConnectionPool pool = null;
    protected AtomicInteger sequence = new AtomicInteger(0);
    protected ConcurrentLinkedQueue<NotificationListener> listeners = new ConcurrentLinkedQueue();
    public static final String NOTIFY_INIT = "INIT FAILED";
    public static final String NOTIFY_CONNECT = "CONNECTION FAILED";
    public static final String NOTIFY_ABANDON = "CONNECTION ABANDONED";
    public static final String SUSPECT_ABANDONED_NOTIFICATION = "SUSPECT CONNECTION ABANDONED";

    public ConnectionPoolMBean(ConnectionPool pool) {
        this.pool = pool;
    }

    public ConnectionPool getPool() {
        return this.pool;
    }

    public PoolConfiguration getPoolProperties() {
        return this.pool.getPoolProperties();
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (log.isDebugEnabled()) {
            log.debug("Invoking {}", (Object)actionName);
        }
        return null;
    }

    public MBeanInfo getMBeanInfo() {
        String[] ops;
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(PoolProperties.class);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                if ("password".equals(pd.getName()) || "class".equals(pd.getName())) continue;
                attributes.add(new MBeanAttributeInfo(pd.getName(), pd.getPropertyType().getName(), pd.getDisplayName(), true, true, false));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        attributes.add(new MBeanAttributeInfo("size", "int", "size", true, false, false));
        attributes.add(new MBeanAttributeInfo("active", "int", "active", true, false, false));
        attributes.add(new MBeanAttributeInfo("idle", "int", "idle", true, false, false));
        attributes.add(new MBeanAttributeInfo("waitCount", "int", "waitCount", true, false, false));
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (String op : ops = new String[]{"checkIdle", "checkAbandoned", "testIdle"}) {
            try {
                operations.add(new MBeanOperationInfo(op, this.getClass().getMethod(op, null)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new MBeanInfo(this.getClass().getName(), "Cassandra Connection Pool", attributes.toArray(new MBeanAttributeInfo[0]), null, operations.toArray(new MBeanOperationInfo[0]), null);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException {
        this.pool.getPoolProperties().set(attribute.getName(), attribute.getValue());
    }

    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(attribute);
                list.add(attribute);
            }
            catch (Exception e) {}
        }
        return list;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException {
        if ("size".equals(attribute)) {
            return this.pool.getSize();
        }
        if ("active".equals(attribute)) {
            return this.pool.getActive();
        }
        if ("idle".equals(attribute)) {
            return this.pool.getIdle();
        }
        if ("waitCount".equals(attribute)) {
            return this.pool.getWaitCount();
        }
        return this.pool.getPoolProperties().get(attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        AttributeList list = new AttributeList();
        for (String attribute : attributes) {
            try {
                list.add(new Attribute(attribute, this.getAttribute(attribute)));
            }
            catch (Exception e) {
                log.error("Error while adding attribute " + attribute, (Throwable)e);
            }
        }
        return list;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] pres = super.getNotificationInfo();
        MBeanNotificationInfo[] loc = ConnectionPoolMBean.getDefaultNotificationInfo();
        MBeanNotificationInfo[] aug = new MBeanNotificationInfo[pres.length + loc.length];
        if (pres.length > 0) {
            System.arraycopy(pres, 0, aug, 0, pres.length);
        }
        if (loc.length > 0) {
            System.arraycopy(loc, 0, aug, pres.length, loc.length);
        }
        return aug;
    }

    public static MBeanNotificationInfo[] getDefaultNotificationInfo() {
        String[] types = new String[]{NOTIFY_INIT, NOTIFY_CONNECT, NOTIFY_ABANDON, SUSPECT_ABANDONED_NOTIFICATION};
        String name = Notification.class.getName();
        String description = "A connection pool error condition was met.";
        MBeanNotificationInfo info = new MBeanNotificationInfo(types, name, description);
        return new MBeanNotificationInfo[]{info};
    }

    public boolean notify(String type, String message) {
        try {
            Notification n = new Notification(type, this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "[" + type + "] " + message);
            this.sendNotification(n);
            for (NotificationListener listener : this.listeners) {
                listener.handleNotification(n, this);
            }
            return true;
        }
        catch (Exception x) {
            if (log.isDebugEnabled()) {
                log.debug("Notify failed. Type=" + type + "; Message=" + message, (Throwable)x);
            }
            return false;
        }
    }

    public void addListener(NotificationListener list) {
        this.listeners.add(list);
    }

    public boolean removeListener(NotificationListener list) {
        return this.listeners.remove(list);
    }

    public void checkIdle() {
        this.pool.checkIdle();
    }

    public void checkAbandoned() {
        this.pool.checkAbandoned();
    }

    public void testIdle() {
        this.pool.testAllIdle();
    }
}

