/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.dharwin.common.tools.cli.api.CommandLineApplication;
import net.dharwin.common.tools.cli.api.console.Console;

public class CLIContext {
    private Map<String, Object> _properties = new HashMap<String, Object>();
    private CommandLineApplication<? extends CLIContext> _app;

    public CLIContext(CommandLineApplication<? extends CLIContext> app) {
        this._app = app;
        this.loadProperties(this.getEmbeddedPropertiesFilename());
        this.loadProperties(this.getExternalPropertiesFile());
    }

    public CommandLineApplication<? extends CLIContext> getHostApplication() {
        return this._app;
    }

    private void loadProperties(String propFileName) {
        this.loadProperties(this.getClass().getResourceAsStream(propFileName), propFileName);
    }

    private void loadProperties(File propFile) {
        if (propFile == null) {
            return;
        }
        try {
            this.loadProperties(new FileInputStream(propFile), propFile.getAbsolutePath());
        }
        catch (FileNotFoundException e) {
            Console.warn("Unable to find properties file [" + propFile.getAbsolutePath() + "].");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(InputStream stream, String path) {
        if (stream == null) {
            return;
        }
        try {
            Properties props = new Properties();
            props.load(stream);
            Iterator<Object> keyIt = props.keySet().iterator();
            while (keyIt.hasNext()) {
                String key = keyIt.next().toString();
                this._properties.put(key, props.get(key));
            }
        }
        catch (Exception e) {
            Console.warn("Unable to load properties file [" + path + "].");
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    Console.warn("Unable to close properties file [" + path + "].");
                }
            }
        }
    }

    protected String getEmbeddedPropertiesFilename() {
        return null;
    }

    protected File getExternalPropertiesFile() {
        return null;
    }

    public Object put(String key, Object o) {
        return this._properties.put(key, o);
    }

    public Object getObject(String key) {
        return this._properties.get(key);
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            return defaultValue;
        }
        if (!(o instanceof String)) {
            throw new IllegalArgumentException("Object [" + o + "] associated with key [" + key + "] is not of type String.");
        }
        return (String)o;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            return defaultValue;
        }
        boolean b = defaultValue;
        try {
            b = Boolean.parseBoolean(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Object [" + o + "] associated with key [" + key + "] is not of type Boolean.");
        }
        return b;
    }

    public int getInteger(String key) {
        return this.getInteger(key, -1);
    }

    public int getInteger(String key, int defaultValue) {
        Object o = this.getObject(key);
        if (o == null) {
            return defaultValue;
        }
        int val = defaultValue;
        try {
            val = Integer.parseInt(o.toString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Object [" + o + "] associated with key [" + key + "] is not of type Integer.");
        }
        return val;
    }

    public boolean containsKey(String key) {
        return this._properties.containsKey(key);
    }
}

