/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api;

import com.beust.jcommander.JCommander;
import net.dharwin.common.tools.cli.api.CLIContext;
import net.dharwin.common.tools.cli.api.CommandResult;
import net.dharwin.common.tools.cli.api.annotations.CLICommand;
import net.dharwin.common.tools.cli.api.console.Console;

public abstract class Command<T extends CLIContext> {
    public CommandResult execute(T context) {
        try {
            return this.innerExecute(context);
        }
        catch (Exception e) {
            Console.error(e.getMessage());
            return CommandResult.ERROR;
        }
    }

    public void usage() {
        CLICommand commandAnnotation = this.getClass().getAnnotation(CLICommand.class);
        Console.info("Help for [" + commandAnnotation.name() + "].");
        String description = commandAnnotation.description();
        if (description != null && !description.isEmpty()) {
            Console.info("Description: " + description);
        }
        JCommander comm = new JCommander((Object)this);
        comm.setProgramName(commandAnnotation.name());
        comm.usage();
    }

    protected abstract CommandResult innerExecute(T var1);
}

