/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.impetus.annovention.ClasspathDiscoverer;
import com.impetus.annovention.listener.ClassAnnotationDiscoveryListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import net.dharwin.common.tools.cli.api.CLIContext;
import net.dharwin.common.tools.cli.api.Command;
import net.dharwin.common.tools.cli.api.CommandLineParser;
import net.dharwin.common.tools.cli.api.CommandLineParserImpl;
import net.dharwin.common.tools.cli.api.CommandResult;
import net.dharwin.common.tools.cli.api.StringUtils;
import net.dharwin.common.tools.cli.api.annotations.CLICommand;
import net.dharwin.common.tools.cli.api.console.Console;
import net.dharwin.common.tools.cli.api.exceptions.CLIInitException;
import net.dharwin.common.tools.cli.api.exceptions.CommandInitException;
import net.dharwin.common.tools.cli.api.utils.CLIAnnotationDiscovereryListener;

public abstract class CommandLineApplication<T extends CLIContext> {
    private static final String DEFAULT_LOG_LEVEL_KEY = "default_log_level";
    private static final String PRINT_LOG_LEVEL_KEY = "print_log_levels";
    protected Map<String, Class<? extends Command<? extends CLIContext>>> _commands = this.loadCommands();
    protected CLIContext _appContext = this.createContext();
    private CommandLineParser _clParser = new CommandLineParserImpl();

    public void start() {
        this.setDefaultLogLevel();
        if (Boolean.getBoolean("jlineDisable")) {
            Scanner scan = new Scanner(System.in);
            while (true) {
                System.out.print(">");
                String nextLine = scan.nextLine();
                this.processInputLine(nextLine);
            }
        }
        try {
            ConsoleReader reader = new ConsoleReader();
            reader.setBellEnabled(this._appContext.getBoolean("cliapi.bellenabled", false));
            reader.addCompletor((Completor)new SimpleCompletor(this.getCommandNames().toArray(new String[0])));
            while (true) {
                String nextLine = reader.readLine(">");
                this.processInputLine(nextLine);
            }
        }
        catch (IOException e) {
            System.err.println("Error reading from input.");
            e.printStackTrace();
            return;
        }
    }

    protected void processInputLine(String inputLine) {
        String[] rawArgs = this._clParser.parse(inputLine);
        if (rawArgs.length == 0) {
            return;
        }
        String commandName = rawArgs[0];
        Command<CLIContext> command = null;
        try {
            command = this.findAndCreateCommand(commandName.toLowerCase());
        }
        catch (CommandInitException e) {
            Console.error("Unable to init command [" + e.getCommandName() + "].");
            return;
        }
        if (command == null) {
            Console.error("Command not recognized: " + commandName);
            return;
        }
        if (rawArgs.length == 2 && rawArgs[1].equalsIgnoreCase("--help")) {
            command.usage();
            return;
        }
        JCommander commander = new JCommander(command);
        try {
            commander.parse(StringUtils.stripArgs(rawArgs, 1));
        }
        catch (ParameterException e) {
            Console.error("Arguments cannot be parsed: " + e.getMessage());
            command.usage();
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Console.error("Error parsing arguments: Did you specify a value after providing an option?");
            command.usage();
            return;
        }
        catch (Exception e) {
            Console.error("Unknown error while parsing arguments: " + e.getMessage());
            return;
        }
        CommandResult result = command.execute(this._appContext);
        if (result.getStatusCode() != 0) {
            Console.error("Command returned type [" + result.getType().name() + "] with status code [" + result.getStatusCode() + "].");
        }
        if (result.getType() == CommandResult.CommandResultType.EXIT) {
            this.shutdown();
            System.exit(0);
        }
    }

    protected Command<? extends CLIContext> findAndCreateCommand(String commandName) throws CommandInitException {
        Class<? extends Command<? extends CLIContext>> commandClass = this._commands.get(commandName);
        if (commandClass == null) {
            return null;
        }
        try {
            return commandClass.newInstance();
        }
        catch (Exception e) {
            throw new CommandInitException(commandName);
        }
    }

    protected void setDefaultLogLevel() {
        String defaultLogLevel = this._appContext.getString(DEFAULT_LOG_LEVEL_KEY);
        if (defaultLogLevel != null) {
            try {
                Console.ConsoleLevel l = Console.ConsoleLevel.valueOf(defaultLogLevel);
                Console.setLevel(l);
            }
            catch (IllegalArgumentException e) {
                Console.error("Unknown default log level [" + defaultLogLevel + "].");
            }
        }
        if (this._appContext.containsKey(PRINT_LOG_LEVEL_KEY)) {
            Console.setPrintLogLevel(this._appContext.getBoolean(PRINT_LOG_LEVEL_KEY));
        }
    }

    private Map<String, Class<? extends Command<? extends CLIContext>>> loadCommands() throws CLIInitException {
        HashMap<String, Class<? extends Command<? extends CLIContext>>> commands = new HashMap<String, Class<? extends Command<? extends CLIContext>>>();
        ClasspathDiscoverer discoverer = new ClasspathDiscoverer();
        CLIAnnotationDiscovereryListener discoveryListener = new CLIAnnotationDiscovereryListener(new String[]{CLICommand.class.getName()});
        discoverer.addAnnotationListener((ClassAnnotationDiscoveryListener)discoveryListener);
        discoverer.discover();
        this.loadCommands(commands, discoveryListener.getDiscoveredClasses());
        if (commands.isEmpty()) {
            throw new CLIInitException("No commands could be loaded.");
        }
        return commands;
    }

    private void loadCommands(Map<String, Class<? extends Command<? extends CLIContext>>> out, List<String> commandClasses) throws CLIInitException {
        for (String commandClassName : commandClasses) {
            try {
                Class<?> commandClass = Class.forName(commandClassName);
                if (!Command.class.isAssignableFrom(commandClass)) {
                    Console.severe("Command class [" + commandClassName + "] is not of type Command.");
                    throw new CLIInitException("Command class [" + commandClassName + "] is not of type Command.");
                }
                CLICommand annotation = commandClass.getAnnotation(CLICommand.class);
                out.put(annotation.name().toLowerCase(), commandClass);
                Console.superFine("Loaded command [" + annotation.name() + "].");
            }
            catch (ClassNotFoundException e) {
                throw new CLIInitException("Unable to find command class [" + commandClassName + "].");
            }
            catch (Exception e) {
                throw new CLIInitException("Unable to load command class [" + commandClassName + "]: " + e.getMessage());
            }
        }
    }

    protected CLIContext createContext() {
        return new CLIContext(this);
    }

    public Set<String> getCommandNames() {
        return this._commands.keySet();
    }

    public Map<String, Class<? extends Command<? extends CLIContext>>> getCommands() {
        return this._commands;
    }

    protected abstract void shutdown();
}

