/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api;

import com.impetus.annovention.ClasspathDiscoverer;
import com.impetus.annovention.listener.ClassAnnotationDiscoveryListener;
import java.lang.reflect.Constructor;
import net.dharwin.common.tools.cli.api.CommandLineApplication;
import net.dharwin.common.tools.cli.api.annotations.CLIEntry;
import net.dharwin.common.tools.cli.api.console.Console;
import net.dharwin.common.tools.cli.api.utils.CLIAnnotationDiscovereryListener;

public class EntryPoint {
    public static void main(String[] args) {
        ClasspathDiscoverer discoverer = new ClasspathDiscoverer();
        CLIAnnotationDiscovereryListener discoveryListener = new CLIAnnotationDiscovereryListener(new String[]{CLIEntry.class.getName()});
        discoverer.addAnnotationListener((ClassAnnotationDiscoveryListener)discoveryListener);
        discoverer.discover();
        if (discoveryListener.getDiscoveredClasses().isEmpty()) {
            Console.severe("Startup failed: Could not find CLIEntry.");
            System.exit(1);
        }
        String cliEntryClassName = discoveryListener.getDiscoveredClasses().get(0);
        Console.superFine("Loading CLIEntry [" + cliEntryClassName + "].");
        try {
            Class<?> cliEntryClass = Class.forName(cliEntryClassName);
            if (!CommandLineApplication.class.isAssignableFrom(cliEntryClass)) {
                Console.severe("CLIEntry [" + cliEntryClassName + "] is not of type CommandLineApplication.");
                System.exit(1);
            }
            Constructor<?> constructor = cliEntryClass.getConstructor(new Class[0]);
            CommandLineApplication cla = (CommandLineApplication)constructor.newInstance(new Object[0]);
            cla.start();
        }
        catch (ClassNotFoundException e) {
            Console.severe("Unable to find CLIEntry class [" + cliEntryClassName + "].");
            System.exit(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

