/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api.console;

import java.io.PrintStream;

public class Console {
    private static ConsoleLevel _level = ConsoleLevel.INFO;
    private static boolean _printLogLevel = false;

    public static void setPrintLogLevel(boolean print) {
        _printLogLevel = print;
    }

    public static void setLevel(ConsoleLevel level) {
        _level = level;
    }

    public static void print(ConsoleLevel level, String message) {
        if (level.compareTo(_level) <= 0) {
            if (_printLogLevel) {
                level.getStream().println(level.name() + ": " + message);
            } else {
                level.getStream().println(message);
            }
            level.getStream().flush();
        }
    }

    public static void severe(String message) {
        Console.print(ConsoleLevel.SEVERE, message);
    }

    public static void error(String message) {
        Console.print(ConsoleLevel.ERROR, message);
    }

    public static void warn(String message) {
        Console.print(ConsoleLevel.WARN, message);
    }

    public static void info(String message) {
        Console.print(ConsoleLevel.INFO, message);
    }

    public static void debug(String message) {
        Console.print(ConsoleLevel.DEBUG, message);
    }

    public static void superFine(String message) {
        Console.print(ConsoleLevel.SUPERFINE, message);
    }

    public static enum ConsoleLevel {
        SEVERE(System.err),
        ERROR(System.err),
        WARN(System.out),
        INFO(System.out),
        DEBUG(System.out),
        SUPERFINE(System.out);

        private PrintStream _stream;

        private ConsoleLevel(PrintStream stream) {
            this._stream = stream;
        }

        public PrintStream getStream() {
            return this._stream;
        }
    }
}

