/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api.defaultcommands;

import com.beust.jcommander.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import net.dharwin.common.tools.cli.api.CLIContext;
import net.dharwin.common.tools.cli.api.Command;
import net.dharwin.common.tools.cli.api.CommandResult;
import net.dharwin.common.tools.cli.api.annotations.CLICommand;
import net.dharwin.common.tools.cli.api.console.Console;
import net.dharwin.common.tools.cli.api.utils.CommandUtils;

@CLICommand(name="help", description="Prints known commands and usage.")
public class HelpCommand
extends Command<CLIContext> {
    @Parameter(names={"-c", "--command"}, description="The command name to get specific help for.")
    private String _commandName;

    @Override
    public CommandResult innerExecute(CLIContext context) {
        if (this._commandName == null) {
            Set<String> knownCommandsSet = context.getHostApplication().getCommandNames();
            ArrayList<String> knownCommands = new ArrayList<String>(knownCommandsSet);
            Collections.sort(knownCommands);
            HashMap<String, String> commandHelpMap = new HashMap<String, String>();
            int longestCommandName = 0;
            int longestDescription = 0;
            for (String commandName : knownCommands) {
                Class<? extends Command<? extends CLIContext>> c;
                String description;
                if (commandName.length() > longestCommandName) {
                    longestCommandName = commandName.length();
                }
                if ((description = (c = CommandUtils.getCommandClass(context, commandName)).getAnnotation(CLICommand.class).description()).length() > longestDescription) {
                    longestDescription = description.length();
                }
                commandHelpMap.put(commandName, description);
            }
            Console.info("Known commands:");
            for (String command : knownCommands) {
                String desc = (String)commandHelpMap.get(command);
                if (desc == null) {
                    desc = "";
                }
                Console.info(String.format(this.getOutputString(command, desc, longestCommandName, longestDescription), command, desc));
            }
        } else {
            Command<? extends CLIContext> command = null;
            try {
                Class<? extends Command<? extends CLIContext>> commandClass = CommandUtils.getCommandClass(context, this._commandName);
                if (commandClass == null) {
                    Console.error("Command [" + this._commandName + "] not recognized.");
                    return CommandResult.BAD_ARGS;
                }
                command = commandClass.newInstance();
            }
            catch (Exception e) {
                Console.error("Error loading command help for [" + this._commandName + "].");
                return CommandResult.ERROR;
            }
            command.usage();
        }
        return CommandResult.OK;
    }

    private String getOutputString(String commandName, String description, int nameColWidth, int descColWidth) {
        return "%1$-" + nameColWidth + "s\t:\t%2$-" + descColWidth + "s";
    }
}

