/*
 * Decompiled with CFR 0.152.
 */
package net.dharwin.common.tools.cli.api.defaultcommands;

import com.beust.jcommander.Parameter;
import net.dharwin.common.tools.cli.api.CLIContext;
import net.dharwin.common.tools.cli.api.Command;
import net.dharwin.common.tools.cli.api.CommandResult;
import net.dharwin.common.tools.cli.api.annotations.CLICommand;
import net.dharwin.common.tools.cli.api.console.Console;

@CLICommand(name="loglevel", description="Sets the logging level threshold.")
public class SetLogLevelCommand
extends Command<CLIContext> {
    @Parameter(names={"-l", "--level"}, description="The log level to set the threshold to.", required=true)
    private String _logLevel;

    @Override
    public CommandResult innerExecute(CLIContext context) {
        Console.ConsoleLevel level = null;
        try {
            level = Console.ConsoleLevel.valueOf(this._logLevel.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Console.ConsoleLevel[] knownLevels = Console.ConsoleLevel.values();
            StringBuilder knownLevelsStr = new StringBuilder();
            for (int i = 0; i < knownLevels.length; ++i) {
                knownLevelsStr.append(knownLevels[i].name());
                if (i >= knownLevels.length - 1) continue;
                knownLevelsStr.append(", ");
            }
            Console.error("Unknown log level [" + this._logLevel + "]. Known levels are: " + knownLevelsStr.toString());
            return CommandResult.BAD_ARGS;
        }
        Console.setLevel(level);
        Console.info("Logging level set to [" + level.name() + "].");
        return CommandResult.OK;
    }
}

